/*
 *	SILCHeartbeatPayload.java		2002/11/15
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;
import com.alistairphipps.util.Hex;

/** Class to implement a Heartbeat payload - heartbeat packets don't actually have payloads, but we have this so we can print something without getting a null pointer exception or complicating the other code with checks for null
 *
 * @author Alistair K Phipps
 * @version 20021115
 */
public class SILCHeartbeatPayload extends SILCPayload
{
	/** Constructor to set up the payload with default values.
	 */
	public SILCHeartbeatPayload() 
	{
	}

	/** Constructor to set up the payload information from a bytelist
	 * @param yl List of bytes forming received payload
	 */
	public SILCHeartbeatPayload( byte[] yl )
	{
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		return new byte[0];
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Heartbeat";
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}
}
