/*
 *	SILCNewClientPayload.java		2002/11/14
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.*;
import java.security.SecureRandom;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import com.alistairphipps.util.Hex;

/** Class to implement a New Client payload
 *
 * @author Alistair K Phipps
 * @version 20021114
 */
public class SILCNewClientPayload extends SILCPayload
{
	/** user name */
	private String _strUserName;

	/** real name */
	private String _strRealName;

	/** Constructor to set up the payload with values specified.
	 */
	public SILCNewClientPayload( String strUserName, String strRealName ) 
	{
		_strUserName = strUserName;
		_strRealName = strRealName;
	}

	/** Constructor to set up the payload information from a bytelist - the decrypted payload information received in a packet.
	 * @param yl List of bytes forming received payload
	 */
	public SILCNewClientPayload( byte[] yl )
	{
		ByteBuffer yb = ByteBuffer.wrap( yl );
	
		_strUserName = readShortAndString( yb );
		_strRealName = readShortAndString( yb );
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		// get byte buffers with UTF-8 encoded versions of strings - need to do this first to get the correct length (as UTF-8 could make the string longer)
		ByteBuffer ybUserName = writeShortAndString( _strUserName );
		ByteBuffer ybRealName = writeShortAndString( _strRealName );

		ByteBuffer yb = ByteBuffer.allocate( ybUserName.limit() + ybRealName.limit() );
		yb.put( ybUserName );
		yb.put( ybRealName );

		return yb.array();
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "User Name: " + _strUserName;
		strRet += "\nReal Name: " + _strRealName;
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}
}
