/*
 *	SILCSuccessPayload.java		2002/11/13
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;
import com.alistairphipps.util.Hex;

/** Class to implement a Success payload
 *
 * @author Alistair K Phipps
 * @version 20021113
 */
public class SILCSuccessPayload extends SILCPayload
{
	private byte[] _ylData;
	
	/** Constructor to set up the payload with default values.
	 */
	public SILCSuccessPayload() 
	{
		_ylData = new byte[4];	// default to 4-byte 0000 "OK" as used in KE auth and other places
	}

	/** Constructor to set up the payload information from a bytelist
	 * @param yl List of bytes forming received payload
	 */
	public SILCSuccessPayload( byte[] yl )
	{
		_ylData = yl;
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		return _ylData;
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Success Indication: " + Hex.toString( _ylData );
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}
}
