/*
 *	TestSILCHash.java		2002/11/12
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.test;

import java.nio.ByteBuffer;
import java.math.BigInteger;
import java.lang.String;
import com.alistairphipps.util.Hex;
import com.alistairphipps.jsilc.silcprotocol.*;
import org.bouncycastle.crypto.digests.*;
import org.bouncycastle.crypto.*;

/** Class to test how the SILC client hashing works (since mine doesn't right now!)
 *
 * @author Alistair K Phipps
 * @version 20021112
 */
public class TestSILCHash
{
	/** This is a KEY_EXCHANGE_START payload captured from the SILC client's auth sequence */
//	private static String strKES = "00 04 00 6A ED 46 FC 8B 4E 53 6B D9 07 FD 05 2C B8 CE DF 6E 00 15 53 49 4C 43 2D 31 2E 31 2D 30 2E 39 2E 38 20 73 65 72 76 65 72 00 15 64 69 66 66 69 65 2D 68 65 6C 6C 6D 61 6E 2D 67 72 6F 75 70 31 00 03 72 73 61 00 0B 61 65 73 2D 32 35 36 2D 63 62 63 00 04 73 68 61 31 00 0C 68 6D 61 63 2D 73 68 61 31 2D 39 36 00 00";

	/** This is the KES sent by the client */
private static String strKES = "00 04 01 6A  ED 46 FC 8B  4E 53 6B D9  07 FD 05 2C B8 CE DF 6E  00 15 53 49  4C 43 2D 31  2E 31 2D 30 2E 39 2E 37  20 63 6C 69  65 6E 74 00  2B 64 69 66 66 69 65 2D  68 65 6C 6C  6D 61 6E 2D  67 72 6F 75 70 31 2C 64  69 66 66 69  65 2D 68 65  6C 6C 6D 61 6E 2D 67 72  6F 75 70 32  00 0B 72 73  61 2C 72 73 61 2D 72 61  77 00 CA 61  65 73 2D 32  35 36 2D 63 62 63 2C 61  65 73 2D 31  39 32 2D 63  62 63 2C 61 65 73 2D 31  32 38 2D 63  62 63 2C 74  77 6F 66 69 73 68 2D 32  35 36 2D 63  62 63 2C 74  77 6F 66 69 73 68 2D 31  39 32 2D 63  62 63 2C 74  77 6F 66 69 73 68 2D 31  32 38 2D 63  62 63 2C 72  63 36 2D 32 35 36 2D 63  62 63 2C 72  63 36 2D 31  39 32 2D 63 62 63 2C 72  63 36 2D 31  32 38 2D 63  62 63 2C 6D 61 72 73 2D  32 35 36 2D  63 62 63 2C  6D 61 72 73 2D 31 39 32  2D 63 62 63  2C 6D 61 72  73 2D 31 32 38 2D 63 62  63 2C 63 61  73 74 2D 32  35 36 2D 63 62 63 2C 63  61 73 74 2D  31 39 32 2D  63 62 63 2C 63 61 73 74  2D 31 32 38  2D 63 62 63  2C 6E 6F 6E 65 00 08 73  68 61 31 2C  6D 64 35 00  2B 68 6D 61 63 2D 73 68  61 31 2D 39  36 2C 68 6D  61 63 2D 6D 64 35 2D 39  36 2C 68 6D  61 63 2D 73  68 61 31 2C 68 6D 61 63  2D 6D 64 35  00 00";


/*	private static String strKE = 

00000000  00 D8 00 01  00 00 00 D8  00 03 72 73  61 00 41 55  ..........rsa.AU
00000010  4E 3D 64 61  72 6B 66 6F  78 2C 20 48  4E 3D 61 6C  N=darkfox, HN=al
00000020  69 73 74 61  69 72 2C 20  52 4E 3D 41  6C 69 73 74  istair, RN=Alist
00000030  61 69 72 20  4B 20 50 68  69 70 70 73  2C 20 45 3D  air K Phipps, E=
00000040  64 61 72 6B  66 6F 78 40  61 6C 69 73  74 61 69 72  darkfox@alistair
00000050  00 00 00 04  00 00 00 7F  00 00 00 80  21 35 4E 92  ............!5N.
00000060  0A 8E 19 41  9C 19 CE B5  1E 5B BA 37  A9 9D 41 C5  ...A.....[.7..A.
00000070  CA 31 3A B8  FA 38 92 68  E2 E7 BA EB  46 64 04 AA  .1:..8.h....Fd..
00000080  98 EA 29 47  CE 60 D3 10  74 46 F5 BD  07 E7 D9 5B  ..)G.`..tF.....[
00000090  0F 9F 6E 04  48 84 BF F5  B9 D2 21 35  FB D2 D3 7B  ..n.H.....!5...{
000000A0  B9 55 E4 74  15 C5 97 42  06 95 1B AE  D8 97 96 CB  .U.t...B........
000000B0  5C FD E6 48  B6 BF 40 97  2C 96 7C 75  1D EB 42 DD  \..H..@.,.|u..B.
000000C0  39 73 3C B1  58 A1 40 DA  13 63 B5 13  C7 89 34 0B  9s<.X.@..c....4.
000000D0  BE D1 84 FB  22 64 96 3C  0F 9C 45 1F  00 80 6C 72  ...."d.<..E...lr
000000E0  0C CC 61 B7  B1 E3 93 DF  E7 B1 52 F2  43 3B 08 AB  ..a.......R.C;..
000000F0  D8 15 5A ED  3F D4 D1 AD  94 E9 65 90  8D EF 43 4A  ..Z.?.....e...CJ
00000100  6C A5 D4 1B  FB 5C 41 F4  12 C8 57 30  FA 41 8F D0  l....\A...W0.A..
00000110  EE 49 AD 10  19 F0 29 71  37 0A 9F 3D  2A DA B3 C1  .I....)q7..=*...
00000120  53 93 00 8C  F7 9C 69 BD  7C 2F F4 4E  CF 4B B1 13  S.....i.|/.N.K..
00000130  E9 FD D7 06  F6 84 21 5D  76 F1 27 F9  BC B7 0A 03  ......!]v.'.....
00000140  3A 3C 27 F0  78 C4 44 3F  A5 12 35 6B  F3 A8 95 46  :<'.x.D?..5k...F
00000150  32 AE B8 CD  20 76 DB 72  1E AA 47 33  55 0B 00 80  2... v.r..G3U...
00000160  1C 42 6E D9  42 DD CB BA  50 DC 7C 71  97 F1 B2 3B  .Bn.B...P.|q...;
00000170  D7 FA 21 74  01 58 71 19  F4 5B 97 8D  66 BF 36 A5  ..!t.Xq..[..f.6.
00000180  CA 5D 1F 61  3F 26 5C D6  8B C2 32 B1  09 1A 0B E6  .].a?&\...2.....
00000190  AC 86 B2 CC  D3 A3 EA 05  48 9E 01 34  12 C7 F4 2F  ........H..4.../
000001A0  B5 6E 1C CE  33 9C 33 5D  FF A2 A4 28  69 F4 A0 07  .n..3.3]...(i...
000001B0  76 40 6F AB  43 91 96 DD  A5 42 0A E5  93 6B 7B 7E  v@o.C....B...k{~
000001C0  44 24 F5 49  5F 13 32 50  17 0E FD CF  1C 20 AC 93  D$.I_.2P..... ..
000001D0  B1 44 EB 83  0C A8 E1 5E  00 8F A9 E0  A9 40 AA B2  .D.....^.....@..
*/

	
	/** pub key in above */
	private static String strPK = "00 00 00 D8 00 03 72 73 61 00 41 55 4E 3D 64 61 72 6B 66 6F 78 2C 20 48 4E 3D 61 6C 69 73 74 61 69 72 2C 20 52 4E 3D 41 6C 69 73 74 61 69 72 20 4B 20 50 68 69 70 70 73 2C 20 45 3D 64 61 72 6B 66 6F 78 40 61 6C 69 73 74 61 69 72 00 00 00 04 00 00 00 7F 00 00 00 80 21 35 4E 92 0A 8E 19 41 9C 19 CE B5 1E 5B BA 37 A9 9D 41 C5 CA 31 3A B8 FA 38 92 68 E2 E7 BA EB 46 64 04 AA 98 EA 29 47 CE 60 D3 10 74 46 F5 BD 07 E7 D9 5B 0F 9F 6E 04 48 84 BF F5 B9 D2 21 35 FB D2 D3 7B B9 55 E4 74 15 C5 97 42 06 95 1B AE D8 97 96 CB 5C FD E6 48 B6 BF 40 97 2C 96 7C 75 1D EB 42 DD 39 73 3C B1 58 A1 40 DA 13 63 B5 13 C7 89 34 0B BE D1 84 FB 22 64 96 3C 0F 9C 45 1F";

	/** D-H e in above - leading 0 added */
	private static String strE = "6C 72 0C CC 61 B7 B1 E3 93 DF E7 B1 52 F2 43 3B 08 AB D8 15 5A ED 3F D4 D1 AD 94 E9 65 90 8D EF 43 4A 6C A5 D4 1B FB 5C 41 F4 12 C8 57 30 FA 41 8F D0 EE 49 AD 10 19 F0 29 71 37 0A 9F 3D 2A DA B3 C1 53 93 00 8C F7 9C 69 BD 7C 2F F4 4E CF 4B B1 13 E9 FD D7 06 F6 84 21 5D 76 F1 27 F9 BC B7 0A 03 3A 3C 27 F0 78 C4 44 3F A5 12 35 6B F3 A8 95 46 32 AE B8 CD 20 76 DB 72 1E AA 47 33 55 0B";
	
	/** This is the hash_i value calculated by the server for the above packet */
	private static String strHash_i = "3C E7 29 A8 1E 9E D6 15 2D 1E A1 F2 96 18 C8 6D 89 A2 DD A4";
	
	public static void main( String[] args )
	{
		try
		{
			byte[] ylKES = Hex.fromString( strKES );
//			byte[] ylKE = Hex.fromString( strKE );
	//		byte[] ylHash_i = Hex.fromString( strHash_i );

			//SILCKeyExchangeStartPayload plKES = new SILCKeyExchangeStartPayload( ylKES );
		/*	SILCKeyExchangePayload plKE = new SILCKeyExchangePayload( ylKE );				// set up THEIR KE payload
			System.out.println( plKE.toString() );
			byte[] ylKE2 = plKE.toByteList();
	//		System.out.println( Hex.toString( ylKE ) );
	//		System.out.println( Hex.toString( ylKE2 ) );

	//		SILCKeyExchangePayload plKEMine = new SILCKeyExchangePayload( ylKES, true );	// set up MY KE payload

	//		System.out.println( plKEMine.toString() );

			byte[] ylHash = plKE.calculateHash_i( ylKES );*/
			System.out.println( "THEIR Hash_i: " + strHash_i );

			byte[] ylPK = Hex.fromString( strPK );
			byte[] ylE = Hex.fromString( strE );
			ByteBuffer yb = ByteBuffer.allocate( ylKES.length + ylPK.length + ylE.length );
			yb.put( ylKES );
			yb.put( ylPK );
			yb.put( ylE );
	
			Digest digest = new SHA1Digest();
			digest.reset();
			digest.update( yb.array(), 0, yb.array().length );
			byte[] ylHash = new byte[ digest.getDigestSize() ];
			digest.doFinal( ylHash, 0 );

			System.out.println( "MY Hash_i: " + Hex.toString( ylHash ) );

			// test vector
			String strTestVec = "6162636465666768696a6b6c6d6e6f707172737475767778797a";
    		String strResVec = "32d10c7b8cf96570ca04ce37f2a19d84240d3a89";

			digest.reset();
			digest.update( Hex.fromString( strTestVec ), 0, Hex.fromString( strTestVec ).length );
			digest.doFinal( ylHash, 0 );
			System.out.println( Hex.toString( ylHash ) );
			System.out.println( strResVec );
		}
		catch ( Exception e )
		{
			System.out.println( "Caught exception: " + e.toString() );
			e.printStackTrace();
		}
	}
}
