/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedKey;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KeyEncryptionAlgorithmIdentifier;

public class KEKRecipientInfo
extends CMSObject {
    private CMSVersion version;
    private KEKIdentifier kekid;
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
    private EncryptedKey encryptedKey;

    public KEKRecipientInfo(KEKIdentifier kEKIdentifier, KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier, EncryptedKey encryptedKey) {
        this.setKekid(kEKIdentifier);
        this.setKeyEncryptionAlgorithm(keyEncryptionAlgorithmIdentifier);
        this.setEncryptedKey(encryptedKey);
        this.setVersion();
    }

    public KEKRecipientInfo(ASN1Sequence aSN1Sequence) {
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(0));
        this.kekid = KEKIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.keyEncryptionAlgorithm = KeyEncryptionAlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(2));
        this.encryptedKey = EncryptedKey.getInstance(aSN1Sequence.getObjectAt(3));
    }

    public KEKRecipientInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.version = kEKRecipientInfo.version;
        this.kekid = kEKRecipientInfo.kekid;
        this.keyEncryptionAlgorithm = kEKRecipientInfo.keyEncryptionAlgorithm;
        this.encryptedKey = kEKRecipientInfo.encryptedKey;
    }

    public static KEKRecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KEKRecipientInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static KEKRecipientInfo getInstance(Object object) {
        if (object == null || object instanceof KEKRecipientInfo) {
            return (KEKRecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new KEKRecipientInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid KEKRecipientInfo: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public KEKIdentifier getKekid() {
        return this.kekid;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.kekid);
        bERConstructedSequence.addObject(this.keyEncryptionAlgorithm);
        bERConstructedSequence.addObject(this.encryptedKey);
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        this.setVersion(new CMSVersion(new BigInteger("4")));
    }

    private void setKekid(KEKIdentifier kEKIdentifier) {
        this.kekid = kEKIdentifier;
    }

    private void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithmIdentifier;
    }

    private void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }
}

