/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyWrapAlgorithm
extends CMSObject {
    private AlgorithmIdentifier alg;

    public KeyWrapAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public KeyWrapAlgorithm(ASN1Sequence aSN1Sequence) {
        this.alg = new AlgorithmIdentifier(aSN1Sequence);
    }

    public KeyWrapAlgorithm(KeyWrapAlgorithm keyWrapAlgorithm) {
        this.alg = keyWrapAlgorithm.alg;
    }

    public KeyWrapAlgorithm(DERObjectIdentifier dERObjectIdentifier) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    public KeyWrapAlgorithm(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier, dERObject);
    }

    public static KeyWrapAlgorithm getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new KeyWrapAlgorithm(AlgorithmIdentifier.getInstance(aSN1TaggedObject, bl));
    }

    public static KeyWrapAlgorithm getInstance(Object object) {
        if (object == null || object instanceof KeyWrapAlgorithm) {
            return (KeyWrapAlgorithm)object;
        }
        return new KeyWrapAlgorithm(AlgorithmIdentifier.getInstance(object));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }
}

