/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class MessageDigestAttribute
extends Attribute {
    protected MessageDigestAttribute() {
        this.attrType = CMSObjectIdentifiers.id_messageDigest;
    }

    public MessageDigestAttribute(ASN1Sequence aSN1Sequence) {
        this();
        this.attrValues = (ASN1Set)aSN1Sequence.getObjectAt(1);
    }

    public MessageDigestAttribute(Attribute attribute) {
        this();
        this.attrValues = attribute.attrValues;
    }

    public MessageDigestAttribute(byte[] byArray) {
        this();
        this.setDigest(byArray);
    }

    public MessageDigestAttribute(ASN1OctetString aSN1OctetString) {
        this();
        this.setDigest(aSN1OctetString);
    }

    public MessageDigestAttribute(MessageDigestAttribute messageDigestAttribute) {
        this();
        this.attrValues = messageDigestAttribute.attrValues;
    }

    public static Attribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return MessageDigestAttribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof MessageDigestAttribute) {
            return (MessageDigestAttribute)object;
        }
        if (object instanceof Attribute) {
            return new MessageDigestAttribute((Attribute)object);
        }
        if (object instanceof byte[]) {
            return new MessageDigestAttribute((byte[])object);
        }
        if (object instanceof ASN1OctetString) {
            return new MessageDigestAttribute((ASN1OctetString)object);
        }
        if (object instanceof ASN1Sequence) {
            return new MessageDigestAttribute((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid MessageDigestAttribute: " + object.getClass().getName());
    }

    public byte[] getDigest() {
        return ((DEROctetString)this.attrValues.getObjectAt(0)).getOctets();
    }

    private void setDigest(ASN1OctetString aSN1OctetString) {
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(aSN1OctetString);
    }

    private void setDigest(byte[] byArray) {
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(new DEROctetString(byArray));
    }
}

