/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class SignatureValue
extends CMSObject {
    private ASN1OctetString value;

    public SignatureValue(byte[] byArray) {
        this.setValue(byArray);
    }

    public SignatureValue(ASN1OctetString aSN1OctetString) {
        this.value = aSN1OctetString;
    }

    public SignatureValue(SignatureValue signatureValue) {
        this.value = signatureValue.value;
    }

    public static SignatureValue getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SignatureValue.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static SignatureValue getInstance(Object object) {
        if (object == null || object instanceof SignatureValue) {
            return (SignatureValue)object;
        }
        if (object instanceof ASN1OctetString) {
            return new SignatureValue((ASN1OctetString)object);
        }
        throw new IllegalArgumentException("Invalid SignatureValue: " + object.getClass().getName());
    }

    public byte[] getValue() {
        return this.value.getOctets();
    }

    public DERObject getDERObject() {
        return this.value;
    }

    private void setValue(byte[] byArray) {
        this.value = new BERConstructedOctetString(byArray);
    }
}

