/*
 *	ConnectionHandler.java		2002/10/31
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.core;

/** 
 * The ConnectionHandler interface provides methods to get and put events to a Connection Handler 
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public interface ConnectionHandler
{
	/**
	 * putEvent sends an event to the Handler.
	 * @param event the event to send.
	 */
	public void putEvent( OutEvent event );

	/**
	 * getEvent reads an event from the Handler - will block until there is one to receive.
	 * @return the event received.
	 */
	public InEvent getEvent();
}
