/*
 *	PrototypeMain.java		2002/11/05
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.prototype;

import java.lang.*;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.logging.*;
import java.security.SecureRandom;
import com.alistairphipps.jsilc.core.TCPConnection;
import com.alistairphipps.jsilc.silcprotocol.*;

/** 
 * Prototype Main class
 * @author Alistair K Phipps
 * @version 2002/11/14
 */
public class PrototypeMain
{
	/** logger is used for logging */
	private static Logger logger = Logger.getLogger( "com.alistairphipps.jsilc" );

	/**
	 * main method performs all the functions of the class; opening connection and inputting/outputting.
	 * @param strArgList should contain 2 parameters - hostname port.  No sanity checking is done on this.
	 */
	public static void main( String[] strArgList )
	{
		ConsoleHandler ch = new ConsoleHandler();
		ch.setLevel( Level.FINEST );
		logger.addHandler( ch );
		logger.setLevel( Level.FINEST );
		logger.setUseParentHandlers( false );
		logger.entering( "PrototypeMain", "main", strArgList );
		try
		{
			if( strArgList.length == 2 )
			{
				PrototypeMain pm = new PrototypeMain( strArgList[0], Integer.valueOf( strArgList[1] ).intValue() );
			}
			else
			{
				logger.severe( "Require 2 arguments - hostname port" );
			}
		}
		catch( Exception e )
		{
			logger.severe( "Caught exception: " + e.toString() );
			e.printStackTrace();
		}
		finally
		{
			logger.exiting( "PrototypeMain", "main" );
		}
	}

	/** open connection to host/port
	 * @param strHost name of host to connect to
	 * @param iPort port number to connect to
	 */
	public PrototypeMain( String strHost, int iPort ) throws Exception
	{
		logger.entering( "PrototypeMain", "PrototypeMain" );		
		// open connection
		logger.info( "Opening connection" );
		SILCConnection conn = new SILCConnection( "jSilcProto", strHost, iPort );
		logger.info( "Showing received packets" );
		SILCPacket p;
		while( true )
		{
			p = conn.getPacket();
			logger.info( "Received packet: \n" + p.toString() ); 
		}
	//	logger.exiting( "PrototypeMain", "PrototypeMain" );
	}

}
