/*
 *	SILCCommandType.java		2002/11/15
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;

/** Defines different Command Types that can be sent/received.
 *
 * @author Alistair K Phipps
 * @version 20021115
 */
public class SILCCommandType
{
	/** should not be sent */
	public static final byte NONE = 0;
	/** get info about user */
	public static final byte WHOIS = 1;
	/** query history about user */
	public static final byte WHOWAS = 2;
	/** query information about entity */
	public static final byte IDENTIFY = 3;
	/** set/change nickname */
	public static final byte NICK = 4;
	/** list channels and topics */
	public static final byte LIST = 5;
	/** change topic on channel */
	public static final byte TOPIC = 6;
	/** invite user to channel */
	public static final byte INVITE = 7;
	/** end silc session */
	public static final byte QUIT = 8;
	/** remove client from network */
	public static final byte KILL = 9;
	/** fetch info about server */
	public static final byte INFO = 10;
	/** fetch stats from server */
	public static final byte STATS = 11;
	/** test comms to server */
	public static final byte PING = 12;
	/** become operator */
	public static final byte OPER = 13;
	/** join channel */
	public static final byte JOIN = 14;
	/** retrieve message of the day */
	public static final byte MOTD = 15;
	/** set user mode */
	public static final byte UMODE = 16;
	/** set channel mode */
	public static final byte CMODE = 17;
	/** set mode for a user on a channel */
	public static final byte CUMODE = 18;
	/** kick user from channel */
	public static final byte KICK = 19;
	/** ban user from channel */
	public static final byte BAN = 20;
	/** detach client session */
	public static final byte DETACH = 21;
	/** watch user (notification when they go on/offline) */
	public static final byte WATCH = 22;
	/** become silc (router) operator */
	public static final byte SILCOPER = 23;
	/** leave channel */
	public static final byte LEAVE = 24;
	/** list users on channel */
	public static final byte USERS = 25;
	/** fetch public key of client or server */
	public static final byte GETKEY = 26;
	/** negotiate service agreement with remote server */
	public static final byte SERVICE = 27;

	
	public static String toString( byte y )
	{
		switch( y )
		{
		case NONE:
			return "None";
		case WHOIS:
			return "Whois";
		case WHOWAS:
			return "Whowas";
		case IDENTIFY:
			return "Identify";
		case NICK:
			return "Nick";
		case LIST:
			return "List";
		case TOPIC:
			return "Topic";
		case INVITE:
			return "Invite";
		case QUIT:
			return "Quit";
		case KILL:
			return "Kill";
		case INFO:
			return "Info";
		case STATS:
			return "Stats";
		case PING:
			return "Ping";
		case OPER:
			return "Oper";
		case JOIN:
			return "Join";
		case MOTD:
			return "Motd";
		case UMODE:
			return "UMode";
		case CMODE:
			return "CMode";
		case CUMODE:
			return "CUMode";
		case KICK:
			return "Kick";
		case BAN:
			return "Ban";
		case DETACH:
			return "Detach";
		case WATCH:
			return "Watch";
		case SILCOPER:
			return "SILCOper";
		case LEAVE:
			return "Leave";
		case USERS:
			return "Users";
		case GETKEY:
			return "Getkey";
		case SERVICE:
			return "Service";
		default:
			return "Unknown";
		}
	}
}

