/*
 *	SILCIdPayload.java		2002/11/14
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.nio.ByteBuffer;
import java.math.BigInteger;
import com.alistairphipps.util.Hex;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import com.alistairphipps.util.UBigInteger;

/** Class to implement a SILC Id Payload
 *
 * @author Alistair K Phipps
 * @version 20021114
 */
public class SILCIdPayload extends SILCPayload
{
	/** Type of Id */
	private byte _yIdType;

	/** Id Data */
	private byte[] _ylId;
	
	/** Constructor to initialise from provided values (for sending) */
	public SILCIdPayload( byte yIdType, byte[] ylId )
	{
		_yIdType = yIdType;
		_ylId = ylId;
	}
	
	/** Constructor to initialise from a received byte list */
	public SILCIdPayload( byte[] yl )
	{		
		ByteBuffer yb = ByteBuffer.wrap( yl );
		_yIdType = (byte)yb.getShort();	// for some reason it's stored as a short
		short sIdLength = yb.getShort();
		assert( ( 4 + sIdLength & 0xFFFF ) == yl.length );
		_ylId = new byte[ sIdLength & 0xFFFF ];
		yb.get( _ylId );
	}
	
	public byte[] toByteList()
	{
		ByteBuffer yb = ByteBuffer.allocate( 4 + _ylId.length );
		yb.putShort( (short)( _yIdType & 0xFF ) );
		yb.putShort( (short)_ylId.length );
		yb.put( _ylId );
		return yb.array();
	}

	public String toString()
	{
		String strRet;
		strRet = "Id Type: " + SILCIdType.toString( _yIdType );
		strRet += "\nId: " + Hex.toString( _ylId );
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}

	public byte getIdType()
	{
		return _yIdType;
	}

	public byte[] getId()
	{
		return _ylId;
	}
}
