/*
 *	SILCNotifyType.java		2002/11/15
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;

/** Defines different Notify Types that can be sent/received.
 *
 * @author Alistair K Phipps
 * @version 20021115
 */
public class SILCNotifyType
{
	/** when no specific notification can be used */
	public static final short NONE = 0;
	/** client invited to channel */
	public static final short INVITE = 1;
	/** client joined channel */
	public static final short JOIN = 2;
	/** client left channel */
	public static final short LEAVE = 3;
	/** client on channel signed off */
	public static final short SIGNOFF = 4;
	/** topic set on channel */
	public static final short TOPIC_SET = 5;
	/** someone on channel changed nick */
	public static final short NICK_CHANGE = 6;
	/** channel mode changed */
	public static final short CMODE_CHANGE = 7;
	/** user mode on channel changed */
	public static final short CUMODE_CHANGE = 8;
	/** message of the day */
	public static final short MOTD = 9;
	/** channel ID has changed */
	public static final short CHANNEL_CHANGE = 10;
	/** server disconnected from network */
	public static final short SERVER_SIGNOFF = 11;
	/** client has been kicked from a channel */
	public static final short KICKED = 12;
	/** client has been killed on channel you are on */
	public static final short KILLED = 13;
	/** user mode change (not sent to client) */
	public static final short UMODE_CHANGE = 14;
	/** ban list of channel changed (not sent to client) */
	public static final short BAN = 15;
	/** error occurred during silc procedure */
	public static final short ERROR = 16;
	/** change in watched user */
	public static final short WATCH = 17;
	
	public static String toString( short s )
	{
		switch( s )
		{
		case NONE:
			return "None";
		case INVITE:
			return "Invite";
		case JOIN:
			return "Join";
		case LEAVE:
			return "Leave";
		case SIGNOFF:
			return "Signoff";
		case TOPIC_SET:
			return "Topic set";
		case NICK_CHANGE:
			return "Nick change";
		case CMODE_CHANGE:
			return "Channel mode change";
		case CUMODE_CHANGE:
			return "User mode on channel change";
		case MOTD:
			return "Message of the day";
		case CHANNEL_CHANGE:
			return "Channel ID Change";
		case SERVER_SIGNOFF:
			return "Server Signoff";
		case KICKED:
			return "Kicked";
		case KILLED:
			return "Killed";
		case UMODE_CHANGE:
			return "User mode change";
		case BAN:
			return "Ban";
		case ERROR:
			return "Error";
		case WATCH:
			return "Watch";
		default:
			return "Unknown";
		}
	}
}

