/*
 *	SILCPacketType.java		2002/11/08
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;

/** Defines different Packet Types that can be sent/received.
 *
 * @author Alistair K Phipps
 * @version 20021108
 */
public class SILCPacketType
{
	/** packet type reserved and never sent */
	public static final byte NONE = 0;
	/** packet sent to disconnect the remote end - not usually sent by client */
	public static final byte DISCONNECT = 1;
	/** packet sent upon successful execution of some protocol */
	public static final byte SUCCESS = 2;
	/** packet sent upon failure of some protocol */
	public static final byte FAILURE = 3;
	/** packet sent upon rejection of some protocol */
	public static final byte REJECT = 4;
	/** packet used to send notify messages (from server to client) */
	public static final byte NOTIFY = 5;
	/** packet sent when an error occurs (from server to client) - can be ignored by client */
	public static final byte ERROR = 6;
	/** packet used to send message to channels */
	public static final byte CHANNEL_MESSAGE = 7;
	/** packet used to distribute new key for a channel */
	public static final byte CHANNEL_KEY = 8;
	/** packet used to send private messages from client to another client */
	public static final byte PRIVATE_MESSAGE = 9;
	/** packet used to agree about a key to be used to protect private messages between 2 clients */
	public static final byte PRIVATE_MESSAGE_KEY = 10;
	/** packet used to send commands from client to server */
	public static final byte COMMAND = 11;
	/** packet sent as a reply to COMMAND packet */
	public static final byte COMMAND_REPLY = 12;
	/** packet used to start SILC Key Exchange protocol */
	public static final byte KEY_EXCHANGE = 13;
	/** packet used as part of SILC Key Exchange protocol */
	public static final byte KEY_EXCHANGE_1 = 14;
	/** packet used as part of SILC Key Exchange protocol */
	public static final byte KEY_EXCHANGE_2 = 15;
	/** packet used to request auth method to be used in the SILC Connection Authentication protocol */
	public static final byte CONNECTION_AUTH_REQUEST = 16;
	/** packet used to start and perform the SILC Connection Authentication protocol */
	public static final byte CONNECTION_AUTH = 17;
	/** packet used to distribute new IDs from server to router and from router to all routers in SILC network */
	public static final byte NEW_ID = 18;
	/** packet used by client to register itself to SILC network */
	public static final byte NEW_CLIENT = 19;
	/** packet used by server to register itself to the SILC network */
	public static final byte NEW_SERVER = 20;
	/** packet used to notify routers about newly created channel */
	public static final byte NEW_CHANNEL = 21;
	/** packet used to indicate that a rekey must be performed for session keys */
	public static final byte REKEY = 22;
	/** packet used to indicate that a rekey has been performed and new keys must be used hereafter */
	public static final byte REKEY_DONE = 23;
	/** packet used to keep connection alive */
	public static final byte HEARTBEAT = 24;
	/** packet used by clients to request key negotiation with another client on the SILC network - if started done with SKE protocol */
	public static final byte KEY_AGREEMENT = 25;
	/** packet used during backup router protocol when primary router comes back online */
	public static final byte RESUME_ROUTER = 26;
	/** packet used to perform a file transfer with some entity in SILC network */
	public static final byte FTP = 27;
	/** packet used to resume client on network after it has been detached */
	public static final byte RESUME_CLIENT = 28;
	// 29-199 undefined
	// 200-254 reserved for private use and will not be defined
	/** reserved for future extensions and must not be sent */
	public static final byte MAX = (byte)255 ;	// will actually get set to -1

	public static String toString( byte y )
	{
		switch( y )
		{
		case NONE:
			return "None";
		case DISCONNECT:
			return "Disconnect";
		case SUCCESS:
			return "Success";
		case FAILURE:
			return "Failure";
		case REJECT:
			return "Reject";
		case NOTIFY:
			return "Notify";
		case ERROR:
			return "Error";
		case CHANNEL_MESSAGE:
			return "Channel Message";
		case CHANNEL_KEY:
			return "Channel Key";
		case PRIVATE_MESSAGE:
			return "Private Message";
		case PRIVATE_MESSAGE_KEY:
			return "Private Message Key";
		case COMMAND:
			return "Command";
		case COMMAND_REPLY:
			return "Command Reply";
		case KEY_EXCHANGE:
			return "Key Exchange";
		case KEY_EXCHANGE_1:
			return "Key Exchange 1";
		case KEY_EXCHANGE_2:
			return "Key Exchange 2";
		case CONNECTION_AUTH_REQUEST:
			return "Connection Authentication Request";
		case CONNECTION_AUTH:
			return "Connection Authentication";
		case NEW_ID:
			return "New ID";
		case NEW_CLIENT:
			return "New Client";
		case NEW_SERVER:
			return "New Server";
		case NEW_CHANNEL:
			return "New Channel";
		case REKEY:
			return "Rekey";
		case REKEY_DONE:
			return "Rekey Done";
		case HEARTBEAT:
			return "Heartbeat";
		case KEY_AGREEMENT:
			return "Key Agreement";
		case RESUME_ROUTER:
			return "Resume Router";
		case FTP:
			return "FTP";
		case RESUME_CLIENT:
			return "Resume Client";
		default:
			return "Unknown";
		}
	}
}

