/*
 *	TestTCPConnection.java		2002/10/24
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.test;

import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.logging.*;
import com.alistairphipps.jsilc.core.TCPConnection;

/** 
 * The TestTCPConnection class is a simple test harness for the TCPConnection class, opening a connection to a server:port specified on the command line and sending stdin to it and outputting data received from it to stdout.
 * @author Alistair K Phipps
 * @version 2002/10/24
 */
public class TestTCPConnection
{
	/** logger is used for logging */
	private static Logger logger = Logger.getLogger( "com.alistairphipps.jsilc.test.testtcpconnection" );


	/**
	 * TestTCPConnection main method performs all the functions of the class; opening connection and inputting/outputting.
	 * @param strArgList should contain 2 parameters - hostname port.  No sanity checking is done on this.
	 */
	public static void main( String[] strArgList )
	{
		logger.entering( "TestTCPConnection", "main", strArgList );
		try
		{
			if( strArgList.length == 2 )
			{
				logger.info( "Opening connection to " + strArgList[0] + ":" + strArgList[1] );
				TCPConnection conn = new TCPConnection( strArgList[0], ( new Integer( strArgList[1] ) ).intValue() );
				logger.info( "TCPConnection opened" );
				while( true )
				{
					byte[] in = conn.readData(1);
					System.out.write( in );
				}
			}
			else
			{
				logger.info( "Require 2 arguments - hostname port" );
			}
		}
		catch( Exception e )
		{
			logger.severe( "Caught exception: " + e.toString() );
			e.printStackTrace();
		}
		finally
		{
			logger.exiting( "TestTCPConnection", "main" );
		}
	}
}
