/*
 *	Hex.java		2002/11/12
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.util;

import java.lang.String;

/** Class to provide conversions for byte lists to hex strings
 * @author Alistair Phipps
 * @version 20021112
 */
public class Hex
{
	/** Array of symbols used for hex numbers */
	private static char[] nums = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

	/** Converts byte list to hex string
	 * @param yl byte list
	 * @return String in hex "00 00 00 00"
	 */
	public static String toString( byte[] yl )
	{
		String str = "";
		for( int i = 0; i < yl.length; i++ )
		{
			str += nums[ ( yl[i] & 0xF0 ) >> 4 ];
			str += nums[ yl[i] & 0x0F ];
			str += ' ';
		}
		return str;
	}

	/** Convert hex string in "00 00 00" format to byte list
	 * @param str hex string
	 * @return byte list
	 */
	public static byte[] fromString( String str )
	{
		str = str.toUpperCase();
		String str2 = "";
		for( int i = 0; i < str.length(); i++ )
		{
			if( ( str.charAt(i) >= '0' && str.charAt(i) <= '9' ) || ( str.charAt(i) >= 'A' && str.charAt(i) <= 'F' ) )
				str2 += str.charAt(i);
		}
		byte[] yl = new byte[ str2.length() / 2 ];
		for( int i = 0; i < str2.length(); i+=2 )
		{
			yl[i / 2] = (byte)( ( Character.digit( str2.charAt(i), 16 ) << 4 ) + Character.digit( str2.charAt(i+1),16 ) );
		}
		return yl;
	}
}
