/*

  route.c

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2000 - 2002 Pekka Riikonen

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

*/
/* 
 * Route cache routines. Server uses these to route packets to specific
 * routes. If route entry doesn't exist for a specific destination, server
 * uses primary route (default route).
 */
/* XXX Adding two ID's with same IP number replaces the old entry thus
   gives wrong route. Thus, now disabled until figured out a better way
   to do this or when removed the whole thing. This could be removed
   because entry->router->connection gives always the most optimal route
   for the ID anyway (unless new routes (faster perhaps) are established
   after receiving this ID, this we don't know however). */
/* $Id: route.c,v 1.11.2.1 2004/06/18 17:29:26 priikone Exp $ */

#include "serverincludes.h"
#include "server_internal.h"
#include "route.h"

/* Route cache hash table */
SilcServerRouteTable silc_route_cache[SILC_SERVER_ROUTE_SIZE];

/* Adds new route to the route cache. The argument `index' is the
   index value generated by silc_server_route_hash. */

void silc_server_route_add(SilcUInt32 index, unsigned int dest,
			   SilcServerEntry router)
{
  silc_route_cache[index].dest = dest;
  silc_route_cache[index].router = router;
}

/* Checksk whether destination has a specific router. Returns the
   router data if found, NULL otherwise. */

SilcServerEntry silc_server_route_check(SilcUInt32 dest, 
					SilcUInt16 port)
{
  SilcUInt32 index;

  index = silc_server_route_hash(dest, port);

  if (silc_route_cache[index].router != NULL &&
      silc_route_cache[index].dest == dest)
    return silc_route_cache[index].router;

  return NULL;
}

/* Returns the connection object for the fastest route for the given ID.
   If we are normal server then this just returns our primary route. If
   we are router we will do route lookup. */

SilcSocketConnection silc_server_route_get(SilcServer server, void *id,
					   SilcIdType id_type)
{
  if (server->server_type == SILC_ROUTER) {
    SilcUInt32 dest = 0;
    SilcUInt16 port = 0;
    SilcServerEntry router = NULL;
#if 0

    switch(id_type) {
    case SILC_ID_CLIENT:
      dest = ((SilcClientID *)id)->ip.s_addr;
      port = server->id->port;
      break;
    case SILC_ID_SERVER:
      dest = ((SilcServerID *)id)->ip.s_addr;
      port = ((SilcServerID *)id)->port;
      break;
    case SILC_ID_CHANNEL:
      dest = ((SilcChannelID *)id)->ip.s_addr;
      port = ((SilcChannelID *)id)->port;
      break;
    default:
      return NULL;
    }

#endif

    router = silc_server_route_check(dest, port);
    if (router)
        return (SilcSocketConnection)router->connection;
  }

  return (server->id_entry->router) 
       ? (SilcSocketConnection)server->id_entry->router->connection
       : NULL;
}
