Summary: SILC Runtime Toolkit
Name: srt
Version: 1.2-beta3
Release: 0.fc8
License: GPL/BSD dual licensed
Group: System Environment/Libraries
URL: http://silcnet.org/
Source0: srt-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: pkgconfig
Epoch: 0

%description
SILC Runtime Toolkit provides a full featured runtime library for
applications.  It provides the application's main loop, threads, locks,
file utilities, file streams, socket streams, TCP and UDP network routines,
a finite state machine, lists, a hash table, UTF-8 routines and other string
utilities, and many other utility routines.  The library works on multiple
platforms.

%package devel
Group: Development/Libraries
Summary: SILC Runtime Toolkit providing headers, libraries and documentation
Requires: srt = %{epoch}:%{version}-%{release}
Requires: pkgconfig

%description devel
SILC Runtime Toolkit development libraries, headers and documentation.
SILC Runtime Toolkit provides a full featured runtime library for
applications.  It provides the application's main loop, threads, locks,
file utilities, file streams, socket streams, TCP and UDP network routines,
a finite state machine, lists, a hash table, UTF-8 routines and other string
utilities, and many other utility routines.  The library works on multiple
platforms.

%prep
%setup -q -n srt-%{version}

%build
%configure --libdir=%{_libdir} \
           --includedir=%{_includedir}/srt \
           --docdir=%{_docdir}/%{name}-%{version}
make -j4

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
chmod 0755 ${RPM_BUILD_ROOT}%{_libdir}/lib*

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(0755, root, root, 0755)
%{_libdir}/libsrt-1.2.so*
%dir %_libdir/srt
%defattr(0644, root, root, 0755)
%doc CHANGES COPYING GPL BSD

%files devel
%defattr(0644, root, root, 0755)
%doc CHANGES COPYING GPL BSD doc/runtime
%{_libdir}/libsrt.so
%{_libdir}/libsrt.*a
%{_libdir}/pkgconfig/srt.pc
%dir %_includedir/srt
%{_includedir}/srt/*.h

%changelog
* Sun Jan 27 2008 Pekka Riikonen <priikone@silcnet.org>
- Initial version for Fedora
