const char *default_config =
"#\n"
"# Configured servers\n"
"#\n"
"# silc.silcnet.org is DNS round robin for all (currently) known public SILCNet servers.\n"
"#\n"
"servers = (\n"
"  { address = \"silc.silcnet.org\"; chatnet = SILCNet; port = 706; autoconnect = \"yes\"; }\n"
");\n"
"\n"
"#\n"
"# Configured chat networks\n"
"#\n"
"chatnets = {\n"
"  SILCNet = { type = \"SILC\"; };\n"
"};\n"
"\n"
"#\n"
"# Configured channels\n"
"#\n"
"channels = (\n"
"  { name = \"silc\"; chatnet = SILCNet; autojoin = No; }\n"
");\n"
"\n"
"#\n"
"# Keyboard bindings (BIND command)\n"
"#\n"
"keyboard = (\n"
"  { key = \"meta-K\"; id = \"command\"; data = \"key channel * change\"; }\n"
"); \n"
"\n"
"#\n"
"# Your favorite aliases\n"
"#\n"
"aliases = {\n"
"  LEAVE = \"part\";\n"
"  BYE = \"quit\";\n"
"  EXIT = \"quit\";\n"
"  SIGNOFF = \"quit\";\n"
"  DESCRIBE = \"action\";\n"
"  LAST = \"lastlog\";\n"
"  SAY = \"msg *\";\n"
"  WHO = \"users *\";\n"
"  WI = \"whois\";\n"
"  WII = \"whois $0 $0\";\n"
"  WW = \"whowas\";\n"
"  W = \"who\";\n"
"  N = \"names\";\n"
"  M = \"msg\";\n"
"  T = \"topic\";\n"
"  C = \"clear\";\n"
"  CL = \"clear\";\n"
"  K = \"kick\";\n"
"  KB = \"kickban\";\n"
"  KN = \"knockout\";\n"
"  BANS = \"ban\";\n"
"  B = \"ban\";\n"
"  IG = \"ignore\";\n"
"  UNIG = \"unignore\";\n"
"  SB = \"scrollback\";\n"
"  WC = \"window close\";\n"
"  WN = \"window new hide\";\n"
"  GOTO = \"sb goto\";\n"
"  ADMIN = \"info\";\n"
"  RUN = \"SCRIPT LOAD\";\n"
"  UPTIME = \"eval exec - expr `date +%s` - \\\\$F | awk '{print \\\"Irssi uptime: \\\"int(\\\\\\\\\\\\$1/3600/24)\\\"d \\\"int(\\\\\\\\\\\\$1/3600%24)\\\"h \\\"int(\\\\\\\\\\\\$1/60%60)\\\"m \\\"int(\\\\\\\\\\\\$1%60)\\\"s\\\" }'\";\n"
"  CALC = \"exec - if which bc &>/dev/null\\\\; then echo '$*' | bc | awk '{print \\\"$*=\\\"$$1}'\\\\; else echo bc was not found\\\\; fi\";\n"
"  SBAR = \"STATUSBAR\";\n"
"  Q = \"QUERY\";\n"
"  MOOD = \"ATTR status_mood\";\n"
"  OP = \"CUMODE $C +o\";\n"
"  DEOP = \"CUMODE $C -o\";\n"
"};\n"
"\n"
"#\n"
"# Configuration for statusbar and other bars that appear on the screen\n"
"#\n"
"statusbar = {\n"
"  # formats:\n"
"  # when using {templates}, the template is shown only if it's argument isn't\n"
"  # empty unless no argument is given. for example {sb} is printed always,\n"
"  # but {sb $T} is printed only if $T isn't empty.\n"
"\n"
"  items = {\n"
"    # start/end text in statusbars\n"
"    barstart = \"{sbstart}\";\n"
"    barend = \"{sbend}\";\n"
"\n"
"    # treated \"normally\", you could change the time/user name to whatever\n"
"    time = \"{sb $Z}\";\n"
"    user = \"{sb $cumode$N{sbaway $A}}\";\n"
"    usermode = \" {sbusermode $usermode}\";\n"
"    topic = \" $topic\";\n"
"    topic_empty = \" Irssi v$J - http://irssi.org/help/\";\n"
"\n"
"    # treated specially .. window is printed with non-empty windows,\n"
"    # window_empty is printed with empty windows\n"
"    window = \"{sb $winref:$T{sbmode $M}}\";\n"
"    window_empty = \"{sb $winref{sbservertag $tag}}\";\n"
"    prompt = \"{prompt $[.15]T}\";\n"
"    prompt_empty = \"{prompt $winname}\";\n"
"\n"
"    # all of these treated specially, they're only displayed when needed\n"
"    lag = \"{sb Lag: $0-}\";\n"
"    act = \"{sb Act: $0-}\";\n"
"    more = \"-- more --\";\n"
"  };\n"
"\n"
"  # there's two type of statusbars. root statusbars are either at the top\n"
"  # of the screen or at the bottom of the screen. window statusbars are at\n"
"  # the top/bottom of each split window in screen.\n"
"  default = {\n"
"    # the \"default statusbar\" to be displayed at the bottom of the window.\n"
"    # contains all the normal items.\n"
"    window = {\n"
"      disabled = \"no\";\n"
"\n"
"      # window, root\n"
"      type = \"window\";\n"
"      # top, bottom\n"
"      placement = \"bottom\";\n"
"      # number\n"
"      position = \"1\";\n"
"      # active, inactive, always\n"
"      visible = \"active\";\n"
"\n"
"      # list of items in statusbar in the display order\n"
"      items = {\n"
"        barstart = { priority = \"100\"; };\n"
"        time = { };\n"
"        user = { };\n"
"        window = { };\n"
"        window_empty = { };\n"
"        lag = { priority = \"-1\"; };\n"
"        act = { priority = \"10\"; };\n"
"        usermode = { priority = \"-1\"; };\n"
"        more = { priority = \"10\"; alignment = \"right\"; };\n"
"        barend = { priority = \"100\"; alignment = \"right\"; };\n"
"      };\n"
"    };\n"
"\n"
"    # statusbar to use in inactive split windows\n"
"    window_inact = {\n"
"      type = \"window\";\n"
"      placement = \"bottom\";\n"
"      position = \"1\";\n"
"      visible = \"inactive\";\n"
"      items = {\n"
"        barstart = { priority = \"100\"; };\n"
"        window = { };\n"
"	window_empty = { };\n"
"        more = { priority = \"-1\"; alignment = \"right\"; };\n"
"        barend = { priority = \"100\"; alignment = \"right\"; };\n"
"      };\n"
"    };\n"
"\n"
"    # we treat input line as yet another statusbar :) It's possible to\n"
"    # add other items before or after the input line item.\n"
"    prompt = {\n"
"      type = \"root\";\n"
"      placement = \"bottom\";\n"
"      # we want to be at the bottom always\n"
"      position = \"100\";\n"
"      visible = \"always\";\n"
"      items = {\n"
"        prompt = { priority = \"-1\"; };\n"
"        prompt_empty = { priority = \"-1\"; };\n"
"        # treated specially, this is the real input line.\n"
"        input = { priority = \"10\"; };\n"
"      };\n"
"    };\n"
"\n"
"    # topicbar\n"
"    topic = {\n"
"      type = \"root\";\n"
"      placement = \"top\";\n"
"      position = \"1\";\n"
"      visible = \"always\";\n"
"      disabled = \"no\";\n"
"      items = {\n"
"        barstart = { priority = \"100\"; };\n"
"        topic = { };\n"
"        topic_empty = { };\n"
"        barend = { priority = \"100\"; alignment = \"right\"; };\n"
"      };\n"
"    };\n"
"  };\n"
"};\n"
"\n"
"#\n"
"# Settings (can be changed with /SET command)\n"
"#\n"
"# You can set the default cipher, hash function and HMAC to be used\n"
"# as setting as well.  You can set it here or use the /SET command.\n"
"#\n"
"# Available ciphers are (default: aes-256-cbc):\n"
"#\n"
"# aes-256-cbc, aes-192-cbc, aes-128-cbc,\n"
"# twofish-256-cbc, twofish-192-cbc, twofish-128-cbc,\n"
"# rc6-256-cbc, rc6-192-cbc, rc6-128-cbc, \n"
"# cast-256-cbc, cast-192-cbc and cast-128-cbc\n"
"#\n"
"# Available hash functions are (default: sha1):\n"
"#\n"
"# sha1 and md5\n"
"#\n"
"# Available HMAC's are (default: hmac-sha1-96):\n"
"#\n"
"# hmac-sha1-96, hmac-md5-96, hmac-sha1 and hmac-md5\n"
"#\n"
"settings = {\n"
"  \"server\" = {\n"
"    crypto_default_cipher = \"aes-256-cbc\";\n"
"    crypto_default_hash = \"sha1\";\n"
"    crypto_default_hmac = \"hmac-sha1-96\";\n"
"  };\n"
"  \"fe-common/core\" = {\n"
"    autocreate_own_query = \"yes\";\n"
"    use_status_window = \"no\";\n"
"    autoclose_windows = \"no\";\n"
"    use_msgs_window = \"no\";\n"
"    autocreate_windows = \"yes\";\n"
"    autocreate_query_level = \"MSG\";\n"
"    reuse_unused_windows = \"yes\";\n"
"  };\n"
"  core = {\n"
"    server_reconnect_time = \"10000\";\n"
"    resolve_reverse_lookup = \"yes\";\n"
"  };\n"
"  \"fe-text\" = { indent = \"8\"; };\n"
"};\n"
;
