/* MD5 Production Implementation                                              */
/* This implementation: (c) 1999 Andreas Steinmetz                            */
/* MD5 algorithm by Ron Rivest, see RFC1321                                   */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2202                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact astmail@yahoo.com           */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation is processor independent.                     */
/* It does not depend on any run time library and                             */
/* should be 64 bit clean.                                                    */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the MD5 routines.                               */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for MD5 transformation    WORD08[64]                            */
/* resulting MD5 or HMAC hash           WORD08[16]                            */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* MD5_FULL defined:                                                          */
/*                                                                            */
/* 1. Call md5init                                                            */
/* 2. For all data to be hashed call md5next                                  */
/* 3. To retrieve the hash call md5end                                        */
/*                                                                            */
/* MD5_FAST defined:                                                          */
/*                                                                            */
/* Call md5 to get the hash for the specified data                            */
/*                                                                            */
/* MD5_HMAC_FULL defined:                                                     */
/*                                                                            */
/* 1. Call md5hmkey once to preprocess the selected key                       */
/* 2. Call md5hminit                                                          */
/* 3. For all data to be hashed call md5hmnext                                */
/* 4. To retrieve the hash call md5hmend                                      */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the MD5HMDATA structure                                           */
/*                                                                            */
/* MD5_HMAC_FAST defined:                                                     */
/*                                                                            */
/* 1. Call md5hmkey once to preprocess the selected key                       */
/* 2. Call md5hmac to get the hash for the specified data                     */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the MD5HMDATA structure                                           */

.text

.ifdef	MD5_HMAC_FULL
		_MD5_HMAC=1
.endif
.ifdef	MD5_HMAC_FAST
		_MD5_HMAC=1
.endif
.ifdef	MD5_FULL
		_MD5_FULL=1
.endif
.ifdef	_MD5_HMAC
		_MD5_FULL=1
		MD5_PARANOID=1
.endif

/* static void md5block(WORD32 *md5,WORD08 *block) */

		.align	16
md5block:
		pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi

		movl	24(%esp),%eax
		movl	20(%esp),%ebx
		movl	(%ebx),%ebp
		movl	4(%ebx),%esi
		movl	8(%ebx),%ecx
		movl	12(%ebx),%edx
		pushl	%ebx
		leal	md5tab,%edi

		movl	$4,%ebx
		pushl	%ebx
		pushl	%ebx
		pushl	%ebx
roundone:	pushl	%ebx

		movl	%edx,%ebx
		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		addl	%ebx,%ebp
		movzbl	16(%edi),%ebx
		addl	(%edi),%ebp
		addl	(%eax,%ebx,4),%ebp
		roll	$7,%ebp
		addl	%esi,%ebp

		movl	%ecx,%ebx
		xorl	%esi,%ebx
		andl	%ebp,%ebx
		xorl	%ecx,%ebx
		addl	%ebx,%edx
		movzbl	17(%edi),%ebx
		addl	4(%edi),%edx
		addl	(%eax,%ebx,4),%edx
		roll	$12,%edx
		addl	%ebp,%edx

		movl	%esi,%ebx
		xorl	%ebp,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		addl	%ebx,%ecx
		movzbl	18(%edi),%ebx
		addl	8(%edi),%ecx
		addl	(%eax,%ebx,4),%ecx
		roll	$17,%ecx
		addl	%edx,%ecx

		movl	%ebp,%ebx
		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%ebp,%ebx
		addl	%ebx,%esi
		movzbl	19(%edi),%ebx
		addl	12(%edi),%esi
		addl	(%eax,%ebx,4),%esi
		roll	$22,%esi
		addl	%ecx,%esi

		popl	%ebx
		addl	$20,%edi
		decl	%ebx
		jne	roundone

		popl	%ebx
roundtwo:	pushl	%ebx

		movl	%ecx,%ebx
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		addl	%ebx,%ebp
		movzbl	16(%edi),%ebx
		addl	(%edi),%ebp
		addl	(%eax,%ebx,4),%ebp
		roll	$5,%ebp
		addl	%esi,%ebp

		movl	%esi,%ebx
		xorl	%ebp,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		addl	%ebx,%edx
		movzbl	17(%edi),%ebx
		addl	4(%edi),%edx
		addl	(%eax,%ebx,4),%edx
		roll	$9,%edx
		addl	%ebp,%edx

		movl	%ebp,%ebx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%ebp,%ebx
		addl	%ebx,%ecx
		movzbl	18(%edi),%ebx
		addl	8(%edi),%ecx
		addl	(%eax,%ebx,4),%ecx
		roll	$14,%ecx
		addl	%edx,%ecx

		movl	%edx,%ebx
		xorl	%ecx,%ebx
		andl	%ebp,%ebx
		xorl	%edx,%ebx
		addl	%ebx,%esi
		movzbl	19(%edi),%ebx
		addl	12(%edi),%esi
		addl	(%eax,%ebx,4),%esi
		roll	$20,%esi
		addl	%ecx,%esi

		popl	%ebx
		addl	$20,%edi
		decl	%ebx
		jne	roundtwo

		popl	%ebx
roundthree:	pushl	%ebx

		movl	%edx,%ebx
		xorl	%ecx,%ebx
		xorl	%esi,%ebx
		addl	%ebx,%ebp
		movzbl	16(%edi),%ebx
		addl	(%edi),%ebp
		addl	(%eax,%ebx,4),%ebp
		roll	$4,%ebp
		addl	%esi,%ebp

		movl	%ecx,%ebx
		xorl	%esi,%ebx
		xorl	%ebp,%ebx
		addl	%ebx,%edx
		movzbl	17(%edi),%ebx
		addl	4(%edi),%edx
		addl	(%eax,%ebx,4),%edx
		roll	$11,%edx
		addl	%ebp,%edx

		movl	%esi,%ebx
		xorl	%ebp,%ebx
		xorl	%edx,%ebx
		addl	%ebx,%ecx
		movzbl	18(%edi),%ebx
		addl	8(%edi),%ecx
		addl	(%eax,%ebx,4),%ecx
		roll	$16,%ecx
		addl	%edx,%ecx

		movl	%ebp,%ebx
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		addl	%ebx,%esi
		movzbl	19(%edi),%ebx
		addl	12(%edi),%esi
		addl	(%eax,%ebx,4),%esi
		roll	$23,%esi
		addl	%ecx,%esi

		popl	%ebx
		addl	$20,%edi
		decl	%ebx
		jne	roundthree

		popl	%ebx
roundfour:	pushl	%ebx

		movl	%edx,%ebx
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		addl	%ebx,%ebp
		movzbl	16(%edi),%ebx
		addl	(%edi),%ebp
		addl	(%eax,%ebx,4),%ebp
		roll	$6,%ebp
		addl	%esi,%ebp

		movl	%ecx,%ebx
		notl	%ebx
		orl	%ebp,%ebx
		xorl	%esi,%ebx
		addl	%ebx,%edx
		movzbl	17(%edi),%ebx
		addl	4(%edi),%edx
		addl	(%eax,%ebx,4),%edx
		roll	$10,%edx
		addl	%ebp,%edx

		movl	%esi,%ebx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%ebp,%ebx
		addl	%ebx,%ecx
		movzbl	18(%edi),%ebx
		addl	8(%edi),%ecx
		addl	(%eax,%ebx,4),%ecx
		roll	$15,%ecx
		addl	%edx,%ecx

		movl	%ebp,%ebx
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		addl	%ebx,%esi
		movzbl	19(%edi),%ebx
		addl	12(%edi),%esi
		addl	(%eax,%ebx,4),%esi
		roll	$21,%esi
		addl	%ecx,%esi

		popl	%ebx
		addl	$20,%edi
		decl	%ebx
		jne	roundfour

		popl	%ebx
		addl	%ebp,(%ebx)
		addl	%esi,4(%ebx)
		addl	%ecx,8(%ebx)
		addl	%edx,12(%ebx)

		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

/* void md5init(MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5init
		.type	md5init,@function
		.align	16
md5init:	leal	md5start,%edx
		movl	4(%esp),%ecx
		pushl	%ebx
		xorl	%ebx,%ebx
md5initloop1:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$4,%ebx
		jne	md5initloop1
		popl	%ebx
		xorl	%eax,%eax
		movl	%eax,16(%ecx)
		movb	%al,84(%ecx)
		ret

.endif

/* void md5next(WORD08 *data,WORD32 length,MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5next
		.type	md5next,@function
		.align	16
md5next:	pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$8,%esp

		movl	36(%esp),%esi
		movl	32(%esp),%edi
		movl	28(%esp),%ebp

		movl	%esi,(%esp)
		addl	%edi,16(%esi)

		movzbl	84(%esi),%ebx
		testl	%edi,%edi
		je	md5nextloop2
md5nextloop1:	testl	%ebx,%ebx
		je	md5nextloop2
		movb	(%ebp),%al
		movb	%al,20(%esi,%ebx,)
		incl	%ebp
		incl	%ebx
		cmpl	$64,%ebx
		jne	md5nextcont1
		xorl	%ebx,%ebx
		leal	20(%esi),%eax
		movl	%eax,4(%esp)
		call	md5block
md5nextcont1:	decl	%edi
		jne	md5nextloop1

md5nextloop2:	cmpl	$64,%edi
		jnae	md5nxtloop2end
		movl	%ebp,4(%esp)
		call	md5block
		addl	$64,%ebp
		subl	$64,%edi
		jmp	md5nextloop2

md5nxtloop2end:	testl	%edi,%edi
		je	md5nextend

md5nextloop3:	movb	(%ebp),%al
		movb	%al,20(%esi,%ebx,)
		incl	%ebp
		incl	%ebx
		decl	%edi
		jne	md5nextloop3

md5nextend:	movb	%bl,84(%esi)

		addl	$8,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void md5end(WORD08 *result,MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5end
		.type	md5end,@function
		.align	16
md5end:		pushl	%ebx
		pushl	%esi
		pushl	%edi
		subl	$8,%esp

		movl	28(%esp),%esi
		movl	24(%esp),%edi

		movl	%esi,(%esp)
		leal	20(%esi),%eax
		movl	%eax,4(%esp)

		movzbl	84(%esi),%ebx
		movb	$128,%al
md5endloop1:	movb	%al,20(%esi,%ebx,)
		xorl	%eax,%eax
		incl	%ebx
		cmpl	$56,%ebx
		je	md5endloop1end
		cmpl	$64,%ebx
		jne	md5endloop1
		movl	%eax,%ebx
		call	md5block
		movl	%ebx,%eax
		jmp	md5endloop1

md5endloop1end:	movl	16(%esi),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,20(%esi,%ebx,)
		movl	%ecx,24(%esi,%ebx,)
		call	md5block

		xorl	%ebx,%ebx
md5endloop2:	movl	(%esi,%ebx,4),%eax
		movl	%eax,(%edi,%ebx,4)
		incl	%ebx
		cmpl	$4,%ebx
		jne	md5endloop2

.ifdef MD5_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
md5endloop3:	movl	%eax,20(%esi)
		addl	$4,%esi
		decl	%ebx
		jne	md5endloop3

.endif

		addl	$8,%esp
		popl	%edi
		popl	%esi
		popl	%ebx
		ret

.endif

/* void md5(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef MD5_FAST

.globl md5
		.type	md5,@function
		.align	16
md5:		pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$88,%esp

		leal	8(%esp),%ecx
		leal	md5start,%edx
		movl	%ecx,(%esp)
		xorl	%ebx,%ebx
md5loop1:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$4,%ebx
		jne	md5loop1

		movl	112(%esp),%edi
		movl	108(%esp),%ebp
md5loop2:	cmpl	$64,%edi
		jnae	md5loop2end
		movl	%ebp,4(%esp)
		call	md5block
		addl	$64,%ebp
		subl	$64,%edi
		jmp	md5loop2

md5loop2end:	leal	24(%esp),%esi
		movl	%esi,4(%esp)
		xorl	%ebx,%ebx
		testl	%edi,%edi
		je	md5loop3end

md5loop3:	movb	(%ebp,%ebx,),%al
		movb	%al,(%esi,%ebx,)
		incl	%ebx
		decl	%edi
		jne	md5loop3

md5loop3end:	movb	$128,%al
md5loop4:	movb	%al,(%esi,%ebx,)
		xorl	%eax,%eax
		incl	%ebx
		cmpl	$56,%ebx
		je	md5loop4end
		cmpl	$64,%ebx
		jne	md5loop4
		movl	%eax,%ebx
		call	md5block
		movl	%ebx,%eax
		jmp	md5loop4

md5loop4end:	movl	112(%esp),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,(%esi,%ebx,)
		movl	%ecx,4(%esi,%ebx,)
		call	md5block

		movl	(%esp),%edx
		movl	116(%esp),%ecx
		xorl	%ebx,%ebx
md5loop5:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$4,%ebx
		jne	md5loop5

.ifdef MD5_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
md5loop6:	movl	%eax,(%esi)
		addl	$4,%esi
		decl	%ebx
		jne	md5loop6

.endif

		addl	$88,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void md5hmkey(WORD08 *key,WORD32 keylength,MD5HMDATA *ptr) */

.ifdef	_MD5_HMAC

.globl md5hmkey
		.type	md5hmkey,@function
		.align	16
md5hmkey:	pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi

		movl	20(%esp),%ebp
		movl	24(%esp),%esi
		movl	28(%esp),%edi

		subl	$116,%esp

		cmpl	$65,%esi
		jnae	md5hmkey1
		leal	12(%esp),%ebx
		movl	%ebx,(%esp)
		call	md5init
		movl	%ebp,(%esp)
		movl	%esi,4(%esp)
		movl	%ebx,8(%esp)
		call	md5next
		leal	100(%esp),%ebp
		movl	%ebp,(%esp)
		movl	%ebx,4(%esp)
		call	md5end
		movl	$16,%esi
		xorl	%eax,%eax
		movl	$4,%edx
md5hmkeyloop1:	movl	%eax,(%ebx)
		addl	$4,%ebx
		decl	%edx
		jne	md5hmkeyloop1

md5hmkey1:	xorl	%ecx,%ecx
		leal	md5start,%edx
md5hmkeyloop2:	movl	(%edx,%ecx,4),%eax
		movl	%eax,(%edi,%ecx,4)
		movl	%eax,16(%edi,%ecx,4)
		incl	%ecx
		cmpl	$4,%ecx
		jne	md5hmkeyloop2

		leal	12(%esp),%ebx
		movl	%ebx,4(%esp)

		xorl	%ecx,%ecx
		movb	$54,%dl
		jmp	md5hmkey2
md5hmkeyloop3:	movb	(%ebp,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%ebx,%ecx,)
		incl	%ecx
md5hmkey2:	cmpl	%ecx,%esi
		jne	md5hmkeyloop3


		jmp	md5hmkey3
md5hmkeyloop4:	movb	%dl,(%ebx,%ecx,)
		incl	%ecx
md5hmkey3:	cmpb	$64,%ecx
		jne	md5hmkeyloop4

		movl	%edi,(%esp)
		call	md5block

		xorl	%ecx,%ecx
		movb	$92,%dl
		jmp	md5hmkey4
md5hmkeyloop5:	movb	(%ebp,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%ebx,%ecx,)
		incl	%ecx
md5hmkey4:	cmpl	%ecx,%esi
		jne	md5hmkeyloop5

		jmp	md5hmkey5
md5hmkeyloop6:	movb	%dl,(%ebx,%ecx,)
		inc	%ecx
md5hmkey5:	cmpl	$64,%ecx
		jne	md5hmkeyloop6

		addl	$16,(%esp)
		call	md5block

		leal	12(%esp),%ebx
		leal	100(%esp),%ecx
		xorl	%edx,%edx
		xorl	%eax,%eax
md5hmkeyloop7:	movl	%eax,(%ebx,%edx,4)
		movb	%al,(%ecx,%edx,)
		incl	%edx
		cmpl	$16,%edx
		jne	md5hmkeyloop7

		addl	$116,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void md5hminit(MD5DATA *ptr,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FULL

.globl md5hminit
		.type	md5hminit,@function
		.align	16
md5hminit:	xorl	%edx,%edx
		pushl	%ebx
		movl	12(%esp),%ecx
		movl	8(%esp),%ebx
		movb	%dl,84(%ebx)
md5hminitloop:	movl	(%ecx,%edx,4),%eax
		movl	%eax,(%ebx,%edx,4)
		incl	%edx
		cmpl	$4,%edx
		jne	md5hminitloop
		movl	$64,%edx
		movl	%edx,16(%ebx)
		popl	%ebx
		ret

.endif

/* void md5hmend(WORD08 *result,MD5DATA *ptr,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FULL

.globl md5hmend
		.type	md5hmend,@function
		.align	16
md5hmend:	pushl	%ebx
		pushl	%esi
		subl	$12,%esp
		movl	%esp,%esi
		movl	24(%esi),%eax
		movl	%eax,(%esi)
		movl	28(%esi),%ebx
		movl	%ebx,4(%esi)
		call	md5end
		movl	32(%esi),%ecx
		xorl	%edx,%edx
		movb	%dl,84(%ebx)
md5hmendloop:	movl	16(%ecx,%edx,4),%eax
		movl	%eax,(%ebx,%edx,4)
		incl	%edx
		cmpl	$4,%edx
		jne	md5hmendloop
		movl	$64,%edx
		movl	%edx,16(%ebx)
		movl	$16,%edx
		movl	%edx,4(%esi)
		movl	%ebx,8(%esi)
		call	md5next
		movl	%ebx,4(%esi)
		call	md5end
		addl	$12,%esp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void md5hmac(WORD08 *data,WORD32 length,WORD08 *result,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FAST

.globl md5hmac
		.type	md5hmac,@function
		.align	16
md5hmac:	xorl	%edx,%edx
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		movl	28(%esp),%ebx
		subl	$100,%esp
		movl	%esp,%esi
		leal	12(%esi),%edi
		movb	%dl,84(%edi)

md5hmacloop1:	movl	(%ebx,%edx,4),%eax
		movl	%eax,(%edi,%edx,4)
		incl	%edx
		cmpl	$4,%edx
		jne	md5hmacloop1
		movl	$64,%edx
		movl	%edx,16(%edi)

		movl	116(%esi),%eax
		movl	%eax,(%esi)
		movl	120(%esi),%eax
		movl	%eax,4(%esi)
		movl	%edi,8(%esi)
		call	md5next

		movl	124(%esi),%eax
		movl	%eax,(%esi)
		movl	%edi,4(%esi)
		call	md5end

		xorl	%edx,%edx
		movb	%dl,84(%edi)
md5hmacloop2:	movl	16(%ebx,%edx,4),%eax
		movl	%eax,(%edi,%edx,4)
		incl	%edx
		cmpl	$4,%edx
		jne	md5hmacloop2
		movl	$64,%edx
		movl	%edx,16(%edi)

		movl	$16,%edx
		movl	%edx,4(%esi)
		call	md5next

		movl	%edi,4(%esi)
		call	md5end

		addl	$100,%esp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

.endif

.data
		.align  16
md5start:	.long	0x67452301,0xefcdab89,0x98badcfe,0x10325476
md5tab:		.long	0xd76aa478,0xe8c7b756,0x242070db,0xc1bdceee
		.byte	0,1,2,3
		.long	0xf57c0faf,0x4787c62a,0xa8304613,0xfd469501
		.byte	4,5,6,7
		.long	0x698098d8,0x8b44f7af,0xffff5bb1,0x895cd7be
		.byte	8,9,10,11
		.long	0x6b901122,0xfd987193,0xa679438e,0x49b40821
		.byte	12,13,14,15
		.long	0xf61e2562,0xc040b340,0x265e5a51,0xe9b6c7aa
		.byte	1,6,11,0
		.long	0xd62f105d,0x02441453,0xd8a1e681,0xe7d3fbc8
		.byte	5,10,15,4
		.long	0x21e1cde6,0xc33707d6,0xf4d50d87,0x455a14ed
		.byte	9,14,3,8
		.long	0xa9e3e905,0xfcefa3f8,0x676f02d9,0x8d2a4c8a
		.byte	13,2,7,12
		.long	0xfffa3942,0x8771f681,0x6d9d6122,0xfde5380c
		.byte	5,8,11,14
		.long	0xa4beea44,0x4bdecfa9,0xf6bb4b60,0xbebfbc70
		.byte	1,4,7,10
		.long	0x289b7ec6,0xeaa127fa,0xd4ef3085,0x04881d05
		.byte	13,0,3,6
		.long	0xd9d4d039,0xe6db99e5,0x1fa27cf8,0xc4ac5665
		.byte	9,12,15,2
		.long	0xf4292244,0x432aff97,0xab9423a7,0xfc93a039
		.byte	0,7,14,5
		.long	0x655b59c3,0x8f0ccc92,0xffeff47d,0x85845dd1
		.byte	12,3,10,1
		.long	0x6fa87e4f,0xfe2ce6e0,0xa3014314,0x4e0811a1
		.byte	8,15,6,13
		.long	0xf7537e82,0xbd3af235,0x2ad7d2bb,0xeb86d391
		.byte	4,11,2,9
