/* MD5 Production Implementation                                              */
/* This implementation: (c) 1999 Andreas Steinmetz                            */
/* MD5 algorithm by Ron Rivest, see RFC1321                                   */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2202                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact astmail@yahoo.com           */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation does not depend on any run time library.      */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the MD5 routines.                               */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for MD5 transformation    WORD08[64]                            */
/* resulting MD5 or HMAC hash           WORD08[16]                            */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* MD5_FULL defined:                                                          */
/*                                                                            */
/* 1. Call md5init                                                            */
/* 2. For all data to be hashed call md5next                                  */
/* 3. To retrieve the hash call md5end                                        */
/*                                                                            */
/* MD5_FAST defined:                                                          */
/*                                                                            */
/* Call md5 to get the hash for the specified data                            */
/*                                                                            */
/* MD5_HMAC_FULL defined:                                                     */
/*                                                                            */
/* 1. Call md5hmkey once to preprocess the selected key                       */
/* 2. Call md5hminit                                                          */
/* 3. For all data to be hashed call md5hmnext                                */
/* 4. To retrieve the hash call md5hmend                                      */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the MD5HMDATA structure                                           */
/*                                                                            */
/* MD5_HMAC_FAST defined:                                                     */
/*                                                                            */
/* 1. Call md5hmkey once to preprocess the selected key                       */
/* 2. Call md5hmac to get the hash for the specified data                     */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the MD5HMDATA structure                                           */

.text

.ifdef	MD5_HMAC_FULL
		_MD5_HMAC=1
.endif
.ifdef	MD5_HMAC_FAST
		_MD5_HMAC=1
.endif
.ifdef	MD5_FULL
		_MD5_FULL=1
.endif
.ifdef	_MD5_HMAC
		_MD5_FULL=1
		MD5_PARANOID=1
.endif

/* static void md5block(WORD32 *md5,WORD08 *block) */

		.align	16
md5block:
		movl	12(%ebp),%edx
		movl	(%ebp),%eax

		pushl	%esi
		pushl	%ebx

		movl	8(%ebp),%ecx
		movl	4(%ebp),%esi

		/* round 1 */

		movl	%edx,%ebx
		addl	(%edi),%eax
		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		addl	4(%edi),%edx
		leal	0xd76aa478(%ebx,%eax,),%eax
		movl	%ecx,%ebx
		roll	$7,%eax
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0xe8c7b756(%ebx,%edx,),%edx
		addl	8(%edi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0x242070db(%ebx,%ecx,),%ecx
		addl	12(%edi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0xc1bdceee(%ebx,%esi,),%esi
		addl	16(%edi),%eax
		roll	$22,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		leal	0xf57c0faf(%ebx,%eax,),%eax
		addl	20(%edi),%edx
		roll	$7,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0x4787c62a(%ebx,%edx,),%edx
		addl	24(%edi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0xa8304613(%ebx,%ecx,),%ecx
		addl	28(%edi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0xfd469501(%ebx,%esi,),%esi
		addl	32(%edi),%eax
		roll	$22,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		leal	0x698098d8(%ebx,%eax,),%eax
		addl	36(%edi),%edx
		roll	$7,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0x8b44f7af(%ebx,%edx,),%edx
		addl	40(%edi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0xffff5bb1(%ebx,%ecx,),%ecx
		addl	44(%edi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0x895cd7be(%ebx,%esi,),%esi
		addl	48(%edi),%eax
		roll	$22,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		leal	0x6b901122(%ebx,%eax,),%eax
		addl	52(%edi),%edx
		roll	$7,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0xfd987193(%ebx,%edx,),%edx
		addl	56(%edi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0xa679438e(%ebx,%ecx,),%ecx
		addl	60(%edi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0x49b40821(%ebx,%esi,),%esi
		roll	$22,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		/* round 2 */

		addl	4(%edi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xf61e2562(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	24(%edi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xc040b340(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	44(%edi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x265e5a51(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	(%edi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xe9b6c7aa(%ebx,%esi,),%esi
		roll	$20,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		addl	20(%edi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xd62f105d(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	40(%edi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0x02441453(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	60(%edi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xd8a1e681(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	16(%edi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xe7d3fbc8(%ebx,%esi,),%esi
		roll	$20,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		addl	36(%edi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0x21e1cde6(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	56(%edi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xc33707d6(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	12(%edi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xf4d50d87(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	32(%edi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x455a14ed(%ebx,%esi,),%esi
		roll	$20,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		addl	52(%edi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xa9e3e905(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	8(%edi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xfcefa3f8(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	28(%edi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x676f02d9(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	48(%edi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x8d2a4c8a(%ebx,%esi,),%esi
		roll	$20,%esi
		addl	%ecx,%esi
		movl	%edx,%ebx

		/* round 3 */

		xorl	%ecx,%ebx
		addl	20(%edi),%eax
		xorl	%esi,%ebx
		leal	0xfffa3942(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	32(%edi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x8771f681(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	44(%edi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x6d9d6122(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	56(%edi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xfde5380c(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	4(%edi),%eax
		xorl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xa4beea44(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	16(%edi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x4bdecfa9(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	28(%edi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xf6bb4b60(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	40(%edi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xbebfbc70(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	52(%edi),%eax
		xorl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0x289b7ec6(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	(%edi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xeaa127fa(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	12(%edi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xd4ef3085(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	24(%edi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0x04881d05(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	36(%edi),%eax
		xorl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xd9d4d039(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	48(%edi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xe6db99e5(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	60(%edi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x1fa27cf8(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	8(%edi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xc4ac5665(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		/* round 4 */

		addl	(%edi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0xf4292244(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	28(%edi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0x432aff97(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	56(%edi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0xab9423a7(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	20(%edi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0xfc93a039(%ebx,%esi,),%esi
		roll	$21,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	48(%edi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0x655b59c3(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	12(%edi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0x8f0ccc92(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	40(%edi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0xffeff47d(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	4(%edi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0x85845dd1(%ebx,%esi,),%esi
		roll	$21,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	32(%edi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0x6fa87e4f(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	60(%edi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0xfe2ce6e0(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	24(%edi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0xa3014314(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	52(%edi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0x4e0811a1(%ebx,%esi,),%esi
		roll	$21,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	16(%edi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0xf7537e82(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	%eax,(%ebp)

		addl	44(%edi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0xbd3af235(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	%edx,12(%ebp)

		addl	8(%edi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0x2ad7d2bb(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	%ecx,8(%ebp)

		addl	36(%edi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0xeb86d391(%ebx,%esi,),%esi
		roll	$21,%esi
		addl	%ecx,%esi

		popl	%ebx

		addl	%esi,4(%ebp)

		popl	%esi

		ret

/* void md5init(MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5init
		.type	md5init,@function
		.align	16
md5init:	movl	4(%esp),%eax
		movl	$0x67452301,(%eax)
		movl	$0xefcdab89,4(%eax)
		movl	$0x98badcfe,8(%eax)
		movl	$0x10325476,12(%eax)
		movl	$0,16(%eax)
		movb	$0,84(%eax)
		ret

.endif

/* void md5next(WORD08 *data,WORD32 length,MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5next
		.type	md5next,@function
		.align	16
md5next:	pushl	%ebp
		pushl	%ebx
		pushl	%esi
		pushl	%edi

		movl	28(%esp),%ebp
		movl	24(%esp),%esi
		leal	20(%ebp),%edi
		movl	20(%esp),%ebx
		addl	%esi,16(%ebp)

		movzbl	84(%ebp),%ecx
		testl	%esi,%esi
		je	md5nxtloop1end
		testl	%ecx,%ecx
		je	md5nxtloop1end
md5nextloop1:	movb	(%ebx),%al
		incl	%ebx
		movb	%al,(%edi,%ecx,)
		incl	%ecx
		cmpl	$64,%ecx
		je	md5nextcont1
		decl	%esi
		jne	md5nextloop1
		jmp	md5nxtloop1end
md5nextcont1:	call	md5block
		xorl	%ecx,%ecx
		decl	%esi

md5nxtloop1end:	movl	%ebx,%edi
		movl	%ecx,%ebx
		cmpl	$64,%esi
		jnae	md5nxtloop2end

md5nextloop2:	call	md5block
		subl	$64,%esi
		addl	$64,%edi
		cmpl	$64,%esi
		jnb	md5nextloop2

md5nxtloop2end:	movl	%esi,%edx
		shrl	$2,%esi
		je	md5nxtloop3end

md5nextloop3:	movl	(%edi),%eax
		addl	$4,%edi
		movl	%eax,20(%ebp,%ebx,)
		addl	$4,%ebx
		decl	%esi
		jne	md5nextloop3

md5nxtloop3end:	andl	$3,%edx
		je	md5nextend

md5nextloop4:	movb	(%edi),%al
		incl	%edi
		movb	%al,20(%ebp,%ebx,)
		incl	%ebx
		decl	%edx
		jne	md5nextloop4

md5nextend:	popl	%edi
		popl	%esi

		movb	%bl,84(%ebp)

		popl	%ebx
		popl	%ebp
		ret

.endif

/* void md5end(WORD08 *result,MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5end
		.type	md5end,@function
		.align	16
md5end:		pushl	%ebp
		pushl	%esi
		pushl	%edi
		pushl	%ebx

		movl	24(%esp),%ebp
		movl	20(%esp),%esi
		leal	20(%ebp),%edi

		movzbl	84(%ebp),%ebx
		incl	%ebx
		movl	%ebx,%eax
		movb	$128,-1(%edi,%ebx,)
		andl	$3,%eax
		je	md5endlp1aend

md5endloop1a:	movb	$0,(%edi,%ebx,)
		incl	%eax
		incl	%ebx
		cmpl	$4,%eax
		jne	md5endloop1a

md5endlp1aend:	shrl	$2,%ebx
		jmp	md5endlp1bbeg

md5endloop1b:	movl	$0,(%edi,%ebx,4)
		incl	%ebx

md5endlp1bbeg:	cmpl	$14,%ebx
		je	md5endloop1end
		cmpl	$16,%ebx
		jne	md5endloop1b
		xorl	%ebx,%ebx
		call	md5block
		jmp	md5endloop1b

md5endloop1end:	movl	16(%ebp),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,76(%ebp)
		movl	%ecx,80(%ebp)
		call	md5block

		movl	$4,%edx

.ifdef MD5_PARANOID
		movl	$16,%ecx
		xorl	%eax,%eax
.endif

md5endloop2:	decl	%edx
		movl	(%ebp,%edx,4),%ebx
		movl	%ebx,(%esi,%edx,4)
		jne	md5endloop2

		popl	%ebx
		popl	%edi

.ifdef MD5_PARANOID
md5endloop3:	decl	%ecx
		movl	%eax,20(%ebp,%ecx,4)
		jne	md5endloop3
.endif

		popl	%esi
		popl	%ebp
		ret

.endif

/* void md5(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef MD5_FAST

.globl md5
		.type	md5,@function
		.align	16
md5:		pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$80,%esp

		movl	%esp,%ebp
		movl	$0x67452301,(%ebp)
		movl	$0xefcdab89,4(%ebp)
		movl	$0x98badcfe,8(%ebp)
		movl	$0x10325476,12(%ebp)

		movl	104(%esp),%esi
		movl	100(%esp),%edi
		cmpl	$64,%esi
		jnae	md5loop2end

md5loop2:	call	md5block
		subl	$64,%esi
		addl	$64,%edi
		cmpl	$64,%esi
		jnb	md5loop2

md5loop2end:	movl	%esi,%ecx
		movl	%edi,%edx
		xorl	%ebx,%ebx
		leal	16(%esp),%edi
		shrl	$2,%ecx
		je	md5loop3bbeg

md5loop3a:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%edi,%ebx,4)
		incl	%ebx
		decl	%ecx
		jne	md5loop3a
		lea	(,%ebx,4),%ebx

md5loop3bbeg:	andl	$3,%esi
		je	md5loop3end

md5loop3b:	movb	(%edx,%ebx,),%al
		movb	%al,(%edi,%ebx,)
		incl	%ebx
		decl	%esi
		jne	md5loop3b

md5loop3end:	incl	%ebx
		movl	%ebx,%eax
		movb	$128,-1(%edi,%ebx,)
		andl	$3,%eax
		je	md5loop4aend

md5loop4a:	movb	$0,(%edi,%ebx,)
		incl	%eax
		incl	%ebx
		cmpl	$4,%eax
		jne	md5loop4a

md5loop4aend:	shrl	$2,%ebx
		jmp	md5loop4bbeg

md5loop4b:	movl	$0,(%edi,%ebx,4)
		incl	%ebx

md5loop4bbeg:	cmpl	$14,%ebx
		je	md5loop4end
		cmpl	$16,%ebx
		jne	md5loop4b
		xorl	%ebx,%ebx
		call	md5block
		jmp	md5loop4b

md5loop4end:	movl	104(%esp),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,56(%edi)
		movl	%ecx,60(%edi)
		call	md5block

		movl	108(%esp),%ecx
		movl	$4,%ebx
md5loop5:	decl	%ebx
		movl	(%ebp,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		jne	md5loop5

.ifdef MD5_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
md5loop6:	decl	%ebx
		movl	%eax,(%edi,%ebx,4)
		jne	md5loop6

.endif

		addl	$80,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void md5hmkey(WORD08 *key,WORD32 keylength,MD5HMDATA *ptr) */

.ifdef	_MD5_HMAC

.globl md5hmkey
		.type	md5hmkey,@function
		.align	16
md5hmkey:	pushl	%ebx
		pushl	%esi
		pushl	%ebp
		pushl	%edi

		movl	20(%esp),%ebx
		movl	24(%esp),%esi
		movl	28(%esp),%ebp
		subl	$104,%esp
		movl	%esp,%edi

		cmpl	$65,%esi
		jnae	md5hmkey1

		pushl	%edi
		call	md5init
		pushl	%esi
		pushl	%ebx
		call	md5next
		leal	88(%edi),%ebx
		pushl	%edi
		pushl	%ebx
		call	md5end
		xorl	%eax,%eax
		movl	%edi,%esp
		movl	$16,%esi
		movl	%eax,(%edi)
		movl	%eax,4(%edi)
		movl	%eax,8(%edi)
		movl	%eax,12(%edi)

md5hmkey1:	movl	$0x67452301,(%ebp)
		movl	$0xefcdab89,4(%ebp)
		movl	$0x98badcfe,8(%ebp)
		movl	$0x10325476,12(%ebp)
		movl	$0x67452301,16(%ebp)
		movl	$0xefcdab89,20(%ebp)
		movl	$0x98badcfe,24(%ebp)
		movl	$0x10325476,28(%ebp)

		xorl	%ecx,%ecx
		movb	$54,%dl
		jmp	md5hmkey2
md5hmkeyloop3:	movb	(%ebx,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%edi,%ecx,)
		incl	%ecx
md5hmkey2:	cmpl	%ecx,%esi
		jne	md5hmkeyloop3

		jmp	md5hmkey3
md5hmkeyloop4:	movb	%dl,(%edi,%ecx,)
		incl	%ecx
md5hmkey3:	cmpb	$64,%ecx
		jne	md5hmkeyloop4

		call	md5block

		xorl	%ecx,%ecx
		movb	$92,%dl
		jmp	md5hmkey4
md5hmkeyloop5:	movb	(%ebx,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%edi,%ecx,)
		incl	%ecx
md5hmkey4:	cmpl	%ecx,%esi
		jne	md5hmkeyloop5

		jmp	md5hmkey5
md5hmkeyloop6:	movb	%dl,(%edi,%ecx,)
		incl	%ecx
md5hmkey5:	cmpl	$64,%ecx
		jne	md5hmkeyloop6

		addl	$16,%ebp
		call	md5block

		movl	$16,%edx
		xorl	%eax,%eax
md5hmkeyloop7:	decl	%edx
		movl	%eax,(%edi,%edx,4)
		movb	%al,88(%edi,%edx,)
		jne	md5hmkeyloop7

		addl	$104,%esp
		popl	%edi
		popl	%ebp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void md5hminit(MD5DATA *ptr,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FULL

.globl md5hminit
		.type	md5hminit,@function
		.align	16
md5hminit:	movl	8(%esp),%ecx
		movl	4(%esp),%edx
		movl	(%ecx),%eax
		movb	$0,84(%edx)
		movl	%eax,(%edx)
		movl	4(%ecx),%eax
		movl	$64,16(%ebx)
		movl	%eax,4(%edx)
		movl	8(%ecx),%eax
		movl	%eax,8(%edx)
		movl	12(%ecx),%eax
		movl	%eax,12(%edx)
		ret

.endif

/* void md5hmend(WORD08 *result,MD5DATA *ptr,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FULL

.globl md5hmend
		.type	md5hmend,@function
		.align	16
md5hmend:	pushl	%ebx
		pushl	%esi
		subl	$12,%esp
		movl	%esp,%esi
		movl	24(%esi),%eax
		movl	28(%esi),%ebx
		movl	%eax,(%esi)
		movl	%ebx,4(%esi)
		call	md5end
		movl	32(%esi),%ecx
		movb	$0,84(%ebx)
		movl	16(%ecx),%eax
		movl	20(%ecx),%edx
		movl	%eax,(%ebx)
		movl	%edx,4(%ebx)
		movl	24(%ecx),%eax
		movl	28(%ecx),%edx
		movl	%eax,8(%ebx)
		movl	%edx,12(%ebx)
		movl	$64,16(%ebx)
		movl	$16,4(%esi)
		movl	%ebx,8(%esi)
		call	md5next
		movl	%ebx,4(%esi)
		call	md5end
		addl	$12,%esp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void md5hmac(WORD08 *data,WORD32 length,WORD08 *result,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FAST

.globl md5hmac
		.type	md5hmac,@function
		.align	16
md5hmac:	pushl	%ebx
		pushl	%edi
		pushl	%esi

		xorl	%ecx,%ecx	/* keep this ! */

		movl	28(%esp),%ebx
		subl	$100,%esp
		movl	%esp,%esi
		leal	12(%esi),%edi

		movb	$0,84(%edi)

		movl	(%ebx),%eax
		movl	4(%ebx),%edx
		movl	%eax,(%edi)
		movl	%edx,4(%edi)
		movl	8(%ebx),%eax
		movl	12(%ebx),%edx
		movl	%eax,8(%edi)
		movl	%edx,12(%edi)

		movl	$64,16(%edi)

		movl	116(%esi),%eax
		movl	120(%esi),%ecx
		movl	%eax,(%esi)
		movl	%ecx,4(%esi)
		movl	%edi,8(%esi)
		call	md5next

		movl	124(%esi),%eax
		movl	%edi,4(%esi)
		movl	%eax,(%esi)
		call	md5end

		movb	$0,84(%edi)

		movl	16(%ebx),%eax
		movl	20(%ebx),%edx
		movl	%eax,(%edi)
		movl	%edx,4(%edi)
		movl	24(%ebx),%eax
		movl	28(%ebx),%edx
		movl	%eax,8(%edi)
		movl	%edx,12(%edi)

		movl	$64,16(%edi)

		movl	$16,4(%esi)
		call	md5next

		movl	%edi,4(%esi)
		call	md5end

		addl	$100,%esp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

.endif
