/* RIPEMD-160 Production Implementation                                       */
/* This implementation: (c) 1999, 2005 Andreas Steinmetz                      */
/* RIPEMD-160 algorithm by Hans Dobbertin, Antoon Bosselaers and Bart Preneel,*/
/* see http://www.esat.kuleuven.ac.be/~bosselae/ripemd160.html                */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2286                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact ast@domdv.de                */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation is processor independent.                     */
/* It does not depend on any run time library and                             */
/* should be 64 bit clean.                                                    */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the RIPEMD-160 routines.                        */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for RMD160 transformation   WORD08[64]                          */
/* resulting RMD160 or HMAC hash          WORD08[20]                          */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* RMD160_FULL defined:                                                       */
/*                                                                            */
/* 1. Call rmd160init                                                         */
/* 2. For all data to be hashed call rmd160next                               */
/* 3. To retrieve the hash call rmd160end                                     */
/*                                                                            */
/* RMD160_FAST defined:                                                       */
/*                                                                            */
/* Call rmd160 to get the hash for the specified data                         */
/*                                                                            */
/* RMD160_HMAC_FULL defined:                                                  */
/*                                                                            */
/* 1. Call rmd160hmkey once to preprocess the selected key                    */
/* 2. Call rmd160hminit                                                       */
/* 3. For all data to be hashed call rmd160hmnext                             */
/* 4. To retrieve the hash call rmd160hmend                                   */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the RMD160HMDATA structure                                        */
/*                                                                            */
/* RMD160_HMAC_FAST defined:                                                  */
/*                                                                            */
/* 1. Call rmd160hmkey once to preprocess the selected key                    */
/* 2. Call rmd160hmac to get the hash for the specified data                  */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the RMD160HMDATA structure                                        */

.text

.ifndef RMD160_FULL
.ifndef RMD160_FAST
.ifndef RMD160_HMAC_FULL
.ifndef RMD160_HMAC_FAST
		RMD160_FULL=1
		RMD160_FAST=1
		RMD160_HMAC_FULL=1
		RMD160_HMAC_FAST=1
		RMD160_PARANOID=1
.endif
.endif
.endif
.endif

.ifdef  RMD160_HMAC_FULL
                _RMD160_HMAC=1
.endif
.ifdef  RMD160_HMAC_FAST
                _RMD160_HMAC=1
.endif
.ifdef  RMD160_FULL
                _RMD160_FULL=1
.endif
.ifdef  _RMD160_HMAC
                _RMD160_FULL=1
                RMD160_PARANOID=1
.endif

/* static void rmd160block(WORD32 *rmd160,WORD08 *block) */

		.type	rmd160init,@function
		.align	16
rmd160block:
		movq	%rbx,%r11
		movq	%rbp,%r10

		movl	(%r8),%ebx
		movl	4(%r8),%ecx
		movl	8(%r8),%edx
		movl	12(%r8),%esi
		movl	16(%r8),%ebp

		subq	$20,%rsp

		addl	(%rdi),%ebx
		movl	%edx,%eax
		xorl	%ecx,%eax
		xorl	%esi,%eax
		addl	%eax,%ebx
		roll	$11,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	4(%rdi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$14,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	8(%rdi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$15,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	12(%rdi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$12,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	16(%rdi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	20(%rdi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	24(%rdi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	28(%rdi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	32(%rdi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	36(%rdi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$13,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	40(%rdi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	44(%rdi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	48(%rdi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$6,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	52(%rdi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$7,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	56(%rdi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$9,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	60(%rdi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	28(%rdi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	16(%rdi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x5a827999(%eax,%esi,),%esi
		roll	$6,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	52(%rdi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x5a827999(%eax,%edx,),%edx
		roll	$8,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	4(%rdi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x5a827999(%eax,%ecx,),%ecx
		roll	$13,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	40(%rdi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x5a827999(%eax,%ebx,),%ebx
		roll	$11,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	24(%rdi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$9,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	60(%rdi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x5a827999(%eax,%esi,),%esi
		roll	$7,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	12(%rdi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x5a827999(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	48(%rdi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x5a827999(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	(%rdi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x5a827999(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	36(%rdi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	20(%rdi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x5a827999(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	8(%rdi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x5a827999(%eax,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	56(%rdi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x5a827999(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	44(%rdi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x5a827999(%eax,%ebx,),%ebx
		roll	$13,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	32(%rdi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$12,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	12(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$11,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	40(%rdi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6ed9eba1(%eax,%edx,),%edx
		roll	$13,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	56(%rdi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6ed9eba1(%eax,%ecx,),%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	16(%rdi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6ed9eba1(%eax,%ebx,),%ebx
		roll	$7,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	36(%rdi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6ed9eba1(%eax,%ebp,),%ebp
		roll	$14,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	60(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	32(%rdi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6ed9eba1(%eax,%edx,),%edx
		roll	$13,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	4(%rdi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6ed9eba1(%eax,%ecx,),%ecx
		roll	$15,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	8(%rdi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6ed9eba1(%eax,%ebx,),%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	28(%rdi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6ed9eba1(%eax,%ebp,),%ebp
		roll	$8,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$13,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	24(%rdi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6ed9eba1(%eax,%edx,),%edx
		roll	$6,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	52(%rdi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6ed9eba1(%eax,%ecx,),%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	44(%rdi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6ed9eba1(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	20(%rdi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6ed9eba1(%eax,%ebp,),%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	48(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	4(%rdi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	36(%rdi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x8f1bbcdc(%eax,%ecx,),%ecx
		roll	$12,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	44(%rdi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x8f1bbcdc(%eax,%ebx,),%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	40(%rdi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x8f1bbcdc(%eax,%ebp,),%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	(%rdi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x8f1bbcdc(%eax,%esi,),%esi
		roll	$14,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	32(%rdi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	48(%rdi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x8f1bbcdc(%eax,%ecx,),%ecx
		roll	$9,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	16(%rdi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x8f1bbcdc(%eax,%ebx,),%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	52(%rdi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x8f1bbcdc(%eax,%ebp,),%ebp
		roll	$9,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	12(%rdi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x8f1bbcdc(%eax,%esi,),%esi
		roll	$14,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	28(%rdi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$5,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	60(%rdi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x8f1bbcdc(%eax,%ecx,),%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	56(%rdi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x8f1bbcdc(%eax,%ebx,),%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	20(%rdi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x8f1bbcdc(%eax,%ebp,),%ebp
		roll	$6,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	24(%rdi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x8f1bbcdc(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	8(%rdi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$12,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	16(%rdi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$9,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	(%rdi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0xa953fd4e(%eax,%ebx,),%ebx
		roll	$15,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	20(%rdi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0xa953fd4e(%eax,%ebp,),%ebp
		roll	$5,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	36(%rdi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0xa953fd4e(%eax,%esi,),%esi
		roll	$11,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	28(%rdi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0xa953fd4e(%eax,%edx,),%edx
		roll	$6,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	48(%rdi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$8,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	8(%rdi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0xa953fd4e(%eax,%ebx,),%ebx
		roll	$13,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	40(%rdi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0xa953fd4e(%eax,%ebp,),%ebp
		roll	$12,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	56(%rdi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0xa953fd4e(%eax,%esi,),%esi
		roll	$5,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	4(%rdi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0xa953fd4e(%eax,%edx,),%edx
		roll	$12,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	12(%rdi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$13,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	32(%rdi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0xa953fd4e(%eax,%ebx,),%ebx
		roll	$14,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	44(%rdi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0xa953fd4e(%eax,%ebp,),%ebp
		roll	$11,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	24(%rdi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0xa953fd4e(%eax,%esi,),%esi
		roll	$8,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	60(%rdi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0xa953fd4e(%eax,%edx,),%edx
		roll	$5,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	52(%rdi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$6,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		movl	%ebx,(%rsp)
		movl	%ecx,4(%rsp)
		movl	%edx,8(%rsp)
		movl	%esi,12(%rsp)
		movl	%ebp,16(%rsp)

		movl	(%r8),%ebx
		movl	4(%r8),%ecx
		movl	8(%r8),%edx
		movl	12(%r8),%esi
		movl	16(%r8),%ebp

		addl	20(%rdi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$8,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	56(%rdi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x50a28be6(%eax,%ebp,),%ebp
		roll	$9,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	28(%rdi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x50a28be6(%eax,%esi,),%esi
		roll	$9,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	(%rdi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x50a28be6(%eax,%edx,),%edx
		roll	$11,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	36(%rdi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0x50a28be6(%eax,%ecx,),%ecx
		roll	$13,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	8(%rdi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$15,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	44(%rdi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x50a28be6(%eax,%ebp,),%ebp
		roll	$15,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	16(%rdi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x50a28be6(%eax,%esi,),%esi
		roll	$5,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	52(%rdi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x50a28be6(%eax,%edx,),%edx
		roll	$7,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	24(%rdi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0x50a28be6(%eax,%ecx,),%ecx
		roll	$7,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	60(%rdi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$8,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	32(%rdi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x50a28be6(%eax,%ebp,),%ebp
		roll	$11,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	4(%rdi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x50a28be6(%eax,%esi,),%esi
		roll	$14,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	40(%rdi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x50a28be6(%eax,%edx,),%edx
		roll	$14,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	12(%rdi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0x50a28be6(%eax,%ecx,),%ecx
		roll	$12,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	48(%rdi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$6,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	24(%rdi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$9,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	44(%rdi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x5c4dd124(%eax,%esi,),%esi
		roll	$13,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	12(%rdi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x5c4dd124(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	28(%rdi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x5c4dd124(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	(%rdi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x5c4dd124(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	52(%rdi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$8,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	20(%rdi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x5c4dd124(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	40(%rdi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x5c4dd124(%eax,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	56(%rdi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x5c4dd124(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	60(%rdi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x5c4dd124(%eax,%ebx,),%ebx
		roll	$7,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	32(%rdi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$12,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	48(%rdi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x5c4dd124(%eax,%esi,),%esi
		roll	$7,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	16(%rdi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x5c4dd124(%eax,%edx,),%edx
		roll	$6,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	36(%rdi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x5c4dd124(%eax,%ecx,),%ecx
		roll	$15,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	4(%rdi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x5c4dd124(%eax,%ebx,),%ebx
		roll	$13,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	8(%rdi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$11,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	60(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	20(%rdi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6d703ef3(%eax,%edx,),%edx
		roll	$7,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	4(%rdi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6d703ef3(%eax,%ecx,),%ecx
		roll	$15,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	12(%rdi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6d703ef3(%eax,%ebx,),%ebx
		roll	$11,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	28(%rdi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6d703ef3(%eax,%ebp,),%ebp
		roll	$8,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	56(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$6,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	24(%rdi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6d703ef3(%eax,%edx,),%edx
		roll	$6,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	36(%rdi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6d703ef3(%eax,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	44(%rdi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6d703ef3(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	32(%rdi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6d703ef3(%eax,%ebp,),%ebp
		roll	$13,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	48(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	8(%rdi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6d703ef3(%eax,%edx,),%edx
		roll	$14,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	40(%rdi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6d703ef3(%eax,%ecx,),%ecx
		roll	$13,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	(%rdi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6d703ef3(%eax,%ebx,),%ebx
		roll	$13,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	16(%rdi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6d703ef3(%eax,%ebp,),%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	52(%rdi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	32(%rdi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	24(%rdi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x7a6d76e9(%eax,%ecx,),%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	16(%rdi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x7a6d76e9(%eax,%ebx,),%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	4(%rdi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x7a6d76e9(%eax,%ebp,),%ebp
		roll	$11,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	12(%rdi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x7a6d76e9(%eax,%esi,),%esi
		roll	$14,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	44(%rdi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$14,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	60(%rdi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x7a6d76e9(%eax,%ecx,),%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	(%rdi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x7a6d76e9(%eax,%ebx,),%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	20(%rdi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x7a6d76e9(%eax,%ebp,),%ebp
		roll	$6,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	48(%rdi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x7a6d76e9(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	8(%rdi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$12,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	52(%rdi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x7a6d76e9(%eax,%ecx,),%ecx
		roll	$9,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	36(%rdi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x7a6d76e9(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	28(%rdi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x7a6d76e9(%eax,%ebp,),%ebp
		roll	$5,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	40(%rdi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x7a6d76e9(%eax,%esi,),%esi
		roll	$15,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	56(%rdi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$8,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	48(%rdi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$8,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	60(%rdi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$5,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	40(%rdi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$12,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	16(%rdi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	4(%rdi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$12,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	20(%rdi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	32(%rdi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	28(%rdi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$6,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	24(%rdi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$8,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	8(%rdi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$13,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	52(%rdi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	56(%rdi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$5,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	(%rdi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	12(%rdi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$13,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	36(%rdi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	44(%rdi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$11,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	16(%rsp),%ebx
		addl	(%rsp),%ecx
		addl	4(%rsp),%edx
		addl	8(%rsp),%esi
		addl	12(%rsp),%ebp

		addq	$20,%rsp

		addl	12(%r8),%ebx
		addl	16(%r8),%ecx
		addl	(%r8),%edx
		addl	4(%r8),%esi
		addl	8(%r8),%ebp

		movl	%ebp,4(%r8)
		movl	%esi,(%r8)
		movl	%ebx,8(%r8)
		movl	%ecx,12(%r8)
		movl	%edx,16(%r8)

		movq	%r10,%rbp
		movq	%r11,%rbx
		ret

/* void rmd160init(RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160init
		.type	rmd160init,@function
		.align	16
rmd160init:
		movl	$0x67452301,(%rdi)
		movl	$0xefcdab89,4(%rdi)
		movl	$0x98badcfe,8(%rdi)
		movl	$0x10325476,12(%rdi)
		movl	$0xc3d2e1f0,16(%rdi)
		movl	$0,20(%rdi)
		movb	$0,88(%rdi)
		ret
.endif

/* void rmd160next(WORD08 *data,WORD32 length,RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160next
		.type	rmd160next,@function
		.align	16
rmd160next:
		pushq	%r12
		pushq	%r13

		movq	%rdi,%r13
		movq	%rdx,%r8
		movl	%esi,%r12d
		leaq	24(%rdx),%rdi

		addl	%esi,20(%r8)

		movzbq	88(%r8),%rcx
		testl	%esi,%esi
		je	rmd160nxtl1end
rmd160nextlp1:	testq	%rcx,%rcx
		je	rmd160nxtl1end
		movb	(%r13),%al
		incq	%r13
		movb	%al,(%rdi,%rcx,)
		incq	%rcx
		cmpq	$64,%rcx
		je	rmd160nxtcont1
		decl	%r12d
		jne	rmd160nextlp1
		jmp	rmd160nxtl1end
rmd160nxtcont1:	call	rmd160block
		xorq	%rcx,%rcx
		decl	%r12d

rmd160nxtl1end:	movq	%rcx,%r9
		cmpl	$64,%r12d
		jnae	rmd160nxtl2end

rmd160nextlp2:	movq	%r13,%rdi
		call	rmd160block
		subl	$64,%r12d
		addq	$64,%r13
		cmpl	$64,%r12d
		jnb	rmd160nextlp2

rmd160nxtl2end:	movl	%r12d,%edx
		shrl	$2,%r12d
		je	rmd160nxtl3end

rmd160nextlp3:	movl	(%r13),%eax
		addq	$4,%r13
		movl	%eax,24(%r8,%r9,)
		addq	$4,%r9
		decl	%r12d
		jne	rmd160nextlp3

rmd160nxtl3end:	andl	$3,%edx
		je	rmd160nextend

rmd160nextlp4:	movb	(%r13),%al
		incq	%r13
		movb	%al,24(%r8,%r9,)
		incq	%r9
		decl	%edx
		jne	rmd160nextlp4

rmd160nextend:	movb	%r9b,88(%r8)

		popq	%r13
		popq	%r12
		ret

.endif

/* void rmd160end(WORD08 *result,RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160end
		.type	rmd160end,@function
		.align	16
rmd160end:
		pushq	%r12

		movq	%rdi,%r9
		movq	%rsi,%r8
		leaq	24(%rsi),%rdi

		movzbq	88(%r8),%r12
		incq	%r12
		movq	%r12,%rax
		movb	$128,-1(%rdi,%r12,)
		andl	$3,%eax
		je	rmd160endlaend

rmd160endlpa:	movb	$0,(%rdi,%r12,)
		incl	%eax
		incq	%r12
		cmpl	$4,%eax
		jne	rmd160endlpa

rmd160endlaend:	shrq	$2,%r12
		jmp	rmd160endlbbeg

rmd160endlpb:	movl	$0,(%rdi,%r12,4)
		incq	%r12

rmd160endlbbeg:	cmpq	$14,%r12
		je	rmd160endlbend
		cmpq	$16,%r12
		jne	rmd160endlpb
		xorq	%r12,%r12
		call	rmd160block
		leaq	24(%r8),%rdi
		jmp	rmd160endlpb

rmd160endlbend:	movl	20(%r8),%edx
		shlq	$3,%rdx
		movq	%rdx,80(%r8)
		call	rmd160block

		movq	(%r8),%rax
		movq	8(%r8),%rcx
		movl	16(%r8),%edx
		movq	%rax,(%r9)
		movq	%rcx,8(%r9)
		movl	%edx,16(%r9)

.ifdef RMD160_PARANOID
		xorq	%rax,%rax
		movq	%rax,24(%r8)
		movq	%rax,32(%r8)
		movq	%rax,40(%r8)
		movq	%rax,48(%r8)
		movq	%rax,56(%r8)
		movq	%rax,64(%r8)
		movq	%rax,72(%r8)
		movq	%rax,80(%r8)
.endif
		popq	%r12
		ret

.endif

/* void rmd160(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef RMD160_FAST

.globl rmd160
		.type	rmd160,@function
		.align	16
rmd160:
		pushq	%r12
		pushq	%r13
		subq	$84,%rsp

		movq	%rdi,%r13
		movl	%esi,%r12d
		movq	%rsp,%r8
		movl	$0x67452301,(%rsp)
		movl	$0xefcdab89,4(%rsp)
		movl	$0x98badcfe,8(%rsp)
		movl	$0x10325476,12(%rsp)
		movl	$0xc3d2e1f0,16(%rsp)

		pushq	%rsi
		movq	%rdx,%r9
		cmpl	$64,%r12d
		jnae	rmd160loop2end

rmd160loop2:	movq	%r13,%rdi
		call	rmd160block
		subl	$64,%r12d
		addq	$64,%r13
		cmpl	$64,%r12d
		jnb	rmd160loop2

rmd160loop2end:	movl	%r12d,%ecx
		movl	%r12d,%esi
		movq	%r13,%rdx
		xorq	%r12,%r12
		leaq	28(%rsp),%rdi
		shrl	$2,%ecx
		je	rmd160lp3bbeg

rmd160loop3a:	movl	(%rdx,%r12,4),%eax
		movl	%eax,(%rdi,%r12,4)
		incq	%r12
		decl	%ecx
		jne	rmd160loop3a
		leaq	(,%r12,4),%r12

rmd160lp3bbeg:	andl	$3,%esi
		je	rmd160loop3end

rmd160loop3b:	movb	(%rdx,%r12,),%al
		movb	%al,(%rdi,%r12,)
		incq	%r12
		decl	%esi
		jne	rmd160loop3b

rmd160loop3end:	incq	%r12
		movq	%r12,%rax
		movb	$128,-1(%rdi,%r12,)
		andq	$3,%rax
		je	rmd160lp4aend

rmd160loop4a:	movb	$0,(%rdi,%r12,)
		incl	%eax
		incq	%r12
		cmpl	$4,%eax
		jne	rmd160loop4a

rmd160lp4aend:	shrq	$2,%r12
		jmp	rmd160lp4bbeg

rmd160loop4b:	movl	$0,(%rdi,%r12,4)
		incq	%r12

rmd160lp4bbeg:	cmpq	$14,%r12
		je	rmd160loop4end
		cmpq	$16,%r12
		jne	rmd160loop4b
		xorq	%r12,%r12
		call	rmd160block
		leaq	28(%rsp),%rdi
		jmp	rmd160loop4b

rmd160loop4end:	popq	%rdx
		shlq	$3,%rdx
		movq	%rdx,56(%rdi)
		call	rmd160block

		movq	(%rsp),%rax
		movq	8(%rsp),%rcx
		movl	16(%rsp),%edx
		movq	%rax,(%r9)
		movq	%rcx,8(%r9)
		movl	%edx,16(%r9)

.ifdef RMD160_PARANOID
		xorq	%rax,%rax
		movq	%rax,20(%rsp)
		movq	%rax,28(%rsp)
		movq	%rax,36(%rsp)
		movq	%rax,44(%rsp)
		movq	%rax,52(%rsp)
		movq	%rax,60(%rsp)
		movq	%rax,68(%rsp)
		movq	%rax,76(%rsp)
.endif

		addq	$84,%rsp
		popq	%r13
		popq	%r12
		ret

.endif

/* void rmd160hmkey(WORD08 *key,WORD32 keylength,RMD160HMDATA *ptr) */

.ifdef	_RMD160_HMAC

.globl rmd160hmkey
		.type	rmd160hmkey,@function
		.align	16
rmd160hmkey:
		pushq	%r12
		pushq	%r13

		movq	%rdi,%r12
		movq	%rdx,%r13
		movq	%rsi,%r9
		subq	$112,%rsp

		cmpl	$65,%esi
		jnae	rmd160hmkey1

		movq	%rsp,%rdi
		call	rmd160init
		movq	%r12,%rdi
		movq	%rsp,%rdx
		call	rmd160next
		leaq	92(%rsp),%rdi
		movq	%rsp,%rsi
		movq	%rdi,%r12
		call	rmd160end
		xorq	%rax,%rax
		movq	$20,%r9
		movq	%rax,(%rsp)
		movq	%rax,8(%rsp)
		movl	%eax,16(%rsp)

rmd160hmkey1:	movl	$0x67452301,(%r13)
		movl	$0xefcdab89,4(%r13)
		movl	$0x98badcfe,8(%r13)
		movl	$0x10325476,12(%r13)
		movl	$0xc3d2e1f0,16(%r13)
		movl	$0x67452301,20(%r13)
		movl	$0xefcdab89,24(%r13)
		movl	$0x98badcfe,28(%r13)
		movl	$0x10325476,32(%r13)
		movl	$0xc3d2e1f0,36(%r13)

		movq	%rsp,%rdi
		xorq	%rcx,%rcx
		movb	$54,%dl
		jmp	rmd160hmkey2
rmd160hmkeylp3:	movb	(%r12,%rcx,),%al
		xorb	%dl,%al
		movb	%al,(%rdi,%rcx,)
		incq	%rcx
rmd160hmkey2:	cmpl	%ecx,%r9d
		jne	rmd160hmkeylp3

		jmp	rmd160hmkey3
rmd160hmkeylp4:	movb	%dl,(%rsp,%rcx,)
		incq	%rcx
rmd160hmkey3:	cmpq	$64,%rcx
		jne	rmd160hmkeylp4

		movq	%r13,%r8
		call	rmd160block

		xorq	%rcx,%rcx
		movb	$92,%dl
		jmp	rmd160hmkey4
rmd160hmkeylp5:	movb	(%r12,%rcx,),%al
		xorb	%dl,%al
		movb	%al,(%rsp,%rcx,)
		incq	%rcx
rmd160hmkey4:	cmpl	%ecx,%r9d
		jne	rmd160hmkeylp5

		jmp	rmd160hmkey5
rmd160hmkeylp6:	movb	%dl,(%rsp,%rcx,)
		incq	%rcx
rmd160hmkey5:	cmpq	$64,%rcx
		jne	rmd160hmkeylp6

		addq	$20,%r8
		movq	%rsp,%rdi
		call	rmd160block

		movq	$20,%rdx
		xorl	%eax,%eax
rmd160hmkeylp7:	decl	%edx
		movl	%eax,(%rsp,%rdx,4)
		movb	%al,92(%rsp,%rdx,)
		jne	rmd160hmkeylp7

		addq	$112,%rsp
		popq	%r13
		popq	%r12
		ret

.endif

/* void rmd160hminit(RMD160DATA *ptr,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FULL

.globl rmd160hminit
		.type	rmd160hminit,@function
		.align	16
rmd160hminit:
		movq	(%rsi),%rax
		movq	%rax,(%rdi)
		movq	8(%rsi),%rax
		movq	%rax,8(%rdi)
		movl	16(%rsi),%eax
		movl	%eax,16(%rdi)
		movl	$64,20(%rdi)
		movb	$0,88(%rdi)
		ret

.endif

/* void rmd160hmend(WORD08 *result,RMD160DATA *ptr,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FULL

.globl rmd160hmend
		.type	rmd160hmend,@function
		.align	16
rmd160hmend:
		pushq	%r12
		movq	%rdx,%r12
		call	rmd160end

		movb	$0,88(%r8)
		movq	20(%r12),%rax
		movq	28(%r12),%rdx
		movl	36(%r12),%ecx
		movq	%rax,(%r8)
		movq	%rdx,8(%r8)
		movl	%ecx,16(%r8)
		movl	$64,20(%r8)

		movq	%r8,%rdx
		movq	$20,%rsi
		movq	%r9,%rdi
		movq	%r9,%r12
		call	rmd160next

		movq	%r12,%rdi
		movq	%r8,%rsi
		call	rmd160end

		popq	%r12
		ret

.endif

/*void rmd160hmac(WORD08 *data,WORD32 length,WORD08 *result,RMD160HMDATA *key)*/

.ifdef	RMD160_HMAC_FAST

.globl rmd160hmac
		.type	rmd160hmac,@function
		.align	16
rmd160hmac:
		pushq	%r12
		pushq	%r13
		movq	%rdx,%r12
		movq	%rcx,%r13
		subq	$92,%rsp

		movb	$0,88(%rsp)

		movq	(%r13),%rax
		movq	8(%r13),%rdx
		movl	16(%r13),%ecx
		movq	%rax,(%rsp)
		movq	%rdx,8(%rsp)
		movl	%ecx,16(%rsp)

		movl	$64,20(%rsp)

		movq	%rsp,%rdx
		call	rmd160next

		movq	%r12,%rdi
		movq	%rsp,%rsi
		call	rmd160end

		movb	$0,88(%rsp)

		movq	20(%r13),%rax
		movq	28(%r13),%rdx
		movl	36(%r13),%ecx
		movq	%rax,(%rsp)
		movq	%rdx,8(%rsp)
		movl	%ecx,16(%rsp)

		movl	$64,20(%rsp)

		movq	%r12,%rdi
		movq	$20,%rsi
		movq	%rsp,%rdx
		call	rmd160next

		movq	%r12,%rdi
		movq	%rsp,%rsi
		call	rmd160end

		addq	$92,%rsp
		popq	%r13
		popq	%r12
		ret

.endif
