/* 
 * Copyright (c) 2001 Secure Software Solutions
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef C_TOKENS_H
#define C_TOKENS_H

/*
 * Tokens that are specific to the C language
 */

#define AUTO            (TOKEN_C_START +  0)
#define CASE            (TOKEN_C_START +  1)
#define CHAR            (TOKEN_C_START +  2)
#define CONST           (TOKEN_C_START +  3)
#define DEFAULT         (TOKEN_C_START +  4)
#define DO              (TOKEN_C_START +  5)
#define DOUBLE          (TOKEN_C_START +  6)
#define ENUM            (TOKEN_C_START +  7)
#define EXTERN          (TOKEN_C_START +  8)
#define FLOAT           (TOKEN_C_START +  9)
#define GOTO            (TOKEN_C_START + 10)
#define INT             (TOKEN_C_START + 11)
#define LONG            (TOKEN_C_START + 12)
#define REGISTER        (TOKEN_C_START + 13)
#define SHORT           (TOKEN_C_START + 14)
#define SIGNED          (TOKEN_C_START + 15)
#define SIZEOF          (TOKEN_C_START + 16)
#define STATIC          (TOKEN_C_START + 17)
#define STRUCT          (TOKEN_C_START + 18)
#define SWITCH          (TOKEN_C_START + 19)
#define TYPEDEF         (TOKEN_C_START + 20)
#define UNION           (TOKEN_C_START + 21)
#define UNSIGNED        (TOKEN_C_START + 22)
#define VOID            (TOKEN_C_START + 23)
#define VOLATILE        (TOKEN_C_START + 24)


#define DEC_OP          (TOKEN_C_START + 27)
#define INC_OP          (TOKEN_C_START + 28)
#define PTR_OP          (TOKEN_C_START + 29)
#define AND_OP          (TOKEN_C_START + 30)
#define OR_OP           (TOKEN_C_START + 31)

#endif
