/*
 * Copyright  2002  Networks Associates Technology, Inc.
 * All rights reserved.
 *
 * priv_impl.h
 * Header file for the implimentation bits of privman.  Things common
 * between the server and the client halves.
 *
 * $Id: priv_impl.h,v 1.11 2002/08/02 17:52:34 dougk Exp $
 */


/* Global variables */

extern int              privmand_fd;

extern pid_t            child_pid;

extern config_t        *config;

/* The first byte of a command message.  What is this command? */
enum commands {
    CMD_OPEN                    = 'o',
    CMD_BIND                    = 'b',

    CMD_PAM_START               = 'p',
    CMD_PAM_AUTHENTICATE        = 'a',
    CMD_PAM_ACCT_MGMT           = 'm',
    CMD_PAM_END                 = 'P',
    CMD_PAM_SETCRED		= 'c',
    CMD_PAM_OPEN_SESSION        = 's',
    CMD_PAM_CLOSE_SESSION       = 'S',
    CMD_PAM_GET_ITEM            = 'i',
    CMD_PAM_SET_ITEM            = 'I',
    CMD_PAM_GETENV              = 'e',
    CMD_PAM_PUTENV              = 'E',
    CMD_PAM_CHAUTHTOK           = 't',

    CMD_SETUID                  = 'u',

    CMD_FORK                    = 'f',
    CMD_EXIT                    = 'x',  /* This process going away. */
    CMD_DAEMON                  = 'd',

    CMD_RERUN_AS                = 'R',
    CMD_EXEC_AS                 = 'X'
};

/* Virtual structure of the command message:
 * {
 *      int             command;
 *      byte            command_specific_data[];
 * }
 *
 * Virtual structure of the repsonce:
 * {
 *     int              privman_rc;
 *                      // < 0, errno = -privman_rc; return -1;
 *                      // > 0, command_specific return (PAM mostly)
 *                      // = 0, success.
 *     byte             command_specific_data[];
 * }
 */

/* Convience message functions to help with this:
 */

static __inline__ 
void msg_init(message_t *msg, enum commands cmd) {
    msg_clear(msg);
    msg_addInt(msg, cmd);
}

static __inline__ 
void msg_initResponce(message_t *msg, int rc) {
    msg_clear(msg);
    msg_addInt(msg, rc);
}


/* Factor out some of the common error handling */
static __inline__ void boom(const char *where) __attribute((__noreturn__));
static __inline__ void boom(const char *where)
{
#if 0
    syslog(LOG_INFO, "%s: %m", where);
#endif
    perror(where);
    /* Only one of the two processes should exit().  The other should
     * _exit().  To allow atexit() et. all to work for the client
     * processes, the parent will use _exit().
     */
    if (child_pid == 0)
        exit(-1);
    else
        _exit(-1);
}

static __inline__
void msg_recvmsg(message_t *msg, int fd, const char *boommsg) {
    int n = msg_recvmsg(msg, fd);
    if (n < 0)
        boom(boommsg);
}

static __inline__
void msg_sendmsg(message_t *msg, int fd, const char *boommsg) {
    int n = msg_sendmsg(msg, fd);
    if (n < 0)
        boom(boommsg);
}

/* Codes for messages back to the client.  Do you need to run the
 * conversion function?
 */
enum privman_responces {
    PRIV_NONE           = 0, /* Nothing to do here.             */
    PRIV_PAM_RC         = 1, /* Standard Pam return code        */
    PRIV_PAM_RUN_CONV,       /* Run the PAM conversion function */

    PRIV_SET_COE             /* Set Close-on-exec               */
};

/* The server control function */
void privman_serv_init(void);

void priv_sep_init(void (*servfn)(void),
    void (*childfn)(const char *), const char *childfn_arg);
