/*
 * Copyright  2002  Networks Associates Technology, Inc.
 * All rights reserved.
 *
 * check_user.c
 * This is a simplification and modification of the "check_user" program
 * contributed to PAM by Shane Watts.
 *
 * For privman test purposes, its uses the "login" pam stack instead
 * of its own.
 *
 * $Id: check_user.c,v 1.6 2002/08/02 17:52:34 dougk Exp $
 */

#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <stdio.h>

#include "privman.h"

static struct pam_conv conv = {
    misc_conv,
    NULL
};

int main(int argc, char *argv[])
{
    pam_handle_t *pamh=NULL;
    int retval;
    const char *user="nobody";

    priv_init("check_user");

    if(argc == 2) {
        user = argv[1];
    }

    if(argc > 2) {
        fprintf(stderr, "Usage: check_user [username]\n");
        exit(1);
    }

    /* Use "login" cause I don't feel like copying check_user to pam.d */
    retval = priv_pam_start("login", user, &conv, &pamh);

    if (retval != PAM_SUCCESS) {
        fprintf(stdout, "pam_start failed.\n");
        goto failed;
    }
        
    retval = priv_pam_authenticate(pamh, 0); /* is user really user? */
    if (retval != PAM_SUCCESS) {
        fprintf(stdout, "Not Authenticated!\npam_authenticate failed.\n");
        goto failed;
    }

    retval = priv_pam_acct_mgmt(pamh, 0);    /* permitted access? */
    if (retval != PAM_SUCCESS) {
        fprintf(stdout, "pam_acct_mgmt failed.\n");
        goto failed;
    } else {
        fprintf(stdout, "Authenticated\n");
    }

failed:
    if (priv_pam_end(pamh,retval) != PAM_SUCCESS) {     /* close Linux-PAM */
        pamh = NULL;
        fprintf(stderr, "check_user: failed to release authenticator\n");
        exit(1);
    }

    return ( retval == PAM_SUCCESS ? 0:1 );       /* indicate success */
}
