/*
 * Copyright  2002  Networks Associates Technology, Inc.
 * All rights reserved.
 *
 *
 * Privman header file.
 * Software that uses the privman library should include this header.
 *
 * Generally, you will see "priv_foo" as a method analogous to foo, but
 * implimented by invoking the privman server.
 *
 * Start your program by calling "priv_init()"
 * priv_init() splits the process.  One process will continue with priviledge
 * as the priviledged server, the other will return from priv_init() as
 * the unpriviledged client.
 *
 * int main(int argc, char *argv[]) {
 *      privman_init(argv[0]);
 *      ....
 *      fd = priv_open("path/to/file",flags,mode);
 *      ....
 *      fd = socket();
 *      priv_bind(fd, addr, addrlen);
 *      listen(fd, backlog)
 *      fd = accept(fd);
 *      ...
 *
 * $Id: privman.h,v 1.10 2002/08/27 23:16:09 dougk Exp $
 */

#ifndef PRIVMAN_H
#define PRIVMAN_H 1

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <security/pam_appl.h>

void    priv_init(const char *appname);
int     priv_open(const char *pathname, int flags, ...);
FILE*   priv_fopen(const char *pathname, const char *mode);
int     priv_bind(int sockfd, struct sockaddr *addr, socklen_t addrlen);

int     priv_pam_start(const char *service, const char *user,
                    const struct pam_conv *conv,
                    pam_handle_t **pamh_p);
int     priv_pam_authenticate(pam_handle_t *pamh, int flags);

int     priv_pam_acct_mgmt(pam_handle_t *pamh, int flags);

int     priv_pam_end(pam_handle_t *pamh, int flags);

int     priv_pam_setcred(pam_handle_t *pamh, int flags);

int     priv_pam_open_session(pam_handle_t *pamh, int flags);

int     priv_pam_close_session(pam_handle_t *pamh, int flags);

int     priv_pam_chauthtok(pam_handle_t *pamh, int flags);

int     priv_pam_set_item(pam_handle_t *pamh, int item_type, const void *item);

int     priv_pam_get_item(pam_handle_t *pamh, int item_type, const void **item);

int     priv_pam_putenv(pam_handle_t *pamh, const char *name_value);

int     priv_pam_getenv(pam_handle_t *pamh, const char *name);

int     priv_pam_fail_delay(pam_handle_t *pamh, unsigned int usec);

pid_t   priv_fork(void);

int     priv_daemon(int nochdir, int noclose);

int     priv_execve(const char *program, char * const argv[],
                    char * const envp[], const char * user, const char* chroot);

int     priv_rerunas(void (*fnptr)(const char *), const char *arg,
                    const char *user, const char *chroot);
#ifdef __cplusplus
}
#endif

#endif
