/*
 * Copyright  2002  Networks Associates Technology, Inc.
 * All rights reserved.
 *
 * myrerun.c
 * This program uses priv_rerun to print 0 through 5.  Each execution
 * should be as a different user (mail, news, ftp, rpc, nobody).  This
 * program should help demonstrate the use of priv_rerunas(), a less
 * than-obvious Privman method.
 *
 * $Id: myrerun.c,v 1.3 2002/08/02 17:52:34 dougk Exp $
 */

#include "privman.h"

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Needs to be global so that rerun_fn and main can both see it. */
int state = 0;

void rerun_fn(const char * args)
{
    /* This function will run before we drop out of priv_init the second
     * through fifth times.  Futz with global state so we can recognize
     * the situation.  args comes from the priv_rerunas call, and is a 
     * null-terminated string.  Don't try and pass pointers via args,
     * it won't work.
     */
    state = atoi(args);
}

int main(void) {
    const char *users[5] = { "mail", "news", "ftp", "rpc", "nobody" };

    priv_init("myrerun");

    /* Nothing up my sleeve... */
    printf("state = %d, uid = %d/%d\n", state, getuid(), geteuid());
    if (state < 5) {
        char arg[20];
        /* Create a string to pass the state to the next iteration. */
        snprintf(arg, sizeof(arg)-1, "%d", state + 1);

        /* setuid to user, don't chroot, call rerun_fn(arg) before dropping
         * out of priv_init again.
         */
        priv_rerunas(rerun_fn, arg, users[state], 0);
        /* If we get here, something failed.  Probally an unknown user. */
        exit(EXIT_FAILURE);
    }

    exit(EXIT_SUCCESS);
}

