#ifndef _YSTRING_H
#define _YSTRING_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef _MSC_VER
#include "ywinsock.h"
#endif

#define sizeof(x)	sizeof(x)

#ifndef NULL
#define NULL 0L
#endif

typedef const char CChar;
typedef const char *ROStr;

#define elnumof(a)	(sizeof(a)/sizeof(a[0]))

#if defined(QVSTR) || defined(QS) || defined(QSS) || defined(QSX)
#define WITH_QVSTR 1

extern char VStrUNKNOWN[];
#define PCStr(s)    const char *s
#define STail(s)    &((char*)s)[sizeof(s)-1]

#if defined(__cplusplus) && !defined(QSS) || defined(QSX)
/*if(Q2){*/
#define _CAT(a,b)    a ## b
#define PVTag(s)    const char *s##FILE,int s##LINE,const char *s##BASE,int s##SIZE
#define PVStr(s)    PVTag(s),const char*const s
#define xPVStr(s)   PVTag(s),const char*s
#define UTail(b)    &b##BASE[b##SIZE-1]
#define UVStr(s)    s##FILE,s##LINE,s##BASE,s##SIZE,
#define TVSTR(t)    __FILE__,__LINE__,_CAT(t,BASE),_CAT(t,SIZE),
#define SVStr(s,b)  __FILE__,__LINE__,s==b?b:s,s==b?b##SIZE:s##SIZE,
#define HVStr(z,s)  __FILE__,__LINE__,s,z,
#define ZVStr(s,z)  HVStr(z,s) s
#define LVStr(m)    __FILE__,__LINE__,(char*)m,_CAT(m,SIZE),(char*)m
#define MVStrSiz(m) __FILE__,__LINE__,(char*)m,_CAT(m,MSIZE),(char*)m,sizeof(m)
#define NVStr(m)    __FILE__,__LINE__,m,_CAT(m,MSIZE),
#define setPStr(p,b,z)	(p = b),p##BASE=b,p##SIZE=z,p##LINE=__LINE__,p##FILE=__FILE__
#define defQStr(n)	const char *n;const char*n##BASE;int n##SIZE
#define refQStr(n,p)	const char *n=p;const char*n##BASE=_CAT(p,BASE);int n##SIZE=_CAT(p,SIZE)
#define MrefQStr(n,b)	const char *n=b;const char*n##BASE=n;int n##SIZE=_CAT(b,MSIZE)
#define setQStr(n,p,z)	(n = (char*)p),(_CAT(n,BASE)=n),(_CAT(n,SIZE)=z),n
#define McpyQStr(n,p)	(n = (char*)p),(_CAT(n,BASE)=n),(_CAT(n,SIZE)=_CAT(p,SIZE)),n
#define cpyQStr(n,p)	(n = (char*)p),(_CAT(n,BASE)=_CAT(p,BASE)),(_CAT(n,SIZE)=_CAT(p,SIZE)),n

typedef struct {
  const	char   *qFILE;
	int	qLINE;
  const	char   *qBASE;
	int	qSIZE;
	char   *q;
} QPtr;
#define cpyQPtr(d,s)	(d.qFILE = s##FILE),(d.qLINE = s##LINE),(d.qBASE = s##BASE),(d.qSIZE = s##SIZE),(d.q = (char*)s)

#endif /*}*/

#define QVStr(s,t)  TVSTR(t) (const char*)s
#define AVStr(s)    QVStr(s,s)
#define BVStr(s)    UVStr(s) s
#define EVStr(s)    ZVStr(s,sizeof(s))
#define FVStr(s)    ZVStr((char*)s,sizeof(s))
#define GVStr(s)    ZVStr((char*)s,sizeof(*(s)))
#define CVStr(s)    ZVStr(s,0)
#define DVStr(s,d)  QVStr(s+d,s)
#define TVStr(s)    QVStr(s+strlen(s),s)

int Xassert(PVStr(b),PCStr(p));
#define assertVStr(b,p)	{ if(b && UTail(b) < p){ Xassert(AVStr(b),p); break; } }
#define alertVStr(b,z)	{ if(b && UTail(b) < b+z-1){ Xassert(BVStr(b),b+z-1);} }


void VStr_overflow(PCStr(where),PVStr(d),int l,int z,PCStr(fmt),...);
void Xwhatis(PVStr(s));
char *Xstrcpy(PVStr(d),PCStr(s));
void *Xmemmove(PVStr(d),PCStr(s),int z);
char *Xstrncpy(PVStr(d),PCStr(s),int z);
char *Xstrcat(PVStr(d),PCStr(s));
#undef strcpy
#define strcpy(d,s)	Xstrcpy(TVSTR(d) d,s)
#define memmove(d,s,z)	Xmemmove(TVSTR(d) d,s,z)
#define Xovstrcpy(d,s)	Xstrcpy(d,s)
#undef strncpy
#define strncpy(d,s,z)	Xstrncpy(TVSTR(d) d,s,z)
#define strcat(d,s)	Xstrcat(TVSTR(d) d,s)
int Xsprintf(PVStr(d),PCStr(f),...);
#if defined(_MSC_VER) || defined(NONC99)
#else
#define sprintf(d,f,...) Xsprintf(TVSTR(d) d,f,##__VA_ARGS__)
#endif
int Xsscanf(PCStr(str),PCStr(fmt),...);
int XsetVStrEnd(PVStr(p),int x);

#define setVStrEnd(p,x)	      (&p[x]<=UTail(p))?(((char*)p)[x] = 0):XsetVStrEnd(AVStr(p),x)
#define setVStrElem(p,x,v)    (&p[x]<=UTail(p))?(((char*)p)[x] = v):XsetVStrEnd(AVStr(p),x)
#define setVStrElemInc(p,x,v) (&p[x]<=UTail(p))?(((char*)p)[x++]=v):XsetVStrEnd(AVStr(p),x)
#define setVStrPtrInc(p,v)    (p    <=UTail(p))?(*((char*)p++) = v):XsetVStrEnd(AVStr(p),0)

char *Xfgets(PVStr(b),int z,FILE *f);
#define fgets(b,z,f)	Xfgets(AVStr(b),z,f)
unsigned int Xfread(PVStr(b),int ez,int en,FILE *fp);
void Xbcopy(const void *s,PVStr(d),int z);
#define Bcopy(s,d,z)	Xbcopy(s,AVStr(d),z)
char *XStrncpy(PVStr(d),PCStr(s),int len);
#define QStrncpy(d,s,z)	XStrncpy(AVStr(d),s,z)
#define FStrncpy(d,s)	XStrncpy(LVStr(d),s,sizeof(d))

typedef struct {
	char *tp; /* tail */
	char *sp; /* top */
} QSP;
#define qStr(s,t) QSP s = {XVStr(t)}
#define pStr(s)   QSP *s

#define AStr(s)   s->sp
#define BStr(s)   s.sp


#else /* ---- without QVSTR ---- */

typedef struct {
	char   *q;
} QPtr;
#define cpyQPtr(d,s)	(d.q = s)

#define PCStr(s) const char *s
#define PVStr(s) char *s
#define xPVStr(s) char *s
#define UTail(t) t
#define TVSTR(t)
#define UVStr(t)
#define QVStr(s,t) s
#define SVStr(s,b)
#define AVStr(s) s
#define BVStr(s) s
#define HVStr(z,s)
#define ZVStr(s,z) s
#define FVStr(s) s
#define EVStr(s) s
#define CVStr(s) (char*)s
#define DVStr(s,d) s+d
#define TVStr(s) s+strlen(s)
#define GVStr(s) (char*)s
#define MVStrSiz(s) s,sizeof(s)
#define NVStr(m)

#define assertVStr(b,p)
#define Xassert(b,p)
#define alertVStr(b,z)

#define setPStr(p,b,z)	(p = b)
#define defQStr(name)	char *name
#define refQStr(n,p)	char *n = p
#define MrefQStr(n,b)	char *n = b
#define setQStr(n,p,z)	(n = p)
#define McpyQStr(n,p)	(n = p)
#define cpyQStr(n,p)	(n = p)

#define Xstrcpy strcpy
#define Xovstrcpy ovstrcpy
#define Xstrncpy strncpy
#define Xstrcat strcat
#define Xsprintf sprintf
#define Xsscanf sscanf
#define setVStrEnd(p,x)	p[x] = 0
#define setVStrElem(p,x,v) p[x] = v
#define setVStrElemInc(p,x,v) p[x++] = v
#define setVStrPtrInc(p,v) *p++ = v
#define XsetVStrEnd setVStrEnd
#define Xfgets fgets
#define Xfread fread
#define Xmemmove memmove
#define Bcopy bcopy
#define QStrncpy Strncpy
#define XStrncpy Strncpy
#define FStrncpy(d,s)	Strncpy(d,s,sizeof(d))

#define qStr(s,t) char *s
#define pStr(s)   char *s
#define AStr(s)   s
#define BStr(s)   s

#endif /* ---- end QVSTR ---- */

#define VStrNULL	ZVStr(((char*)NULL),0)
#define truncVStr(p)	*(char*)p = 0
#define QVSize(p)	p

#define fieldScan(f,n,v) scan_field1(f,AVStr(n),sizeof(n),AVStr(v),sizeof(v))
#define wordScanY(s,w,b) wordscanY(s,AVStr(w),sizeof(w),b)
#define wordScan(s,w)	wordscanX(s,AVStr(w),sizeof(w))
#define lineScan(s,l)	linescanX(s,AVStr(l),sizeof(l))
#define textScan(s,l)	wordscanY(s,AVStr(l),sizeof(l),"^\r\n");

/*
#ifdef __cplusplus
class CString {
private:
	int len;
	char *buf;
public:
	CString(int siz){ len = siz; buf = new char[siz]; }
};
#define CStr(name,size)	CString name(size)
#else
#define CStr(name,size)	char name[size]
#endif
*/

#ifdef WITH_QVSTR /*{*/
#if defined(__cplusplus) && !defined(QSS) || defined(QSX) /*{*/
#define SStr(n,z)	char n[z];enum{n##SIZE=z,n##MSIZE=z}
#define CStr(nam,z)	char nam[z];const char*nam##BASE=(const char*)nam;enum{nam##SIZE=z}
#define ACStr(nam,n,z)	char nam[n][z];enum{nam##SIZE=n*z}
#define NStr(n,z)	char n[z];enum{n##SIZE=z,n##MSIZE=z}
#define MStr(n,z)	char n##BASE[0];NStr(n,z)
#else /*}{*/
#define SStr(nam,z)	char nam[z]
#define CStr(nam,z)	char nam[z]
#define ACStr(nam,n,z)	char nam[n][z]
#define NStr(nam,z)	char nam[z]
#define MStr(nam,z)	char nam[z]
#endif /*}*/
#define AMStr(nam,n,z)	char nam[n][z]

#else /*}{*/
#define CStr(nam,z)	char nam[z]
#define ACStr(nam,n,z)	char nam[n][z]
#define NStr(nam,z)	char nam[z]
#define MStr(nam,z)	char nam[z]
#define AMStr(nam,n,z)	char nam[n][z]
#define SStr(nam,z)	char nam[z]
#endif /*}*/

#ifdef _MSC_VER
#define NONEMPTYARRAY
#define xMStr(n,z)	NStr(n,z)
#else
#define xMStr(n,z)	MStr(n,z)
#endif

int   syslog_ERROR(PCStr(fmt), ...);
int   syslog_DEBUG(PCStr(fmt), ...);
int   porting_dbg(PCStr(fmt),...);

int   streq(PCStr(s1),PCStr(s2));
int   strneq(PCStr(s1),PCStr(s2),int);
int   strcaseeq(PCStr(s1),PCStr(s2));
int   strcasseq(PCStr(s1),PCStr(s2));
int   strncaseeq(PCStr(s1),PCStr(s2),int);
int   strtailchr(PCStr(str));
int   isdigits(PCStr(str));
int   isdigit2(PCStr(str));
const char *Isnumber(PCStr(str));
char *strtail(PCStr(str));
char *strrpbrk(PCStr(str),PCStr(brk));
char *strtailstr(PCStr(str),PCStr(ss));
char *strcasestr(PCStr(str),PCStr(ss));

char *strcats3(PVStr(dst),PCStr(s0),PCStr(s1),PCStr(s2));
void  strreverse(PCStr(str));
void  strsubst(PVStr(str),PCStr(pat),PCStr(subs));
char *linescanX(PCStr(str),PVStr(line),int);
char *paramscanX(PCStr(src),PCStr(brk),PVStr(dst),int size);
char *wordscanX(PCStr(str),PVStr(word),int);
char *wordscanY(PCStr(str),PVStr(word),int,PCStr(brk));
char *valuescanX(PCStr(str),PVStr(val),int);
const char *awordscanX(PCStr(str),PVStr(word),int size);
void  scanwords(PCStr(sp),int wc,const char *words[]);
int   numscan(const char **spp);
char *numscanX(PCStr(str),PVStr(val),int siz);
const char *scanint(PCStr(str),int *valp);
void  scan_field1(PCStr(field),PVStr(name),int nsiz,PVStr(body),int bsiz);
int   scan_namebody(PCStr(namebody),PVStr(name),int nsiz,PCStr(nbrk),PVStr(body),int bsiz,PCStr(bbrk));

#define awordscan(s,w)   awordscanX(s,AVStr(w),sizeof(w))
#define majorminorScan(s,j,n) scan_namebody(s,AVStr(j),sizeof(j),"/",AVStr(n),sizeof(n),NULL)


int   del8bits(PVStr(dst),PCStr(src));
char *strip_spaces(PCStr(value));
int   kmxatoi(PCStr(ai));
char *strtolowerX(PCStr(s1),PVStr(s2),int siz);
char *strtoupperX(PCStr(s1),PVStr(s2),int siz);
#define strtolower(s1,s2) strtolowerX(s1,AVStr(s2),sizeof(s2))
#define strtoupper(s1,s2) strtoupperX(s1,AVStr(s2),sizeof(s2))

/*
#define FStrncpy(d,s)	Strncpy(d,s,sizeof(d))
*/
char *Strncpy(char d[],PCStr(s),int len);

char *strncpy0(PVStr(d),PCStr(s),int len);
void  Strins(PVStr(d),PCStr(s));
void  Strrplc(PVStr(d),int len,PCStr(s));

char *Sprintf(PVStr(str),PCStr(fmt),...);
char *SPrintf(void *MemF,PCStr(fmt), ...);
void  strdelchr(PCStr(src),PVStr(dst),PCStr(del));
void  reverseDomainX(PCStr(dom),PVStr(rdom),int dlm,PCStr(sep));
void  reverseDomain(PCStr(dom),PVStr(rdom));


typedef int MemFile[16];

#ifdef NONEMPTYARRAY
#define sv_idBASE sv_id
#endif
typedef struct {
	xMStr(	sv_id,16);
  const	char  **sv_ev;
	int	sv_ec;
	int	sv_ecmax;
	MemFile	sv_MemF;
} StrVec;

void  SVinit(StrVec *Sv,PCStr(what),const char **ev,int ecmax,PVStr(eb),int ebsiz);
char *SVaddEnvf(StrVec *Evp,PCStr(fmt),...);

typedef struct {
	char	ut_strg;
	char	ut_dmmy;
	short	ut_type;
	int	ut_size;
	int	ut_leng;
	defQStr(ut_addr); /* to be used by AVStr() */
} UTag;
#define Utos(u,s)	utosX(u,AVStr(s),sizeof(s))

void  uvinit(UTag *tagv[],UTag tagvb[],int nelem);
int   uvtosf(PVStr(str),int siz,PCStr(fmt),UTag *tagv[]);
int   ufromsf(PCStr(str),int siz,PCStr(fmt),UTag *tagp);
int   uvfromsf(PCStr(str),int siz,PCStr(fmt),UTag *tagv[]);
int   uvfromsfX(PCStr(str),int siz,PCStr(fmt),UTag *tagv[],const char **rsp,const char **rfp);
void  uvfmtreverse(PCStr(src),PCStr(dst),const char **rsrc,const char **rdst);
int   utosX(UTag *tag,PVStr(str),int siz);
int   utoi(UTag *tag);
int   stoV(PCStr(abuf),int mac,const char *av[],int sep);
int   ustrcmp(UTag *tag,PCStr(str));

UTag  UTalloc(int lev,int size,int algn);
void  UTfree(UTag *up);
void  UTclear(UTag *up);
char *stralloc(PCStr(str));
void  strfree(void *str);
char *StrAlloc(PCStr(str));
char *StrBufAlloc();
int  *StructAlloc(int);
#define NewStruct(t)	(t*)StructAlloc(sizeof(t))


char *getStrBuffer(int lev,int size,int al);
void  addStrBuffer(int lev,void *buff,int size);
void  delStrBuffer(int lev);
#define SB_STAT	0 /* static environment */
#define SB_PROC	1
#define SB_CONN	2
#define SB_SERV	3 /* environment for each request */


char *Strdup(char **dst,PCStr(src));
const char **dupv(const char *const*sv,int length);
void  freev(char *sv[]);
int   cmpv(const char *v1[],const char *v2[],int len);
char *Malloc(void *ptr,int size);

/*
#include "yarg.h"
*/
#ifndef _YARG_H
#define _YARG_H
typedef int (*iFUNCP)(const void*,...);
typedef int (*IFUNCP)(void*,...);
typedef void (*vFUNCP)(void*,...);
typedef char *(*sFUNCP)(void*,...);
#include <stdarg.h>
#define VARGS(ac,a0) \
	char *va[ac]; va_list ap; va_start(ap,a0); \
	{ int ai; for(ai = 0; ai < ac; ai++) va[ai] = va_arg(ap,char*); }
#define VA4	va[0],va[1],va[2],va[3]
#define VA8	va[0],va[1],va[2],va[3],va[4],va[5],va[6],va[7]
#define VA14    va[0],va[1],va[2],va[3],\
                va[4],va[5],va[6],va[7],\
                va[8],va[9],va[10],va[11],va[12],va[13]
#define VA16    va[0],va[1],va[2],va[3],\
                va[4],va[5],va[6],va[7],\
                va[8],va[9],va[10],va[11],\
		va[12],va[13],va[14],va[15]
#endif /* _YARG_H */

/*-- SCANNING LIST */
#define STR_VOLA  0
#define STR_ALLOC 1
#define STR_OVWR  2

typedef int (*scanListFuncP)(PCStr(elem),...);
#define scanListFunc int
#define scanListCall (scanListFuncP)

int   scan_List(PCStr(list),int sep,int allocm,scanListFuncP func, ...);
int   scan_ListL(PCStr(list),int,int,scanListFuncP,...);
int   scan_commaList(PCStr(list),int,scanListFuncP,...);
int   scan_commaListL(PCStr(list),int,scanListFuncP,...);

int   scanv(const char *av[],PCStr(name),iFUNCP func,void *arg1);
int   isinList(PCStr(list),PCStr(word));
int   wordIsinList(PCStr(list),PCStr(word));
int   scan_Listlist(PCStr(list),int sep,PVStr(a),PVStr(b),PVStr(c),PVStr(d),PVStr(e));
int   num_ListElems(PCStr(list),int sep);
void  subSetList(PCStr(s1),PCStr(s2),PVStr(sb));
int   list2vect(PCStr(list),int del,int ac,const char *av[]);
char *Str2vstr(PCStr(sstr),int slen,PVStr(vstr),int vlen);
int   decomp_args(const char *av[],int mac,PCStr(args),PVStr(argb));
int   strmatch_list(PCStr(str),PCStr(list),PCStr(cntrl),iFUNCP lfunc,void *lfile);

/*-- TIME FORMATTING */
extern const char *TIMEFORM_ANSI_C;
extern const char *TIMEFORM_USENET;
extern const char *TIMEFORM_HTTPDs;
extern const char *TIMEFORM_YmdHMS;
extern const char *TIMEFORM_RFC822;
extern const char *TIMEFORM_mdHMS;
extern const char *TIMEFORM_HTTPD;
extern const char *TIMEFORM_TAR;
extern const char *TIMEFORM_LS;
int   wdaytoi(PCStr(wday));
#include <time.h> /* for time_t */
int   StrftimeGMT(PVStr(atime),int size,PCStr(fmt),time_t clock,int usecond);
int   StrftimeLocal(PVStr(atime),int size,PCStr(fmt),time_t clock,int usecond);
int   fromclockLocal(time_t clock,int *w,int *y,int *m,int *d,int *H,int *M,int *S);
int   LsDateClock(PCStr(date),time_t now);
int   scanYmdHMS_GMT(PCStr(stime));
int   YMD_HMS_toi(PCStr(ymdhms));
int   scan_period(PCStr(period),int dfltunit,int dflt);
int   scanNNTPtime(PCStr(stime));
int   scanHTTPtime(PCStr(stime));
int   scanUNIXFROMtime(PCStr(stime));
void  canon_date(PVStr(date));
double Scan_period(PCStr(period),int dfltunit,double dflt);
void  getTimestamp(PVStr(stime));
char *scanLsDate(PCStr(str),PVStr(date));
long  Gettimeofday(int *usec);

/*-- CODE CONVERSION */
typedef struct _CCX *CCXP;
CCXP  CCXnew(PCStr(from),PCStr(to));
int   CCXcreate(PCStr(from),PCStr(to),CCXP);
int   CCXexec(CCXP,PCStr(cinb),int ilen,PVStr(out),int osiz);
int   CCXactive(CCXP);
void  CCX_setincode(CCXP,PCStr(ccn));
void  CCXthru8(CCXP,PCStr(thru8));
int   CCXwithJP(CCXP);
void  CCXclear(CCXP);
const char *CCXcharset(CCXP);
int   CCXoutcharset(CCXP,const char **xcode);
int   CCXguessing(CCXP);
const char *CCXident(CCXP);
int   CCXcharsetcmp(PCStr(cs1),PCStr(cs2));
int   UCSinit();
void  UCSreset();
void  strip_ISO2022JP(PVStr(str));
char *strpbrk1B(const void *src,PCStr(brks),char **dst,PVStr(end));
int   FIX_2022(PCStr(src),PVStr(dst),PCStr(ctype));
void  TO_JIS(PCStr(src),PVStr(dst),PCStr(ctype));
void  TO_EUC(PCStr(src),PVStr(dst),PCStr(ctype));
void  TO_SJIS(PCStr(src),PVStr(dst),PCStr(ctype));
void  TO_UTF8(PCStr(src),PVStr(dst),PCStr(ctype));
void  TO_euc(PCStr(in),PVStr(out),int osiz);
void  CCXfile(PCStr(icharset),PCStr(ocharset),FILE *in,FILE *out);
int   codeconv_set(int enable,PCStr(charcode),int p2h);
int   codeconv_get(PCStr(ctype),const char **xcharset, int *p2h);
int   codeconv_line(PCStr(src),PVStr(dst),PCStr(ctype),int repair);

/*-- stdio on memory */
typedef struct _StrHead *StrHP;
void  str_sopen(StrHP,PCStr(id),char buf[],int size,int peak,PCStr(mode));
int   str_sputc(int ch, StrHP);
char *str_sptell(StrHP);
int   str_stell(StrHP);
int   str_sprintf(StrHP,PCStr(form), ... );
FILE *str_fopen(char buf[],int,PCStr(mode));
char *str_fgets(PVStr(s),int z,FILE *f);
int   str_fclose(FILE*);

/*-- MIME */
char *strSeekEOH(PCStr(head));
int   RFC821_skipheader(FILE *afp,FILE *out,PCStr(field));
int   RFC821_skipbody(FILE *afp,FILE *out,PVStr(line),int size);
void  RFC822_addHeaderField(PVStr(dst),PCStr(src));
void  RFC822_addresspartX(PCStr(in),PVStr(out),int siz);
char *RFC822_readHeader(FILE *in,int seeEOR);
char *matchFields(PCStr(spec),PCStr(field),PCStr(ivalue));
void  filterFields(PCStr(spec),PVStr(head));
void  generic_domain(PVStr(hostaddr));
char *RFC822_fgetsHeaderField(PVStr(line),int size,FILE *fp);
char *fgetsHeaderField(FILE *hfp,PCStr(name),PVStr(value),int size); 
int   relayBODYpart(FILE *src,FILE *dst,const char *boundaries[],int extract,PVStr(endline));
void  relayRESPBODY(FILE *fs,FILE *tc,PVStr(line),int size);
void  decodeHEAD1(PCStr(tp),PVStr(xp),int decode,int cconv);
int   relay_pgpSIGN(FILE *fs,FILE *tc,const char *boundaries[],PVStr(endline));
int   relay_pgpSIGNED(FILE *fs,FILE *tc,const char *boundaries[],PVStr(endline));
int   scanAddrInBody(PCStr(spec),PVStr(line));
char *findField(PCStr(head),PCStr(field),const char **value);
char *findFieldValue(PCStr(head),PCStr(field));
int   replace_charset(PVStr(head),PCStr(charset));
int   replace_charset_value(PVStr(ctype),PCStr(charset),int force);
int   replaceContentType(PVStr(head),PCStr(type));
int   erase_charset_param(PVStr(ctype),PVStr(charset));
char *RFC822_valuescan(PCStr(vp),PVStr(value),int size);
void  RFC822_decompField2(PCStr(head),PVStr(fname),PVStr(value),int size);
void  RFC822_strip_commentX(PCStr(in),PVStr(out),int siz);
char *nextField(PCStr(field),int ignEOH);
char *getFieldValue2(PCStr(head),PCStr(field),PVStr(value),int size);
void  removeFields(PVStr(head),PCStr(field),int wild);
int   rmField(PVStr(head),PCStr(field));
int   extractParam(PVStr(head),PCStr(fname),PCStr(pname),PVStr(pvalue),int pvsize,int del);
void  msg_charcount(FILE *fp,int chcount[]);
void  PGPdecodeMIME(FILE*src,FILE*dst,FILE*cache, int filter,int codeconv,int enHTML);
void  PGPencodeMIME(FILE *src,FILE *dst);
void  thruRESP(FILE *fs,FILE *tc);
int   uu_skip(int *ctx,PCStr(src));

typedef FILE *(*headFilter)(PVStr(head),FILE *tc,FILE *cache);
headFilter set_HEAD_filter(headFilter filter);

void  myMIMEversion(PVStr(ver));
void  scan_PGP(void*,PCStr(conf));

double Time();
void  MIME_rewaddrs(PCStr(rewaddr),PVStr(head));
int   get_charset(PCStr(ctype),PVStr(chset),int size);
void  selectXref(PCStr(host),PCStr(xref1),PVStr(xref2));
int   findXref(FILE *afp,int (*matchfunc)(PCStr(a),PCStr(b)),PCStr(host),PVStr(xref),int size);
int   decodeBODY(FILE *fs,FILE *tc,int filter,PCStr(encoding),PCStr(decodeto),int do_enHTML);
void  decodeTERM(FILE *fs, FILE *tc, int enHTML);
void  decodeTERM1(PCStr(line),PVStr(xline));
void  MIME_strHeaderEncode(PCStr(ins),PVStr(outs), int osize);
void  MIME_strHeaderDecode(PCStr(ins),PVStr(outs), int osize);
void  MIME_to64(FILE *in, FILE *out);
int   str_to64(PCStr(in),int isize,PVStr(out),int osize,int pnl);
int   str_from64(PCStr(in),int isize,PVStr(out),int osize);
int   str_fromqp(PCStr(in),int isize,PVStr(out),int osize);
int   str_toqp(PCStr(in),int isize,PVStr(out),int osize);
int   replaceFieldValue(PVStr(head),PCStr(field),PCStr(value));

/*-- REGULAR EXPRESSION */
struct fa_stat *frex_create(PCStr(rexp));
struct fa_stat *frex_append(struct fa_stat *fsp,PCStr(rexp));
char *frex_match(struct fa_stat *fsp,PCStr(str));
char *frex_matchX(struct fa_stat *fsp,PCStr(str),const char **start);
void  frex_free(struct fa_stat *fsp);
int   rexpmatch(PCStr(rexp),PCStr(str));
int   RexpMatch(PCStr(str),PCStr(rexp));

/*-- HASH */
int   Hcreate(int nelem,PCStr(nulval));
const char *Hsearch(int htid,PCStr(key),PCStr(data));
int   Hnext(int htid,int kx,const char **keyp,const char **datap);
int   strid_create(int nelem);
int   strid(int tab,PCStr(str),int id);
void  strid_stat(int tab);
unsigned int FQDN_hash(PCStr(key));

/*-- URL */
int   nonxalpha_unescape(PCStr(src),PVStr(dst),int spacealso);
void  safe_escapeX(PCStr(src),PVStr(dst),int siz);
int   url_escapeX(PCStr(src),PVStr(dst),int siz,PCStr(escs),PCStr(sbrk));

/*-- HTML */
int   isHTMLentity(PCStr(str),int*);
void  decode_entities(PCStr(src),PVStr(dst));
void  decodeEntities(PCStr(src),PVStr(dst),int);
void  decodeEntitiesX(PCStr(src),PVStr(dst),int siz,int anywhere);
int   encodeEntitiesX(PCStr(src),PVStr(dst),int siz);
int   encode_entitiesX(PCStr(src),PVStr(dst),int siz);

void  onoff_flags(PVStr(flags),PCStr(delta),int on);
char *getv(const char *vv[],PCStr(name));

void  PutEnv(PCStr(name),PCStr(value));

typedef int (*sortFunc)(const void*,const void*);
void  toMD5(PCStr(str),char md5[]);

int   proc_title(PCStr(fmt),...);
char *getUsernameCached(int,PVStr(name));
int   Uname(PVStr(name));

char *ovstrcpy(char dst[],PCStr(src));
void  stackcopy(char *av[],int ac,char *asT,char *esT,char **areap,int *lengp,int *sizep);

#include <sys/types.h>
#include <time.h>
char *rsctime(time_t clock,PVStr(lsdate));
long timeBaseDayLocal(time_t clock);

#ifdef _MSC_VER /* VC++ {*/
int  bcmp(const void *,const void *,unsigned int);
void bcopy(const void*,void*,unsigned int);
void bzero(void*,unsigned int);

FILE *popen(const char*,const char*);
int  pclose(FILE*);

#include <io.h>
#include <direct.h>
#include <process.h>

#ifdef __cplusplus
unsigned int alarm(unsigned int);
int  chdir(const char*);
int  chown(const char *,int,int);
int  fchmod(int,int);
int  fcntl(int,int,void*);
int  fork();
int  ftruncate(int fd,unsigned int);
int  getegid();
int  geteuid();
int  getgid();
int  getppid();
int  gettimeofday(struct timeval *tv, struct timezone *tz);
int  getuid();
int  inet_aton(const char*,struct in_addr *);
int  kill(int,int);
int  killpg(int,int);
unsigned int lseek(int,unsigned int offset,int);
int  link(const char*,const char*);
int  lstat(const char *,struct stat *);
// int  mkdir(const char*,int);
#define mkdir(d,m) _mkdir(d)
int  pipe(int []);
int  seteuid(int);
void sleep(unsigned int);
int  strcasecmp(const char*,const char*);
int  strncasecmp(const char*,const char*,unsigned int n);
int  usleep(unsigned int);
int  utimes(const char*,struct timeval*);
int  readlink(const char*,char*,unsigned int);
int  rmdir(const char*);
int  vfork();
int  wait(int*);
int  wait3(int*,int,void*);
int  wait4(int,int*,int,void*);
int  waitpid(int,int*,int);
int  initgroups(const char*,int);

int  sigblock(int);
int  sigmask(int);
int  sigsetmask(int);
int  setsid();
int  nice(int);
int  chroot(const char*);
void setlinebuf(FILE*);
int  symlink(const char*,const char*);
void setbuffer(FILE*,char*,unsigned int);
int  fchown(int,int,int);
int  setegid(int);
int  setgid(int);
int  setuid(int);
int  socketpair(int,int,int,int[]);

struct passwd *getpwent();
void setpwent();
void endpwent();
void endhostent();

#define snprintf _snprintf

#else
#endif

#define sigsetjmp(b,s)	setjmp(b)
#define siglongjmp	longjmp
#define sigjmp_buf	jmp_buf

#else /*}else(UNIX){*/
#include <unistd.h>

int  bcmp(const void *s1, const void *s2, size_t n);
void bcopy (const void *src, void *dest, size_t n);
void bzero(void *s, size_t n);

#if defined(sun) /* SunOS5.* {*/
int sigblock(int mask);
int sigmask(int signum);
int sigsetmask(int mask);

#ifdef SOLARIS25 /* SunoS5.5 {*/
#ifdef __cplusplus
extern "C" {
#endif
int snprintf(char *str,size_t size,const char *format,...);
int usleep(unsigned int useconds);
int utimes(const char *file, struct timeval *tvp);
int killpg(pid_t pgrp,int sig);
int wait3(int *statusp, int options,struct rusage *rusage);
int gethostname(char *name,int namelen);
int inet_aton(const char *addr,struct in_addr *inap);
void setbuffer(FILE *iop,char *abuf,size_t asize);
void setlinebuf(FILE *iop);
#ifdef __cplusplus
}
#endif
#endif /*}*/
#endif /*}*/
#endif /*}*/

#ifdef __cplusplus
extern "C" {
#endif
int yp_get_default_domain(char**);
int yp_match(PCStr(dom),PCStr(map),PCStr(uids),int len,char **val,int *vlen);
#ifdef __cplusplus
}
#endif

#ifdef WITH_QVSTR /*{*/
extern char *Xstrdup(const char *F,int L,const char *s);
extern void *Xmalloc(const char *F,int L,unsigned int z);
extern void *Xcalloc(const char *F,int L,unsigned int n,unsigned int z);
extern void *Xrealloc(const char *F,int L,void *p,unsigned int z);
extern void Xfree(const char *F,int L,void *p);
extern int Xfclose(const char *F,int L,FILE *);
#ifdef strdup
#undef strdup
#endif
#define strdup(s)	Xstrdup(__FILE__,__LINE__,s)
#ifdef malloc
#undef malloc
#endif
#define malloc(z)	Xmalloc(__FILE__,__LINE__,z)
#ifdef calloc
#undef calloc
#endif
#define calloc(p,z)	Xcalloc(__FILE__,__LINE__,p,z)
#ifdef realloc
#undef realloc
#endif
#define realloc(p,z)	Xrealloc(__FILE__,__LINE__,p,z)
#ifdef free
#undef free
#endif
#define free(p)		Xfree(__FILE__,__LINE__,p)
#ifdef fclose
#undef fclose
#endif
#define fclose(p)	Xfclose(__FILE__,__LINE__,p)
#endif /*}*/

#endif /* _YSTRING_H */
