/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	forkspawn.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	990205	extracted from misc.c
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "ystring.h"
#include "vsocket.h"
#include "vsignal.h"
#include "proc.h"
#include "log.h"

/*
pid_t wait3(int *status, int options, struct rusage *rusage);
int killpg(pid_t pgrp, int sig);
*/

void BeforeExec();
/*
void endhostent(void);
*/

int doTracePid;
int (*doTraceLog)(const void*,...);
#define TraceLog	doTraceLog==0? 0 : (*doTraceLog)

int MyPID;
int Getpid(){
	if( MyPID == 0 )
		MyPID = getpid();
	return MyPID;
}
int Fork(PCStr(what))
{	register int pid;

	endhostent();
	MyPID = 0;
	pid = fork();
	if( pid == 0 ){
		MyPID = getpid();
		syslog_ERROR("-- Fork(%s): %d -> %d\n",what,getppid(),MyPID);
	}
	else{
		if( lTRVERB() )
		if( doTracePid == getpid() )
			TraceLog("+ Fork(%s) = %d\n",what,pid);
	}
	return pid;
}
extern int SPAWN_P_NOWAIT;
int spawnvp(int pmode,PCStr(path),const char *const argv[]);
int Spawnvp(PCStr(what),PCStr(path),const char *const av[])
{	int pid;

	MyPID = 0;
	pid = spawnvp(SPAWN_P_NOWAIT,path,av);
	return pid;
}

void Finish(int);
void Exit(int code,PCStr(fmt),...)
{	CStr(msg,2048);

	if( code != 0 ){
		VARGS(8,fmt);
		sprintf(msg,"Exit (%d) ",code);
		Xsprintf(TVStr(msg),fmt,VA8);
		syslog_ERROR("%s",msg);
	}
	Finish(code);
}

static int usualsig(int sig)
{
	if( sig == SIGALRM ) return 1;
	if( sig == SIGPIPE ) return 1;
	if( sig == SIGTERM ) return 1;
	return 0;
}
int WaitXX(int mode,int *sigp);
int WaitX(int mode)
{
	return WaitXX(mode,NULL);
}
extern int WAIT_WNOHANG;
int WaitXX(int mode,int *sigp)
{	int status[4]; /**/
	int pid,xpid,sig,xcode,st;

	if( sigp )
		*sigp = 0;
	for(;;){
		pid = wait3(status,mode,NULL);
		if( !lTRACE() )
		if( sigp == NULL )
			break;
		if( pid <= 0 )
			break;
		st = status[0];

		if( 0 <= (xcode = getWaitExitCode(status)) ){
			xpid = waitpid(pid,status,0);
			if( lTRVERB() )
			TraceLog("- Wait [%04X] pid=%d EXITED(%d) %d\n",
				st,pid,xcode,xpid);
			return pid;
		}
		if( 0 < (sig = getWaitExitSig(status)) ){
			xpid = waitpid(pid,status,0);
			TraceLog("- Wait [%04X] pid=%d SIGNALED(%d=%s)%s %d\n",
				st,pid,sig,sigsym(sig),
				getWaitExitCore(status)?" COREDUMP":"",xpid);
			if( sigp )
				*sigp = sig;
			return pid;
		}
		if( 0 < (sig = getWaitStopSig(status)) ){
			if( lTRVERB() || !usualsig(sig) )
			TraceLog("- Wait [%04X] pid=%d STOPSIG(%d=%s)\n",
				st,pid,sig,sigsym(sig));
			if( sig == SIGTRAP ){
				if( lNOEXEC() )
					ptraceKill(pid);
				else	ptraceContinue(pid,0);
			}else	ptraceContinue(pid,sig);
			continue;
		}
		TraceLog("- Wait [%04X] pid=%d wait unknown\n",st,pid);
		if( mode == WAIT_WNOHANG )
			break;
	}
	return pid;
}
int NoHangWait()
{
	return WaitX(WAIT_WNOHANG);
}
int NoHangWaitX(int *sigp)
{
	return WaitXX(WAIT_WNOHANG,sigp);
}
int procIsAlive(int pid)
{	int rcode;

	errno = 0;
	rcode = kill(pid,0);
	return errno != ESRCH;
}

extern char *getusernames(PVStr(names));
int Execvp(PCStr(where),PCStr(path),const char *const av[])
{	int rcode;
	CStr(pwd,1024);
	CStr(names,1024);
	const char *nav[2]; /**/
	const char *env;

	BeforeExec();
	endhostent();
	if( av[0] == NULL ){
		nav[0] = nav[1] = NULL;
		av = nav;
	}
	rcode = execvp(path,(char**)av);

	fprintf(stderr,"[%d] %s: Could not execute COMMAND: %s\n",getpid(),
		where,path);
	fprintf(stderr," with the OWNER uid/gid: %s\n",getusernames(AVStr(names)));
	fprintf(stderr," at the DIR: %s\n",getcwd(pwd,sizeof(pwd)));
	fprintf(stderr,"You should check that you can execute the COMMAND\n");
	fprintf(stderr," at the DIR with the access right of the OWNER.\n");
	if( env = getenv("PATH") )
		fprintf(stderr,"PATH=%s\n",env);
	else	fprintf(stderr,"PATH undefined.\n");
	perror("Execvp");
	Exit(-1,"%s(%s) failed(%d) errno=%d\n",where,path,rcode,errno);
	return -1;
}
int Kill(int pid,int sig)
{	int rcode;

	syslog_ERROR("Kill(%d,%d)\n",pid,sig);
	if( pid == 0 || pid == 1 || pid == -1 ){
		syslog_ERROR("Error: tried to Kill %d X-<\n",pid);
		return -1;
	}
	errno = 0;
	rcode = kill(pid,sig);
	if( rcode != 0 )
		syslog_ERROR("Kill(%d,%d)=%d, errno=%d\n",pid,sig,rcode,errno);
	return rcode;
}
int KillTERM(int pid)
{
	return Kill(pid,SIGTERM);
}
int Killpg(int pgrp,int sig)
{
	syslog_ERROR("Killpg(%d,%d)\n",pgrp,sig);
	if( pgrp == 0 || pgrp == 1 ){
		syslog_ERROR("Error: tried to Killpg %d X-<\n",pgrp);
		return -1;
	}
	return killpg(pgrp,sig);
}
