/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2004 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for evaluation, copy this material for
your own use, and distribute the copies via publically accessible on-line
media, without fee, is hereby granted provided that the above copyright
notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	stls.c (STARTTLS)
Author:		Yutaka Sato <ysato@delegate.org>
Description:
	STARTTLS

	RFC2487 SMTP
	RFC2595 IMAP and POP3
	RFC2228,draft-murray-auth-ftp-ssl-07 FTP
	(RFC2817 HTTP)

History:
	041223	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"

static int STLS_opt = 0;
void scan_STLS(Connection *Conn,PCStr(stls)){
	CStr(filt,1024);
	CStr(proto,1024);
	CStr(cmapb,1024);
	CStr(map,1024);
	CStr(opt1,1024);
	const char *cmap;
	const char *fp;
	refQStr(np,filt);
	refQStr(op,opt1);
	int fcl = 0;
	int fsv = 0;
	int opt = 0;
	const char *com = "sslway";

	cmap = wordscanY(stls,AVStr(filt),sizeof(filt),"^:");
	if( *cmap == ':' )
		cmap++;
	cmap = wordscanY(cmap,AVStr(proto),sizeof(proto),"^:");
	if( proto[0] )
		sprintf(cmapb,"starttls/{%s}%s",proto,cmap);
	else	sprintf(cmapb,"starttls%s",cmap);

	for( fp = filt; *fp;){
		int optL;
		np = wordscanY(fp,AVStr(opt1),sizeof(opt1),"^,");
		optL = 0;
		if( *opt1 == '-' ){
			ovstrcpy(opt1,opt1+1);
			optL |= PF_STLS_OPT;
		}
		if( op = strchr(opt1,'/') ){
			setVStrPtrInc(op,0);
			if( strncaseeq(op,"ssl",3) ){
				optL |= PF_STLS_SSL;
			}
		}
		if( strcaseeq(opt1,"opt") ){
			opt = PF_STLS_OPT;
		}else
		if( strcaseeq(opt1,"ssl") ){
			opt = PF_STLS_SSL;
		}else
		if( strcaseeq(opt1,"FSV") || strcaseeq(opt1,"SV") ){
			fsv = PF_STLS_DO | opt | optL;
		}else
		if( strcaseeq(opt1,"FCL") || strcaseeq(opt1,"CL") ){
			fcl = PF_STLS_DO | opt | optL;
		}else{
			syslog_ERROR("FILTER[%s]: %s\n",com,fp);
			com = fp;
			break;
		}
		fp = np;
		if( *fp == ',' )
			fp++;
	}
	if( fsv & PF_STLS_DO ){
		sprintf(map,"%s:FSV:%s",com,cmapb);
		if( fsv & PF_STLS_SSL ) Strins(AVStr(map),"-ss,");
		if( fsv & PF_STLS_OPT ) Strins(AVStr(map),"-o,");
		scan_CMAP(Conn,map);
		sv1log("STLS -> CMAP=\"%s\"\n",map);
	}
	if( fcl & PF_STLS_DO ){
		sprintf(map,"%s:FCL:%s",com,cmapb);
		if( fcl & PF_STLS_SSL ) Strins(AVStr(map),"-ss,");
		if( fcl & PF_STLS_OPT ) Strins(AVStr(map),"-o,");
		scan_CMAP(Conn,map);
		sv1log("STLS -> CMAP=\"%s\"\n",map);
	}
}

int checkWithSTLS(Connection *Conn,PCStr(what),PCStr(proto),PCStr(user)){
	CStr(filter,1024);
	int flags;

	if( withFilter(Conn,what,"starttls",proto,user,AVStr(filter)) ){
		if( (ServerFlags & PF_STLS_CHECKED) == 0 ){
			VA_gethostNAME(ToS,&Conn->sv_sockHOST);
		}
		flags = PF_STLS_CHECKED
		      | PF_STLS_DO
		      | ((strncmp(filter,"-o,",3) == 0) ? PF_STLS_OPT : 0)
		      | ((strncmp(filter,"-ss,",4) == 0) ? PF_STLS_SSL : 0);
		if( streq(what,"FCL") )
			ClientFlags = (ClientFlags & ~PF_STLS_ON) | flags;
		else	ServerFlags = (ServerFlags & ~PF_STLS_ON) | flags;
		return 1;
	}else{
		flags = PF_STLS_DO|PF_STLS_OPT|PF_STLS_ON;
		if( streq(what,"FCL") )
			ClientFlags = PF_STLS_CHECKED | ClientFlags & ~flags;
		else	ServerFlags = PF_STLS_CHECKED | ClientFlags & ~flags;
		return 0;
	}
}
int withSTLS_SV(Connection *Conn){
	return ServerFlags & PF_STLS_ON;
}
int willSTLS_SV(Connection *Conn){
	if( (ServerFlags & PF_STLS_CHECKED) == 0 ){
		checkWithSTLS(Conn,"FSV",REAL_PROTO,"");
	}
	sv1log("willSTLS_SV: ServerFlags=%X\n",ServerFlags);
	if((ServerFlags & PF_STLS_CAP) == 0 )
	if( ServerFlags & PF_STLS_DONTTRY )
	if( ServerFlags & PF_STLS_OPT ){
		sv1log("WILL NOT TRY STLS -- NOT SUPPORTED and OPTIONAL\n");
		return 0;
	}
	return ServerFlags & PF_STLS_DO;
}
int willSTLS_CL(Connection *Conn){
	if( (ClientFlags & PF_STLS_CHECKED) == 0 ){
		checkWithSTLS(Conn,"FCL",CLNT_PROTO,"");
	}
	if( ClientFlags & PF_STLS_ON )
		return 0;
	return ClientFlags & PF_STLS_DO;
}
/*
 * needSTLS() -- TLS must be started before going ahead
 */
int needSTLS(Connection *Conn){
        if( willSTLS_CL(Conn) )
        if( (ClientFlags & PF_STLS_ON) == 0 )
	if( (ClientFlags & PF_STLS_OPT) == 0 )
		return 1;
	return 0;
}
static int insertTLS_CL(Connection *Conn,int client,int server){
	int fcl = -1;
	if( willSTLS_CL(Conn) ){
		fcl = insertFCLX(Conn,"starttls",CLNT_PROTO,client,server);
		if( 0 <= fcl ){
			ClientFlags |= PF_STLS_ON;
		}
	}
	return fcl;
}
static int insertTLS_SV(Connection *Conn,int client,int server){
	int fsv = -1;
	if( willSTLS_SV(Conn) ){
		fsv = insertFSVX(Conn,"starttls",REAL_PROTO,client,server);
		if( 0 <= fsv ){
			ServerFlags |= PF_STLS_ON;
		}
	}
	return fsv;
}


#define lfprintf SMTP_lfprintf
void SMTP_lfprintf(FILE *log,FILE *tosc,PCStr(fmt),...);
void SMTP_putserv(FILE *log,FILE *fs,FILE *ts,PVStr(resp),PCStr(fmt),...);

int SMTP_STARTTLS_withCL(Connection *Conn,FILE *fc,FILE *tc){
	CStr(stat,1024);
	int fcl;

	if( willSTLS_CL(Conn) ){
		fcl = insertTLS_CL(Conn,FromC,ToS);
		if( 0 <= fcl ){
			lfprintf(NULL,tc,"220 Ready to start TLS\r\n");
			fflush(tc);
			fflush(fc);
			dup2(fcl,fileno(tc));
			dup2(fcl,fileno(fc));
			close(fcl);
			return 1;
		}
	}
	lfprintf(NULL,tc,"454 A Don't start TLS\r\n");
	fflush(tc);
	return 0;
}
int SMTP_STARTTLS_withSV(Connection *Conn,FILE *ts,FILE *fs){
	CStr(stat,1024);
	int fsv;

	if( willSTLS_SV(Conn) ){
		SMTP_putserv(NULL,fs,ts,AVStr(stat),"STARTTLS\r\n");
		if( stat[0] != '2' ){
			goto NOTLS;
		}
		fsv = insertTLS_SV(Conn,FromC,ToS);
		if( fsv < 0 ){
			goto NOTLS;
		}
		dup2(fsv,fileno(ts));
		dup2(fsv,fileno(fs));
		close(fsv);
	}
	return 0;
NOTLS:
	ServerFlags &= ~PF_STLS_ON;
	if( (ServerFlags & PF_STLS_OPT) == 0 )
		return -1;
	else	return 0;
}

int POP_STARTTLS_withCL(Connection *Conn,FILE *fc,FILE *tc,PCStr(com),PCStr(arg)){
	if( strcaseeq(com,"STLS") ){
		if( willSTLS_CL(Conn) ){
			int fcl;
			fcl = insertTLS_CL(Conn,ToC,ToS);
			if( 0 <= fcl ){
				fputs("+OK\r\n",tc);
				fflush(tc);
				dup2(fcl,fileno(tc));
				dup2(fcl,fileno(fc));
				close(fcl);
			}else{
				fputs("-ERR\r\n",tc);
			}
			return 1;
		}
	}
	return 0;
}
int POP_STARTTLS_withSV(Connection *Conn,FILE *ts,FILE *fs,PCStr(user)){
	CStr(resp,1024);

	if( willSTLS_SV(Conn) ){
		fputs("STLS\r\n",ts);
		fflush(ts);
		if( fgets(resp,sizeof(resp),fs) == NULL )
			return -1;
		if( *resp == '+' ){
			int fsv;
			fsv = insertTLS_SV(Conn,ToC,ToS);
			if( 0 <= fsv ){
				dup2(fsv,fileno(ts));
				dup2(fsv,fileno(fs));
				close(fsv);
				return 0;
			}
		}else{
			return -2;
		}
	}
	return 0;
}

int IMAP_STARTTLS_withCL(Connection *Conn,FILE *fc,FILE *tc,PCStr(tag),PCStr(com),PCStr(arg)){
	if( willSTLS_CL(Conn) == 0 )
		return 0;

	if( strcaseeq(com,"STARTTLS") ){
		int fcl;
		fcl = insertTLS_CL(Conn,ToC,ToS);
		if( 0 <= fcl ){
			fprintf(tc,"%s OK Begin TLS negotiation\r\n",tag);
			fflush(tc);
			dup2(fcl,fileno(tc));
			dup2(fcl,fileno(fc));
			close(fcl);
		}else{
			fprintf(tc,"%s BAD\r\n",tag);
		}
		return 1;
	}
	return 0;
}
int IMAP_STARTTLS_withSV(Connection *Conn,FILE *ts,FILE *fs,PCStr(user)){
	CStr(resp,1024);
	CStr(code,1024);

	if( willSTLS_SV(Conn) ){
		fputs("stls0 STARTTLS\r\n",ts);
		fflush(ts);
		if( fgets(resp,sizeof(resp),fs) == NULL )
			return -1;
		*code = 0;
		Xsscanf(resp,"%*s %s",AVStr(code));

		if( strcaseeq(code,"OK") ){
			int fsv;
			fsv = insertTLS_SV(Conn,ToC,ToS);
			if( 0 <= fsv ){
				dup2(fsv,fileno(ts));
				dup2(fsv,fileno(fs));
				close(fsv);
				return 0;
			}
		}else{
			return -2;
		}
	}
	return 0;
}

#define comeq(com1,com2) (strcasecmp(com1,com2) == 0)
int FTP_STARTTLS_withCL(Connection *Conn,FILE *tc,FILE *fc,PCStr(com),PCStr(arg)){
	if( comeq(com,"AUTH") ){
		sv1log("#### %s %s\n",com,arg);
		if( comeq(arg,"TLS") || comeq(arg,"SSL") ){
			int fcl;
			if( willSTLS_CL(Conn) )
				fcl = insertTLS_CL(Conn,ToC,ToS);
			else	fcl = -1;
			if( 0 <= fcl ){
				ClientSock = dup(ClientSock);
				fprintf(tc,"234 OK\r\n");
				fflush(tc);
				fflush(fc);
				dup2(fcl,fileno(tc));
				dup2(fcl,fileno(fc));
				return 1;
			}else{
				fprintf(tc,"500 not supported\r\n");
				return 1;
			}
		}
	}else
	if( comeq(com,"PBSZ") ){
		sv1log("#### %s %s\n",com,arg);
		fprintf(tc,"200 OK\r\n");
		return 1;
	}else
	if( comeq(com,"PROT") ){
		sv1log("#### %s %s\n",com,arg);
		fprintf(tc,"200 OK\r\n");
		return 1;
	}
	else
	if( comeq(com,"QUIT")
	){
		return 0;
	}else
	if( needSTLS(Conn) ){
		sv1log("#### needAUTH, rejected %s %s\n",com,arg);
		fprintf(tc,"534 do AUTH first.\r\n");
		fflush(tc);
		return 1;
	}
	return 0;
}
int FTP_STARTTLS_withSV(Connection *Conn,FILE *ts,FILE *fs){
	if( 0 <= ToS )
	if( willSTLS_SV(Conn) ){
		CStr(resp,128);

		if( ServerFlags & PF_STLS_SSL )
			fprintf(ts,"AUTH SSL\r\n");
		else	fprintf(ts,"AUTH TLS\r\n");
		fflush(ts);
		fgets(resp,sizeof(resp),fs);
		
		if( *resp == '2' ){
			int fsv;
			fsv = insertTLS_SV(Conn,ToC,ToS);
			if( 0 <= fsv ){
				ToSX = dup(ToS); /* for ServSock() */
				dup2(fsv,fileno(ts));
				dup2(fsv,fileno(fs));
				close(fsv);

				if( (ServerFlags & PF_STLS_SSL) == 0 ){
					/* AUTH TLS */
					if( *resp == '2' ){
						fprintf(ts,"PBSZ 0\r\n");
						fflush(ts);
						fgets(resp,sizeof(resp),fs);
					}
					if( *resp == '2' ){
						fprintf(ts,"PROT P\r\n");
						fflush(ts);
						fgets(resp,sizeof(resp),fs);
					}
				}
				return 1;
			}
		}
		if( (ServerFlags & PF_STLS_OPT) == 0 ){
			return -1;
		}
	}
	return 0;
}
int FTP_dataSTLS_FCL(Connection *Conn,Connection *dataConn,int cldata)
{	int fcldata;

	if( (ClientFlags & PF_STLS_ON) == 0 ){
		return -1;
	}
	dataConn->cl.p_flags = ClientFlags & ~PF_STLS_ON;
	fcldata = insertTLS_CL(dataConn,cldata,-1);
	return fcldata;
}
int FTP_dataSTLS_FSV(Connection *Conn,Connection *dataConn,int svdata)
{	int fsvdata;

	if( (ServerFlags & PF_STLS_ON) == 0 ){
		return -1;
	}
	dataConn->sv.p_flags = ServerFlags & ~PF_STLS_ON;
	fsvdata = insertTLS_SV(dataConn,-1,svdata);
	if( 0 <= fsvdata ){
		dup2(fsvdata,svdata);
		close(fsvdata);
		ToS = svdata;
		return 1;
	}
	return -1;
}
