/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-2000 Yutaka Sato and ETL,AIST,MITI
Copyright (c) 2001-2005 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for evaluation, copy this material for
your own use, and distribute the copies via publically accessible on-line
media, without fee, is hereby granted provided that the above copyright
notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
////////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include "ystring.h"
#include "dglib.h"

#define NAME	"DeleGate"
#define VERSION	"9.0.0"
#define DATE	"April 22, 2005"
#define AUTHOR	"Yutaka Sato"
#define A_ORG	"National Institute of Advanced Industrial Science and Technology"
#define A_EMAIL	"ysato AT delegate DOT org"
#define A_SITE	"delegate.org"

#define COPYRIGHT "\
AIST-Product-ID: 2000-ETL-198715-01, H14PRO-049, H15PRO-165\r\n\
Copyright (c) 1994-2000 Yutaka Sato and ETL,AIST,MITI\r\n\
Copyright (c) 2001-2005 National Institute of Advanced Industrial Science and Technology (AIST)"

static const char *copyright;
const char *DELEGATE_copyright(){
	CStr(buf,0x2000);
	int len;
	if( copyright == 0 ){
		strcpy(buf,COPYRIGHT);
		if( LICENSEE != 0 && *LICENSEE != 0 ){
			strcat(buf,"\r\nLicensee: ");
			len = strlen(buf);
			XStrncpy(QVStr(buf+len,buf),LICENSEE,sizeof(buf)-len);
		}
		copyright = StrAlloc(buf);
	}
	return copyright;
}

const char *DELEGATE_ver()
{
	return VERSION;
}
const char *DELEGATE_date()
{
	return DATE;
}
static const char *verdate;
const char *DELEGATE_verdate(){
	CStr(buf,128);
	if( verdate == 0 ){
		sprintf(buf,"%s/%s (%s)",NAME,VERSION,DATE);
		verdate = StrAlloc(buf);
	}
	return verdate;
}
static const char *version;
const char *DELEGATE_version(){
	CStr(buf,128);
	if( version == 0 ){
		sprintf(buf,"%s/%s by %s",
					NAME,VERSION, A_EMAIL);
		version = StrAlloc(buf);
	}
	return version;
}
static const char *Ver;
const char *DELEGATE_Ver(){
	CStr(buf,128);
	if( Ver == 0 ){
		sprintf(buf,"%s/%s (%s) by %s (%s)",
					NAME,VERSION, DATE, AUTHOR, A_ORG);
		Ver = StrAlloc(buf);
	}
	return Ver;
}
static const char *Version;
const char *DELEGATE_Version(){
	CStr(buf,128);
	if( Version == 0 ){
		sprintf(buf,"%s (%s) %s", DELEGATE_version(), AUTHOR, DATE);
		Version = StrAlloc(buf);
	}
	return Version;
}

const char *DELEGATE_Distribution(){
	return "ftp://ftp.delegate.org/pub/DeleGate/";
}

const char *DELEGATE_homepage(){
	return "http://www.delegate.org/delegate/";
}

void put_identification(FILE *out)
{
	fprintf(out,"%s\r\n",DELEGATE_verdate());
	fprintf(out,"%s\r\n",DELEGATE_copyright());
	fprintf(out,"--\r\n");
	fprintf(out,"FTP: <URL:%s>\r\n",DELEGATE_Distribution());
	fprintf(out,"WWW: <URL:http://www.%s/>\r\n",A_SITE);
	fprintf(out,"Mail:<URL:mailto:feedback@%s>\r\n",A_SITE);
	fprintf(out,"     <URL:http://www.%s/feedback/>\r\n",A_SITE);
}

const char *DELEGATE_pubkey = "\
-----BEGIN PUBLIC KEY-----\r\n\
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDb/8XpXTswqHMXW0teUA+8nYRS\r\n\
nT01WzFEcrNWxD43Zx6jqBSq3741RGpa6aYnXBpowbJBs4dIy3YrXHhoGKWtXfvN\r\n\
iaDXL4z+x+oRvaQulEFUFOdZxFMYDL7AgXN/wFoRktkbrd6I0HdMoPPdekJC6216\r\n\
m5E5y+hrNTxYSOMP/QIDAQAB\r\n\
-----END PUBLIC KEY-----\r\n\
";
