/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	winreg.c (Windows Registry Access)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	980630	extracted from winserv.c
//////////////////////////////////////////////////////////////////////#*/

#include "ystring.h"

#ifdef _MSC_VER

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <winbase.h>

const char *env_REGSERV = "REGSERV";

#define SERVICE_REG  "SYSTEM\\CurrentControlSet\\Services"
#define OSERVICE_REG "Software\\Microsoft\\Windows\\CurrentVersion"

void regPutVec(PCStr(what),PCStr(servname),int ac,const char *av[])
{	HKEY hkey;
	DWORD disp;
	LONG res;
	CStr(rkey,1024);
	CStr(args,0x2000);
	refQStr(ap,args); /**/
	int ai;

	sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,servname,what);
	res = RegCreateKeyEx(
		HKEY_LOCAL_MACHINE,
		rkey,
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkey,
		&disp);

	for(ai = 0; ai < ac; ai++){
		strcpy(ap,av[ai]);
		ap += strlen(ap) + 1;
	}
	setVStrPtrInc(ap,0);

	res = RegSetValueEx(
		hkey,
		"ARGV",
		0,
		REG_MULTI_SZ,
		(unsigned const char*)args, ap-args);

	if( res != 0 ){
		printf("ERROR. Cannot set registry: %s\r\n",av[ai]);
		exit(0);
	}

	printf("OK. %s are saved in registry:\r\n\"%s\\%s\"\n",
		what,"HKEY_LOCAL_MACHINE",rkey);

	RegCloseKey(hkey);
}
int regGetVec(PCStr(what),PCStr(servname),int mac,const char *av[])
{	HKEY hkey;
	CStr(rkey,1024);
	CStr(argb,0x2000);
	defQStr(args); /*alloc*//**/
	const char *ap;
	int bi;
	unsigned int long type,len;
	int res;
	int nac;

	sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,servname,what);
	res = RegOpenKeyEx(
		HKEY_LOCAL_MACHINE,
		rkey,
		0,
		KEY_QUERY_VALUE,
		&hkey);
		
	type = REG_MULTI_SZ;
	len = sizeof(argb);
	res = RegQueryValueEx(
		hkey,
		"ARGV",
		NULL,
		&type,
		(unsigned char*)argb,
		&len);

	setQStr(args,(char*)malloc(len),len);
	Bcopy(argb,args,len);

	nac = 0;
	for( ap = args; *ap; ap++ ){
		if( mac-1 <= nac ){
			break;
		}
		av[nac++] = (char*)ap;
		ap += strlen(ap);
/* ap += strlen(ap) + 1 ??? */
	}
	av[nac] = 0;

	RegCloseKey(hkey);
	return nac;
}
int regPutService(PCStr(servname),int ac,const char *av[])
{	CStr(rkey,1024);
	HKEY hkey;
	LONG res;
	DWORD disp;
	const char *a1;
	CStr(args,2048);
	refQStr(ap,args); /**/
	int ai;
	unsigned long int type,len;
	unsigned char value[2048]; /**/
	CStr(yn,128);
	const char *rstype;

	if( (rstype = getenv(env_REGSERV)) == NULL )
		rstype = "once";
	if( strcaseeq(rstype,"once") )
		sprintf(rkey,"%s\\RunServicesOnce",OSERVICE_REG);
	else	sprintf(rkey,"%s\\RunServices",OSERVICE_REG);
	printf("Registry: HKEY_LOCAL_MACHINE\\%s\r\n",rkey);

	res = RegCreateKeyEx(
		HKEY_LOCAL_MACHINE,
		rkey,
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkey,
		&disp);

	if( res != ERROR_SUCCESS ){
		printf("ERROR: cannot open the registry\r\n");
		return -1;
	}

	len = sizeof(value);
	res = RegQueryValueEx(hkey,servname,NULL,&type,value,&len);
	if( res == ERROR_SUCCESS ){
		printf("Serivce exists: %s = %s\n",servname,value);
		printf("Remove it ? [y] / n : ");
		fflush(stdout);
		fgets(yn,sizeof(yn),stdin);
		if( yn[0] != 'y' && yn[0] != '\r' && yn[0] != '\n' )
			goto EXIT;
		RegDeleteValue(hkey,servname);
		printf("Register new service ? [y] / n : ");
		fflush(stdout);
		fgets(yn,sizeof(yn),stdin);
		if( yn[0] != 'y' && yn[0] != '\r' && yn[0] != '\n' )
			goto EXIT;
	}

	ap = args;
	for( ai = 0; ai < ac; ai++ ){
		if( 0 < ai )
			setVStrPtrInc(ap,' ');
		a1 = av[ai];
		if( strpbrk(a1," \t") && strchr(a1,'"') == NULL )
			sprintf(ap,"\"%s\"",a1);
		else	strcpy(ap,a1);
		ap += strlen(ap);
	}
	strcpy(ap," -SERVICE");

	res = RegSetValueEx(
		hkey,
		servname,
		0,
		REG_SZ,
		(unsigned char*)args, strlen(args));
	printf("Registered new serivce: %s = %s\r\n",servname,args);
	printf("Reboot the system to enable this service.\r\n");

EXIT:
	RegCloseKey(hkey);
	return 0;
}

static int scanregdir(PVStr(rkey),PVStr(buf),PVStr(where));
static void getresconfX(HKEY hkey,PCStr(skey),PVStr(where),PVStr(buf));
#define getresconf(hkey,buf)	getresconfX(hkey,rkey,BVStr(where),BVStr(buf))

int regGetResolvConf(PVStr(buf),PVStr(where))
{	HKEY hkey;
	CStr(rkey,1024);
	LONG res;

	setVStrEnd(buf,0);
	setVStrEnd(where,0);
	sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,"Tcpip","Parameters");

	{	refQStr(tp,rkey); /**/
		tp = rkey + strlen(rkey);
		strcpy(tp,"\\Transient"); /* Win2K and later ? */
		res = RegOpenKeyEx(HKEY_LOCAL_MACHINE, rkey, 0,
			KEY_QUERY_VALUE, &hkey);
		if( res == ERROR_SUCCESS ){
			getresconf(hkey,buf);
			RegCloseKey(hkey);
		}
		setVStrEnd(tp,0);
	}

	res = RegOpenKeyEx(HKEY_LOCAL_MACHINE, rkey, 0,
		KEY_QUERY_VALUE, &hkey);

	if( res != ERROR_SUCCESS ){
		sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,"VxD","MSTCP");
		res = RegOpenKeyEx(HKEY_LOCAL_MACHINE, rkey, 0,
			KEY_QUERY_VALUE, &hkey);
		if( res != ERROR_SUCCESS )
			return -1;
	}


	getresconf(hkey,buf);
	RegCloseKey(hkey);

	if( buf[0] != 0 )
		return 0;

	sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,"Tcpip","Parameters");
	strcat(rkey,"\\Interfaces");
	scanregdir(AVStr(rkey),AVStr(buf),AVStr(where));
	return 0;
}
static int scanregdir(PVStr(rkey),PVStr(buf),PVStr(where))
{	HKEY hkey,hkey1;
	refQStr(tp,rkey); /**/
	CStr(skey,256);
	DWORD ksize;
	FILETIME mtime;
	DWORD ski;
	LONG res;

	res = RegOpenKeyEx(HKEY_LOCAL_MACHINE, rkey, 0,
		KEY_ENUMERATE_SUB_KEYS, &hkey);
	if( res != ERROR_SUCCESS )
		return -1;
	tp = rkey + strlen(rkey);

	for( ski = 0; ski < 20; ski++ ){
		ksize = sizeof(skey);
		skey[0] = 0;
		res = RegEnumKeyEx(hkey,ski,skey,&ksize,NULL,NULL,NULL,&mtime);
		if( res != ERROR_SUCCESS )
			break;
		sprintf(tp,"\\%s",skey);
		res = RegOpenKeyEx(HKEY_LOCAL_MACHINE, rkey, 0,
			KEY_QUERY_VALUE, &hkey1);
		if( res == ERROR_SUCCESS ){
			getresconf(hkey1,buf);
			RegCloseKey(hkey1);
		}
	}
	RegCloseKey(hkey);
	return 0;
}

static void getresconfX(HKEY hkey,PCStr(skey),PVStr(where),PVStr(buf))
{	refQStr(bp,buf); /**/
	unsigned long int type,len;
	int nv,vi;
	LONG res;
	unsigned char value[1024]; /**/
	ACStr(vv,4,256);
	const char *bp0;

	type = REG_MULTI_SZ;
	len = sizeof(value);
	res = RegQueryValueEx(hkey,"NTEContextList",NULL,&type,value,&len);
	if( res == ERROR_SUCCESS ){
		if( value[0] == 0 ){
			/* this interface seems inactive */
			return;
		}
	}

	bp += strlen(buf);
	bp0 = bp;

	type = REG_SZ;
	len = sizeof(value);
	res = RegQueryValueEx(hkey,"Domain",NULL,&type,value,&len);
	if( res != ERROR_SUCCESS || value[0] == 0 ){
		type = REG_SZ;
		len = sizeof(value);
	res = RegQueryValueEx(hkey,"DhcpDomain",NULL,&type,value,&len);
	}
	if( res == ERROR_SUCCESS && value[0] ){
		sprintf(bp,"domain %s\r\n",value);
		bp += strlen(bp);
	}

	type = REG_SZ;
	len = sizeof(value);
	res = RegQueryValueEx(hkey,"SearchList",NULL,&type,value,&len);
	if( res == ERROR_SUCCESS && value[0] ){
		sprintf(bp,"search %s\r\n",value);
		bp += strlen(bp);
	}

	type = REG_SZ;
	len = sizeof(value);
	res = RegQueryValueEx(hkey,"NameServer",NULL,&type,value,&len);
	if( res != ERROR_SUCCESS || value[0] == 0 ){
		type = REG_SZ;
		len = sizeof(value);
	res = RegQueryValueEx(hkey,"DhcpNameServer",NULL,&type,value,&len);
	}
	if( res == ERROR_SUCCESS && value[0] ){
		const unsigned char *dp;
		for( dp = value; *dp; dp++ )
			if( *dp == ',' )
				*(char*)dp = ' ';
		nv = Xsscanf((char*)value,"%s %s %s %s",EVStr(vv[0]),EVStr(vv[1]),EVStr(vv[2]),EVStr(vv[3]));
		for( vi = 0; vi < nv; vi++ )
		{
			sprintf(bp,"nameserver %s\r\n",vv[vi]);
		bp += strlen(bp);
		}
	}

	if( bp != bp0 ){
		strcpy(where,skey);
	}
}


#else
int regGetResolvConf(PVStr(buf),PVStr(where))
{
	setVStrEnd(buf,0);
	return -1;
}
#endif
