/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2004 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for evaluation, copy this material for
your own use, and distribute the copies via publically accessible on-line
media, without fee, is hereby granted provided that the above copyright
notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ystring.c (boundary checkiing string manipulation)
Author:		Yutaka Sato <ysato@delegate.org>
Description:
History:
	041107	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>

int daemonlog(const char *what,const char *fmt,...);
void Abort(int code,const char *fmt,...);

char *Xstrdup(const char *F,int L,const char *s){
	char *mp;
	mp = strdup(s);
	if( mp == NULL ){
		Abort(0,"FAILED strdup(%X) %s:%d\n",s,F,L);
	}
	return mp;
}
void *Xmalloc(const char *F,int L,unsigned int z){
	void *mp;
	mp = malloc(z);
	if( mp == NULL ){
		Abort(0,"FAILED Xmalloc(%d) %s:%d\n",z,F,L);
	}
	return mp;
}
void *Xcalloc(const char *F,int L,unsigned int n,unsigned int z){
	void *mp;
	mp = calloc(n,z);
	if( mp == NULL ){
		Abort(0,"FAILED Xcalloc(%d,%d) %s:%d\n",n,z,F,L);
	}
	return mp;
}
void *Xrealloc(const char *F,int L,void *p,unsigned int z){
	void *mp;
	mp = realloc(p,z);
	if( mp == NULL ){
		Abort(0,"FAILED Xrealloc(%X,%d) %s:%d\n",p,z,F,L);
	}
	return mp;
}
void Xfree(const char *F,int L,void *p){
	free(p);
}
int Xfclose(const char *F,int L,FILE *fp){
	return fclose(fp);
}

#include "ystring.h"

#if !defined(QSS)
#define dTAIL &dBASE[dSIZE-1]
#define AdTAIL dBASE,dSIZE
#else
#define dBASE d
#endif

#undef memmove
#undef strncpy
#undef sprintf
#undef scanf

SStr(VStrUNKNOWN,1);

#if defined(WITH_QVSTR)

#define DBG_INIT	1
#define DBG_ABORT	2
#define DBG_VERBOSE	4

static int debug_flags;
static int nov;
static void setup_debug(){
	const char *env;
	if( (debug_flags & DBG_INIT) != 0 ){
		return;
	}
	debug_flags |= DBG_INIT;
	if( env = getenv("DEBUG_VSTR") ){
		if( strstr(env,"abort") )
			debug_flags |= DBG_ABORT;
		if( strstr(env,"verb") )
			debug_flags |= DBG_VERBOSE;
	}
/*
	if( debug_flags & DBG_VERBOSE )
		fprintf(stderr,"DEBUG_VSTR %X\n",debug_flags);
*/
}
void Xwhatis(PVStr(d)){
	const char *F = dFILE;
	int L = dLINE;
	const char *T = dTAIL;
	int z;
	if( T == 0 )
		z = 0;
	else	z = (char*)T - d + 1;
	fprintf(stderr,"#### %s:%d %X - %X - %X (%d/%d)\n",F,L,dBASE,d,T,z,T-dBASE+1);
}

void VStr_overflow(PCStr(where),PVStr(d),int len,int siz,PCStr(fmt),...){
	char msg[1024]; /**/
	VARGS(16,fmt);
	snprintf(msg,sizeof(msg),"VStr overflow in %s (%s:%d) %d/%d %X-%X ",
		where,dFILE,dLINE,len,siz,d,dTAIL);
	snprintf(msg+strlen(msg),sizeof(msg)-strlen(msg),fmt,VA16);
	fprintf(stderr,"## [%d] %s\n",getpid(),msg);
	daemonlog("F","%s\n",msg);

	if( debug_flags & DBG_ABORT ){
daemonlog("E","#### abort after 10 seconds...\n");
sleep(10);
		abort();
	}
	nov++;
	if( 10 < nov )
		usleep(100);
}

int Xassert(PVStr(d),PCStr(p)){
	if( dTAIL <= p ){
		VStr_overflow("Xassert",dFILE,dLINE,AdTAIL,d,p-d,dTAIL-d,"");
		sleep(1);
		return -1;
	}
	return 0;
}

void *Xmemmove(PVStr(d),PCStr(s),int size){
	int z;
	if( dTAIL == 0 )
		z = 0;
	else	z = (char*)dTAIL - d + 1;
	if(dTAIL+1 < d+size){
		VStr_overflow("Xmemmove",dFILE,dLINE,AdTAIL,d,size,z,"");
		size = dTAIL+1-d;
		if( size < 0 ){
			return (char*)d;
		}
	}
	return memmove((char*)d,s,size);
}
void Xbcopy(const void *s,PVStr(d),int z){
	if( dTAIL+1 < d+z ){
	VStr_overflow("Xbcopy",dFILE,dLINE,AdTAIL,d,UTail(d)-d+1,z,"");
		z = dTAIL - d + 1;
	}
	bcopy(s,(char*)d,z);
}
char *XStrncpy(PVStr(d),PCStr(s),int z){
	char *dp = (char*)d;
	int n = z;

	if( dTAIL+1 < d+z ){
	VStr_overflow("XStrncpy",dFILE,dLINE,AdTAIL,d,UTail(d)-d+1,z,"");
		n = dTAIL - d + 1;
	}
	while( 1 < n-- ){
		if( (*dp++ = *s++) == 0 )
			break;
	}
	*dp = 0;
	return (char*)d;
}
char *Xstrncpy(PVStr(d),PCStr(s),int size){
	const char *F = dFILE;
	int L = dLINE;
	const char *T = dTAIL;
	int z;

	setup_debug();
	if( T == 0 )
		z = 0;
	else	z = (char*)T - d + 1;
	if(z < size ){
		VStr_overflow("Xstrncpy",F,L,AdTAIL,d,size,z,"");
		size = z;
	}
	strncpy((char*)d,s,size);
	return (char*)d;
}
int XsetVStrEnd(PVStr(d),int x){
/*
fprintf(stderr,"######## TAIL dTAIL=%X UTAIL=%X toP=%X size=%X CUR %X\n",dTAIL,UTail(d),d,dSIZE,&d[x]);
*/
	if( dTAIL < &d[x] ){
		VStr_overflow("XsetVStrEnd",dFILE,dLINE,AdTAIL,d,x,UTail(d)-d+1,"");
		*(char*)UTail(d) = 0;
		return UTail(d)-d;
	}else{
		((char*)d)[x] = 0;
		return x;
	}
}

char *Xstrcpy(PVStr(d),PCStr(s)){
	const char *F = dFILE;
	int L = dLINE;
	const char *T = dTAIL;
	char *e; /**/
	int z;
	int l; /* source string length */
	int i;

	setup_debug();
	if( T == 0 )
		z = 0;
	else	z = (char*)T - d + 1;
	l = strlen(s);

/*
fprintf(stderr,"##### U=%X T=%X d=%X B=%X Z=%X T=%X %X\n",
VStrUNKNOWN,T,d,dBASE,dSIZE,dTAIL,T);
*/
	if(T != VStrUNKNOWN)
	if(T == 0 || 0x40000 < z || z < l ){
		VStr_overflow("Xstrcpy",F,L,AdTAIL,d,l,z,"");
	}

 if( debug_flags & DBG_VERBOSE )
 fprintf(stderr,"## [%d] Xstrcpy (%s:%d) %3X/%5X %08X - %08X\n",
	getpid(),F,L, strlen(s),z,d,s);

	e = (char*)d;
	for( i = 1; i < z; i++ ){
		if( (*e++ = *s++) == 0 ){
			break;
		}
	}
	*e = 0;
	return (char*)d;
}
char *Xstrcat(PVStr(d),PCStr(s)){
	const char *F = dFILE;
	int L = dLINE;
	const char *T = dTAIL;
	char *t; /**/
	int z;

	setup_debug();
	if( T == 0 )
		z = 0;
	else	z = (char*)T - d + 1;

 if( debug_flags & DBG_VERBOSE )
 fprintf(stderr,"## [%d] Xstcrat (%s:%d) %3X/%5X %08X - %08X)\n",
	getpid(),F,L, strlen(s),z,d,s);

	for(t = (char*)d; *t; t++);
	Xstrcpy(F,L,AdTAIL,t,s);
	return (char*)d;
}
static void vfputs(PCStr(s),FILE *f){
	const char *p;
	int ch;
	for(p = s; ch = *p; p++){
		if( 0x20 <= ch && ch < 0x7F ){
			putc(ch,f);
		}else{
			putc('.',f);
		}
	}
}
int Xsprintf(PVStr(d),PCStr(f),...){
	const char *F = dFILE;
	int L = dLINE;
	const char *T = dTAIL;
	int z,n;
	VARGS(16,f);

	setup_debug();
	if( dTAIL == 0 )
		z = 0;
	else	z = (char*)T - d + 1;
	if( 0 < z )
		n = snprintf((char*)d,z,f,VA16);
	else	n = snprintf((char*)d,0,f,VA16);

 if( debug_flags & DBG_VERBOSE ){
 fprintf(stderr,"## [%d] Xsprintf (%s:%d) %3X/%5X",
	getpid(),F,L, n,z);
 vfputs(f,stderr);
 fprintf(stderr,"\n");
 }

	if( z == 0 || z <= n || n == -1 ){
		VStr_overflow("Xsprintf",F,L,AdTAIL,d,n,z,"(%d) %s",strlen(d),f);
	}

	return n;
}

int Xsscanf(PCStr(str),PCStr(fmt),...){
	const char *f;
	int fc;
	char xfmt[1024]; /**/
	char *x; /**/
	const char *xp;
	int ni = 0;
	const char *F;
	int L;
	const char *T;
	char *d; /**/
	char *b; /**/
	int z;
	int xn;
	int xi;
	va_list ap;
	char *va[16]; /**/
	int len[16]; /**/
	char *sa[16]; /* for safety in the case where length information */
	char sc[16];  /* is longer than the real length */
	int noverflow;

	va_start(ap,fmt);
	setup_debug();

	x = xfmt;
	xp = &xfmt[sizeof(xfmt)-1];
	for(f = fmt; fc = *f; f++){
		if( xp <= x ){
			break;
		}
		*x++ = fc;
		if( fc != '%' )
			continue;
		if( elnumof(va) <= ni ){
			fprintf(stderr,"## too many format specs: %s\n",fmt);
			break;
		}
		fc = *++f;
		*x++ = fc;
		switch(fc){
			case '%': continue;
			case '*': continue;
			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
			case 'h': case 'l': case 'L': case 'j': case 't':
			case 'z': case 'q':

			case 'd': case 'i': case 'o': case 'u':
			case 'x': case 'X': case 'a': case 'A':
			case 'e': case 'E': case 'f': case 'F':
			case 'g': case 'G':
			case 'c': case 'C':
				len[ni] = 0;
				va[ni++] = va_arg(ap,char*);
				break;
			default:
			fprintf(stderr,"## unknown format [%c]%s\n",fc,fmt);
				break;
			case 's':
			case '[':
				F = va_arg(ap,char*);
				L = va_arg(ap,int);
#if !defined(QSS)
				b = va_arg(ap,char*);
				z = va_arg(ap,int);
				T = &b[z-1];
				d = va_arg(ap,char*);
				z = T - d + 1;
#else
				T = va_arg(ap,char*);
				d = va_arg(ap,char*);
				z = T - d + 1;
#endif

 if(ni==0)
 if( debug_flags & DBG_VERBOSE ){
 fprintf(stderr,"## [%d] Xsscanf (%s:%d) ",getpid(),F,L);
 vfputs(fmt,stderr);
 fprintf(stderr,"\n");
 }
				if( z <= 0 || 0x10000 < z ){
					z = 0;
fprintf(stderr,"## Xsscanf ## %d:%s size unknown [%c]%s[%d]\n",L,F,fc,fmt,ni);
sleep(2);
				}else{
					len[ni] = z;
					snprintf(x-1,8,"%d",z-1);
/* sscanf() on RedHat7.1 writes length=z+1(for  NUL) at overflow */
sa[ni] = &d[z-1];
sc[ni] = d[z-1];
d[z-1] = 0;
					x += strlen(x);
					*x++ = fc;
				}
				len[ni] = z;
				va[ni++] = d;
				break;
		}
	}
	*x = 0;
	xn = sscanf(str,xfmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6],va[7],va[8],va[9],va[10],va[11],va[12],va[13],va[14],va[15]);

	noverflow = 0;
	for(xi = 0; xi < xn; xi++){
		if(len[xi] && len[xi]-1 <= strlen(va[xi])){
			const char *dBASE = va[xi];
			int dSIZE = len[xi];
		VStr_overflow("Xsscanf",F,L,AdTAIL,va[xi],strlen(va[xi]),len[xi],"\"%s\" -> \"%s\" $%d",fmt,xfmt,xi);
			noverflow++;
		}
		if( 0 < len[xi] ){
			*sa[xi] = sc[xi];
		}
	}
	if( noverflow )
		if( debug_flags & DBG_ABORT ) abort();
	return xn;
}

char *Xfgets(PVStr(d),int siz,FILE *fp){
	char *dp; /**/
	int ch;
	int i;

	if( siz <= 1 ){
		VStr_overflow("Xfgets",dFILE,dLINE,AdTAIL,d,0,siz,"(size<=1)");
		return NULL;
	}

	dp = (char*)d;
	for( i = 0; i < siz; i++ ){
		if( dTAIL <= dp ){
			break;
		}
		ch = getc(fp);
		if( ch == EOF ){
			break;
		}
		*dp++ = ch;
		if( ch == '\n' ){
			break;
		}
	}
	*dp = 0;
	if( dTAIL <= dp && dTAIL+1 < d+siz ){
		VStr_overflow("Xfgets",dFILE,dLINE,AdTAIL,d,i,siz,"");
	}
	if( dp == d ){
		return NULL;
	}
	return (char*)d;
}

unsigned int Xfread(PVStr(d),int ez,int en,FILE *fp){
	int z;
	int rcc;

	setup_debug();
	if( dTAIL == 0 )
		z = 0;
	else	z = (char*)dTAIL - d + 1;

/*
 if( debug_flags & DBG_VERBOSE )
 fprintf(stderr,"## [%d] Xfread (%s:%d) %d/%d\n",
	getpid(),dFILE,dLINE, ez*en,z);
*/

	if( z < ez*en ){
		VStr_overflow("Xfread",dFILE,dLINE,AdTAIL,d,ez*en,z,"");
		return 0;
	}
	rcc = fread((char*)d,ez,en,fp);
	return rcc;
}

#endif
