/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996-1999 Yutaka Sato
Copyright (c) 1996-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	svconf.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	961029	extracted from service.c
//////////////////////////////////////////////////////////////////////#*/

#include "ystring.h"
#include "service.h"

extern char SERV_HTTP[];

servFunc service_ftp;
servFunc service_telnet;
servFunc service_gopher;
servFunc service_http;
servFunc service_https;
servFunc service_nntp;
servFunc service_delegate;
servFunc service_imap;
servFunc service_pop;
servFunc service_smtp;
servFunc service_X;
servFunc service_wais;
servFunc service_whois;
servFunc2 service_domain;
servFunc service_tcprelay;
servFunc service_udprelay;
servFunc service_coupler;
servFunc2 service_teleport;
servFunc service_file;
servFunc service_socks;
servFunc service_nbt;
servFunc service_syslog;
servFunc service_cgi;
servFunc service_cfi;
servFunc service_vsap;
servFunc service_exec;
servFunc service_udprelay1;
servFunc service_admin;
servFunc2 service_icp;
servFuncX service_lpr;
servFunc service_ldap;
servFunc service_tunnel1;
servFuncX service_sockmux;
servFunc service_pam;
servFunc service_DGAuth;

extern char DGAUTHpro[];

Service services[NSERVICES] = {
    {0},
    {0,0, "ftp-data",     20,service_tcprelay	},
    {1,0, "ftp",          21,service_ftp	},
    {1,0, "ftps",        990,service_ftp	},
    {1,0, "telnet",       23,service_telnet	},
    {1,0, "telnets",     992,service_telnet	},
    {0,0, "smtp",         25,service_smtp	},
    {0,0, "smtp-data",    25,service_smtp	},
    {1,0, "whois",	  43,service_whois	},
    {1,0, "domain",       53,(servFuncP)service_domain	},
    {1,0, "dns",          53,(servFuncP)service_domain	},
    {1,0, "gopher",	  70,service_gopher	},
    {0,0, "finger",	  79,service_tcprelay	},
    {1,1, "http",	  80,service_http,	SERV_HTTP },
    {1,0, "https",       443,service_https	},
    {1,0, "ssltunnel",   443,service_https	},
    {1,0, "pop",         110,service_pop	},
    {1,0, "pop3s",       995,service_pop	},
    {0,0, "imap",        143,service_imap	},
    {0,0, "imaps",       993,service_imap	},
    {0,0, "ident",       113,service_tcprelay	},
    {1,0, "nntp",	 119,service_nntp	},
    {1,0, "nntps",	 563,service_nntp	},
    {1,0, "news",	 119,service_nntp	},
    {0,0, "nbt",	 139,service_nbt	},
    {0,0, "prospero",    191,service_udprelay	},
    {0,0, "archie",      191,service_udprelay	},
    {0,0, "wais",	 210,service_wais	},
    {0,0, "tsp",         318,service_tcprelay	},
    {0,0, "ldap",        389,service_ldap	},
    {0,0, "ldaps",       636,service_ldap	},
    {1,0, "lpr",         515,(servFuncP)service_lpr	},
    {0,0, "X",	        6000,service_X		},
    {0,0, "syslog",      514,service_syslog	},

    {0,0, "talk",        517,service_tcprelay	},
    {1,0, "socks",      1080,service_socks	},
    {0,0, "cuseeme",    7648,service_tcprelay	},
    {0,0, "icp",        3130,(servFuncP)service_icp	},

    {1,1, "http-proxy",	8080,service_http	},
    {0,0, "pam",        8686,service_pam	},
    {0,0, "httpam",     8686,service_pam	},
    {0,0, DGAUTHpro,    8787,service_DGAuth	},
    {0,0, "delegate",   8700,service_delegate	},
    {0,0, "tcprelay",   8701,service_tcprelay	},
    {0,0, "udprelay",   8702,service_udprelay	},
    {0,0, "udprelay1",  8703,service_udprelay1	},
    {0,0, "teleport",   8704,(servFuncP)service_teleport	},
    {0,0, "coupler",    8705,service_coupler	},
    {1,0, "vsap",       8706,service_vsap	},
    {1,0, "sockmux",    8707,(servFuncP)service_sockmux	},
    {1,0, "thruway",    8715,0			},

    {0,0, "tunnel1",     -10,service_tunnel1	},
    {0,0, "file",        -21,service_file	},
    {0,0, "cgi",         -22,service_cgi	},
    {0,0, "cfi",         -23,service_cfi	},
    {1,0, "exec",        -35,service_exec	},
    {1,0, "data",        -40,service_http	},
    {1,0, "admin",       -80,service_admin	},
    {0,0, "builtin",     -91,0			},
    {0,0, "override",    -92,0			},
    {0,0, "readonly",    -93,0			},
    {0,0, "tar",         -94,0			},

    {0}
};
