#include <stdio.h>
#include <io.h>
#include "ystring.h"

int scan_ino;

int Scandir(const char *dirpath,int(*func)(const char*,...),...)
{	struct _finddata_t filedata;
	long File;
	int rcode = -1;
	char cwd[1024];
	VARGS(4,func);

	if( getcwd(cwd,sizeof(cwd)) == 0L )
		return -1;

	if( chdir(dirpath) != 0 )
		return -1;

	File = _findfirst("*.*",&filedata);
	chdir(cwd);

	if( File == -1L )
		return -1;

	do {
		if( rcode = (*func)(filedata.name,VA4) )
			break;

	} while ( _findnext(File,&filedata) == 0 );
	_findclose(File);
	return rcode;
}

/*
printit(file)
{
	printf("- %s\n",file);
	return 0;
}
*/
