#ifndef _LOG_H
#define _LOG_H
extern int LOG_type;

#define L_LEVEL		0x0000000F
#define LOGLEVEL	(LOG_type&0xF)

#define L_SYNC		0x00000010
#define L_FG		0x00000020
#define L_TTY		0x00000040
#define L_SILENT	0x00000100
#define	L_TERSE		0x00000200
#define L_VERB		0x00000400
#define L_EXEC		0x00000800
#define L_FORK		0x00001000
#define L_STICK		0x00002000
#define L_LOCK		0x00004000
#define L_FILETRACE	0x00008000
#define L_ARGDUMP	0x00010000
#define L_VERBABORT	0x00020000
#define L_MEMPUSH	0x00040000
#define L_SOCKET	0x00080000
#define L_HOSTMATCH	0x10000000
#define L_MOUNT		0x20000000
#define L_RAND_TRACE	0x40000000

#define L_TRACE		0x00100000
#define L_NOEXEC	0x00200000
#define L_TRVERB	0x00400000
#define L_TRTERSE	0x00800000
#define L_SIGCHLD	0x01000000
#define L_REINIT	0x02000000
#define L_ISCHILD	0x04000000
#define L_ISFUNC	0x08000000

#define lSYNC()	  	(LOG_type & L_SYNC)
#define lFG()	  	(LOG_type & L_FG)
#define lTTY()	  	(LOG_type & L_TTY)
#define lSILENT()	(LOG_type & L_SILENT)
#define lTERSE()  	(LOG_type & L_TERSE)
#define lVERB()	  	(LOG_type & L_VERB)
#define lEXEC()   	(LOG_type & L_EXEC)
#define lFORK()	  	(LOG_type & L_FORK)
#define lSTICK()  	(LOG_type & L_STICK)
#define lLOCK()	  	(LOG_type & L_LOCK)
#define lFILETRACE()	(LOG_type & L_FILETRACE)
#define lARGDUMP()	(LOG_type & L_ARGDUMP)
#define lVERBABORT()	(LOG_type & L_VERBABORT)
#define lMEMPUSH()	(LOG_type & L_MEMPUSH)

#define lTRACE()	(LOG_type & L_TRACE)
#define lNOEXEC()	(LOG_type & L_NOEXEC)
#define lTRVERB()	(LOG_type & L_TRVERB)
#define lTRTERSE()	(LOG_type & L_TRTERSE)
#define lSIGCHLD()	(LOG_type & L_SIGCHLD)
#define lISCHILD()	(LOG_type & L_ISCHILD)
#define lISFUNC()	(LOG_type & L_ISFUNC)

#define LW_CREATE	1
#define LW_EXMATCH	2

typedef struct _Logfile {
  const	char	*l_proto;
  const	char	*l_filters;	/* depend on l_proto */
  const	char	*l_pform;	/* template of path */
	defQStr(l_path);
  const	char	*l_lform;	/* format of log data */
  const	char	*l_mode;	/* mode of fopen */
	FILE	*l_fp;
	int	 l_dolock;	/* do lock */
	int	 l_lockfd;	/* extra lock file */
  const	char	*l_lkpath;
	int	 l_until;
	defQStr(l_buff);
	int	 l_size;
	int	 l_leng;
	int	 l_abandon;
	int	 l_notty;
	int	 l_dontfree;
} Logfile;

extern char LP_NOTTY[]; /* don't merge to tty even with -v option */
extern char LF_PROTOLOG[];
extern char LF_ERRORLOG[];
extern char LF_TRACELOG[];
extern char LF_LOGFILE[];
extern const char *(*LOG_stdlogfile)();
/*
extern int   (*LOG_substfile)(void*,...);
*/

extern int LOG_VERBOSE;
#define	Verbose	(LOG_VERBOSE==0 && lVERBABORT()==0) ? 0 : sv1vlog

#define InitLog	(lISCHILD()||lISFUNC()) ? 0:syslog_ERROR

#define HLdebug (LOG_type&L_HOSTMATCH)==0?0:putLog0

#endif /* _LOG_H */
