#include <io.h>
#include <sys/locking.h>

int file_isregular(int fd);

static int Locking(int fd,int type,int bytes)
{ 	int off,rcode;

	rcode = -1;
	if( 0 <= (off = tell(fd)) )
	if( 0 <= lseek(fd,0,0) ){
		rcode = locking(fd,type,bytes);
		lseek(fd,off,0);
	}
	if( rcode == -1 && !file_isregular(fd) ){
		/* treat as success, 
		 * mainly for lock_TIMEOUT not to wait non-lockable file ... ?
		 */
		rcode = 0;
	}
	return rcode;
}

int SHlockB(int fd){	return	Locking(fd,_LK_RLCK,1); }
int SHlockNB(int fd){	return	Locking(fd,_LK_NBRLCK,1); }
int EXlockB(int fd){	return	Locking(fd,_LK_LOCK,1); }
int EXlockNB(int fd){	return	Locking(fd,_LK_NBLCK,1); }
int UNlock(int fd){	return	Locking(fd,_LK_UNLCK,1); }
