/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	winserv.c (DeleGate Service)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970629	created
//////////////////////////////////////////////////////////////////////#*/

#include "ystring.h"
int DELEGATE_PAUSE;

#ifdef _MSC_VER

#define SVNAME "DeleGate"
extern const char *env_REGSERV;

#include <stdio.h>
#include <windows.h>
#include <winbase.h>
#include <winsvc.h>

#define winlog	syslog_ERROR
int regGetVec(PCStr(what),PCStr(servname),int ac,const char *av[]);
void regPutVec(PCStr(what),PCStr(servname),int ac,const char *av[]);
int regPutService(PCStr(servname),int ac,const char *av[]);

extern int (*DELEGATE_MAIN)(int ac,const char *av[]);
extern void (*DELEGATE_TERMINATE)();

int isWindows95();
int file_is(int fd);
int FullpathOfExe(PVStr(path));

/* MAX_ARGC */
#include "config.h"

static SERVICE_STATUS SvSt;
static SERVICE_STATUS_HANDLE SvStH;

#define SV_CREATE	1
#define SV_DELETE	2
#define SV_RESTART	4
#define SV_NOINTERACT	8

static VOID ServiceCtrlHandler(IN DWORD opcode)
{	DWORD status;
	const char *stat;

	switch( opcode ){
	case SERVICE_CONTROL_PAUSE:
		DELEGATE_PAUSE = 1;
		stat = "PAUSE";
		SvSt.dwCurrentState = SERVICE_PAUSED;
		break;
	case SERVICE_CONTROL_CONTINUE:
		DELEGATE_PAUSE = 0;
		stat = "CONTINUE";
		SvSt.dwCurrentState = SERVICE_RUNNING;
		break;
	case SERVICE_CONTROL_STOP:
	case SERVICE_CONTROL_SHUTDOWN:
		(*DELEGATE_TERMINATE)();
		if( opcode == SERVICE_CONTROL_SHUTDOWN )
		stat = "SHUTDOWN";
		else
		stat = "STOP";
		SvSt.dwWin32ExitCode = 0;
		SvSt.dwCurrentState = SERVICE_STOPPED;
		SvSt.dwCheckPoint = 0;
		SvSt.dwWaitHint = 0;
		SetServiceStatus(SvStH,&SvSt);
		winlog("SetStatus: %s\n",stat);
		return;
	case SERVICE_CONTROL_INTERROGATE:
		stat = "INTERROGATE";
		break;
	default:
		stat = "UNKNOWN";
		break;
	}
	winlog("SetStatus: %s\n",stat);
	if( SetServiceStatus(SvStH,&SvSt) == 0 ){
		status = GetLastError();
		winlog("SetServiceStatus Error: %d\n",status);
	}
}
static int ServiceInitialization(DWORD argc, LPTSTR *argv, DWORD *specificError)
{
	argv;
	argc;
	specificError;
	return 0;
}

static VOID ServiceStart(DWORD argc, LPTSTR *argv)
{	DWORD status;
	DWORD specificError;
	int ac,ai;
	int ec,ei;
	const char *servname;
	const char *av[MAX_ARGC]; /**/
	const char *ev[MAX_ARGC]; /**/
	int rcode;

	servname = argv[0];
	ac = regGetVec("Parameters",servname,MAX_ARGC,av);
	if( ac <= 1 ){
		winlog("ERROT. NO ARGUMENT\n");
		return;
	}

	for(ai = 0; ai < ac; ai++)
		winlog("GOT ARGV[%d] %s\n",ai,av[ai]);

	winlog("ServiceStarted(argc=%d)\n",argc);
	for(ai = 0; ai < argc; ai++)
		winlog("[%d] %s\n",ai,argv[ai]);
	for(ai = 1; ai < argc; ai++){
		if( elnumof(av)-1 <= ai )
			break;
		av[ac++] = argv[ai];
	}
	av[ac] = 0;

	SvSt.dwServiceType = SERVICE_WIN32;
	SvSt.dwCurrentState = SERVICE_START_PENDING;
	SvSt.dwControlsAccepted = SERVICE_ACCEPT_STOP
				| SERVICE_ACCEPT_SHUTDOWN
				| SERVICE_ACCEPT_PAUSE_CONTINUE;
	SvSt.dwWin32ExitCode = 0;
	SvSt.dwServiceSpecificExitCode = 0;
	SvSt.dwCheckPoint = 0;
	SvSt.dwWaitHint = 0;

	winlog("RegisterServiceCtrlHandler\n");
	SvStH = RegisterServiceCtrlHandler(TEXT(SVNAME),(LPHANDLER_FUNCTION)ServiceCtrlHandler);
	if( SvStH == 0 ){
		winlog("RegisterServiceCtrlHandler: failed\n");
		return;
	}

	winlog("Service Initialization\n");
	status = ServiceInitialization(argc,argv,&specificError);
	if( status != NO_ERROR ){
	winlog("Service Initialization: ERROR %d\n",status);
		SvSt.dwCurrentState  = SERVICE_STOPPED;
		SvSt.dwCheckPoint    = 0;
		SvSt.dwWaitHint      = 0;
		SvSt.dwWin32ExitCode = status;
		SvSt.dwServiceSpecificExitCode = specificError;
		SetServiceStatus(SvStH,&SvSt);
		exit(0);
	}

	SvSt.dwCurrentState  = SERVICE_RUNNING;
	SvSt.dwCheckPoint    = 0;
	SvSt.dwWaitHint      = 0;
	if( SetServiceStatus(SvStH,&SvSt) == 0 ){
	}

	ec = regGetVec("Environments",servname,MAX_ARGC,ev);
	for( ei = 0; ei < ec; ei++ ){
		putenv(ev[ei]);
		winlog("env set %s\n",ev[ei]);
		if( strncmp(ev[ei],"PWD=",4) == 0 ){
			chdir(ev[ei]+4);
			winlog("chdir %s\n",ev[ei]);
		}
	}

	winlog("Start DeleGate ...\n");
	rcode = (*DELEGATE_MAIN)(ac,av);

	winlog("SetStatus: %s\n","STOPPED");
	SvSt.dwCurrentState  = SERVICE_STOPPED;
	SetServiceStatus(SvStH,&SvSt);
/*
	return rcode;
*/
}
static SERVICE_TABLE_ENTRY DispatchTable[] = {
	{ TEXT(SVNAME), (LPSERVICE_MAIN_FUNCTION)ServiceStart },
	{ NULL, NULL }
};


static void dumpService(LPQUERY_SERVICE_CONFIG conf,PCStr(servname))
{	const char *str;
	DWORD dwv;

	printf("SERVICE %s configuration:\n",servname);
	printf("Type: 0x%x\n",conf->dwServiceType);
	printf("Start Type: 0x%x\n",conf->dwStartType);
	printf("Err Control: 0x%x\n",conf->dwErrorControl);
	printf("Binary Path: %s\n",conf->lpBinaryPathName);
	if( str = conf->lpLoadOrderGroup )
		printf("Load order group: %s\n",str);
	if( dwv = conf->dwTagId )
		printf("Tag ID: %d\n",dwv);
	if( str = conf->lpDependencies )
		printf("Dependencies: %s\n",str);
	if( str = conf->lpServiceStartName )
		printf("Start Name: %s\n",str);
}

int restart_service(PCStr(port),int ac,const char *av[])
{	SC_HANDLE schSCManager;
	CStr(servname,128);
	const char *p;
	SERVICE_STATUS SvSt;
	SC_HANDLE schService;
	int ok;

	sprintf(servname,"%s-P%s",SVNAME,port);
	for( p = servname; *p; p++ )
		if( *p == ':' )
			*(char*)p = '.';

	schSCManager = OpenSCManager(NULL,NULL,SC_MANAGER_ALL_ACCESS);
	if( schSCManager == NULL )
	winlog("RESTART: SCManager=%X, err=%d\n",schSCManager,GetLastError());

	schService = OpenService(schSCManager,servname,SERVICE_ALL_ACCESS);
	if( schService == NULL )
	winlog("RESTART: Service=%X err=%d\n",schService,GetLastError());

	ok = ControlService(schService,SERVICE_CONTROL_STOP,&SvSt);
	if( ok == 0 )
	winlog("RESTART: STOP=%d, err=%d\n",ok,GetLastError());

	ok = StartService(schService,ac,(LPCSTR*)av);

	if( ok == 0 )
	winlog("RESTART: START=%d, err=%d\n",ok,GetLastError());

	CloseServiceHandle(schService);
	CloseServiceHandle(schSCManager);

	winlog("RESTART %s: %s\n",ok?"OK":"ERR",servname);
	return ok;
}

static newServ(SC_HANDLE schSCManager,LPCTSTR servname,LPCTSTR dispname,LPCTSTR execpath,int ac,const char *av[],int ast)
{	SC_HANDLE schService;
	BOOL ok;
	SERVICE_STATUS SvSt;
	const char *env;
	const char *ev[MAX_ARGC]; /**/
	CStr(pwd,1024);
	int ei,ec;
	DWORD starttype;

	if( 0 < ast )
		starttype = SERVICE_AUTO_START;
	else	starttype = SERVICE_DEMAND_START;

	schService = CreateService(
		schSCManager,
		servname,
		dispname,
		SERVICE_ALL_ACCESS,
		SERVICE_WIN32_OWN_PROCESS,
		starttype,
		SERVICE_ERROR_NORMAL,
		execpath,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL);

	if( schService == NULL ){
		printf("ERROR. Cannot CREATE the service %s\n",servname);
		return 0;
	}
	printf("OK. The service is created successfully.\n");

	regPutVec("Parameters",servname,ac,av);

	ec = 0;
	for( ei = 0; env = environ[ei]; ei++ ){
		if( elnumof(ev)-2 <= ec )
			break;
		if( strncmp(env,"PATH=",5) == 0
		 || strncmp(env,"SHELL=",6) == 0
		 || strncmp(env,"PATHEXT=",8) == 0
		 || strncmp(env,"COMSPEC=",8) == 0
		 || strncmp(env,"USERNAME=",9) == 0
		)
		ev[ec++] = (char*)env;
	}
	strcpy(pwd,"PWD="); getcwd(pwd+4,sizeof(pwd)-4);
	ev[ec++] = pwd;
	ev[ec] = NULL;
	regPutVec("Environments",servname,ec,ev);

	ok = StartService(schService,0,NULL);
	if( ok )
		printf("OK. The service started successfully.\n");
	else{
		DWORD status;
		status = GetLastError();
		printf("ERROR. The service failed to start (%d).\n",status);
	}

	/* should check the status here */

	CloseServiceHandle(schService);
	return 1;
}
static int register_service(int ac,const char *av[],PCStr(servname))
{	CStr(ans,128);

	printf("Cannot open Service Control Manager.\n");
	printf("Select one of:\n");
	printf("  x - exit (do nothing)\n");
	printf("  f - execute in foreground\n");
	printf("  r - register as a service\n");
	printf(">> ");
	fflush(stdout);
	fgets(ans,sizeof(ans),stdin);
	if( ans[0] == 'x' )
		return -1;
	if( ans[0] == 'r' ){
		regPutService(servname,ac,av);
		return 1;
	}
	return 0;
}

static int deletecreate_serv(int ac,const char *av[],PCStr(port),int svcop)
{	SC_HANDLE schSCManager;
	SC_HANDLE schService;
	SERVICE_STATUS SvSt;
	CStr(servname,128);
	CStr(dispname,128);
	const char *p;
	CStr(yn,128);
	int running,ok;
	CStr(execpath,1024);
	CStr(param,256);
	int ast,ai;
	const char *env;

	strcpy(execpath,av[0]);
	if( !FullpathOfExe(AVStr(execpath)) ){
		printf("ERROR. Cannot get full-path of \"%s\"\n",av[0]);
		return 0;
	}
	av[0] = execpath;
	sprintf(dispname,"%s Server -P%s",SVNAME,port);
	for( p = port; *p; p++ )
		if( *p == ':' )
			*(char*)p = '.';
	sprintf(servname,"%s-P%s",SVNAME,port);

	schSCManager = OpenSCManager(NULL,NULL,SC_MANAGER_ALL_ACCESS);
	if( schSCManager == NULL ){
		switch( GetLastError() ){
		case ERROR_CALL_NOT_IMPLEMENTED:
			if( getenv(env_REGSERV) )
			if( register_service(ac,av,servname) )
				exit(0);
			break;
		case ERROR_DATABASE_DOES_NOT_EXIST:
			printf("SCM - database does not exist.\n");
			break;
		case ERROR_ACCESS_DENIED:
	printf("Tried to start as a service [%s], but failed.\n",dispname);
	printf("You must login as \"Administrator\"\n");
			break;
		case ERROR_INVALID_PARAMETER:
			printf("INVALID parameter to OpenSCManager()\n");
			break;
		}
		return 0;
	}

	if( svcop & SV_CREATE )
	printf("Trying to start as a service [%s] ...\n",dispname);
	schService = OpenService(schSCManager,servname,SERVICE_QUERY_CONFIG);
	if( schService == NULL )
	{
		if( (svcop & SV_CREATE) == 0 )
			return 0;
		goto NEW;
	}

/*
	LPQUERY_SERVICE_CONFIG conf;
	DWORD dwBytesNeeded;

	conf = (LPQUERY_SERVICE_CONFIG)LocalAlloc(LPTR,4096);
	if( QueryServiceConfig(schService,conf,4096,&dwBytesNeeded) )
		dumpService(conf,servname);
	else	printf("ERROR. Cannot query config: %s\n",dispname);
	LocalFree(conf);
*/
	CloseServiceHandle(schService);

	schService = OpenService(schSCManager,servname,SERVICE_STOP|DELETE);
	if( schService == NULL ){
		printf("ERROR. Cannot STOP/DELETE the service.\n");
		exit(0);
	}

	if( (svcop & SV_NOINTERACT) == 0 ){
	printf("The service `%s' exists.  Delete it ? [y] / n : ",dispname);
	fflush(stdout);
	fgets(yn,sizeof(yn),stdin);
	if( yn[0] == 'n' || yn[0] == 'N' )
		exit(0);
	}

	if( ControlService(schService,SERVICE_CONTROL_STOP,&SvSt) )
		printf("OK. STOPped the previous service.\n");

	ok = DeleteService(schService);
	CloseServiceHandle(schService);
	if( !ok ){
		printf("ERROR. Could not DELETE the service.\n");
		exit(0);
	}
	printf("OK. DELETEd the previous service.\n");

	if( (svcop & SV_CREATE) == 0 )
		return 1;

	if( (svcop & SV_NOINTERACT) == 0 ){
	printf("Create a new service ? [y] / n : ");
	fflush(stdout);
	fgets(yn,sizeof(yn),stdin);
	if( yn[0] == 'n' || yn[0] == 'N' )
		exit(0);
	}

	sleep(1); /* to make sure the deletion from the service DB ... */

NEW:
	ast = 0;
	if( env = getenv("SERVCONF") ){
		if( strcasecmp(env,"auto") == 0 )
			ast = 1;
		if( strcasecmp(env,"demand") == 0 )
			ast = -1;
	}
	for( ai = 0; ai < ac; ai++ ){
		if( strcasecmp(av[ai],"SERVCONF=auto") == 0 )
			ast = 1;
		if( strcasecmp(av[ai],"SERVCONF=demand") == 0 )
			ast = -1;
	}
	if( ast == 0 )
	if( (svcop & SV_NOINTERACT) == 0 )
	{
		printf("Set Automatic Start on System Startup ? [y] / n : ");
		fflush(stdout);
		fgets(yn,sizeof(yn),stdin);
		if( yn[0] == 'n' || yn[0] == 'N' )
			ast = -1;
		else	ast = 1;
	}
	if( ast == 0 )
		ast = 1;

	ok = newServ(schSCManager,servname,dispname,execpath,ac,av,ast);
	return ok;
}

static int at_command_prompt()
{
	return file_is(0) && file_is(1) && file_is(2);
}

int start_service(int ac,const char *av[])
{	int ai;

	for( ai = 0; ai < ac; ai++ )
		if( strcmp(av[ai],"-SERVICE") == 0 )
			goto START;

	if( isWindows95() ) /* may be on Win95 */
		return 0;
	if( ac != 1 )
		return 0;
	if( at_command_prompt() )
		return 0;

START:
	winlog("StartServiceCtrlDispatcher\n");
	if( StartServiceCtrlDispatcher(DispatchTable) == 0 ){
		/* SvcDebugOut("[DeleGate] cannot start.\n"); */
		if( at_command_prompt() )
			printf("Cannot start ServiceCtrlDispatcher\n");
	}
	return 1;
}
int delete_service(int ac,const char *av[],PCStr(port),PCStr(arg))
{
	if( strcasecmp(arg,"-hup") == 0 ){
		return restart_service(port,ac,av);
	}else	return deletecreate_serv(ac,av,port,SV_DELETE|SV_NOINTERACT);
}
int create_service(int ac,const char *av[],PCStr(port))
{	int ai;

	if( ac <= 1 )
		return 0;
	if( !at_command_prompt() )
		return 0;

	for( ai = 0; ai < ac; ai++ )
		if( strcmp(av[ai],"-SERVICE") == 0 )
			return 0;

	if( deletecreate_serv(ac,av,port,SV_CREATE) )
		exit(0);
	return 0;
}
#else
int start_service(int ac,const char *av[])
{
	return 0;
}
int restart_service(PCStr(port),int ac,const char *av[])
{
	return 0;
}
#endif
