/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	svport.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	961006	extracted from delegated.c
	961120	moved stuffs about DELEGATE_HOST/PORT from {conf,service}.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include "ystring.h"
#include "vsocket.h"
#include "delegate.h" /* Connection */
#include "fpoll.h"
#include "proc.h"

extern int DELEGATE_LISTEN;

typedef struct {
	int	 sv_sock;
  const	char	*sv_host;
	int	 sv_port;
	int	 sv_udp;
	int	 sv_tcp; /* ignore DELEGATE_LISTEN (set -1 in UDP protocols) */
	int	 sv_keep; /* keep bound, but don't use to accept */
  const	char	*sv_vsap; /* accepting via VSAP */
} ServerPort;

typedef struct {
	int    pid;
	int    ppid;
	int    time;
} CloseOnTime;

typedef struct {
  const char   *se_serverHostPort;   /* my (maybe pseudo) host:port */
	MStr(	se_serverHostPortV,128);/* serverHostPort set by DELEGATE */
	MStr(	se_serverHost1,128); /* host of primary port */
	int	se_serverPort1;      /* primary port (std I/O by default) */
	int	se_serverPort1Fix;
	ServerPort se_SVPorts[FD_SETSIZE]; /**/
	int	se_SVPortN;
	struct {
		int	port;
		int	sock;
	} se_portsV[128]; /**/
	int	se_portsX;
	int	se_Tio[2];
	CloseOnTime se_cot;
} ServPorts;
static ServPorts *servPorts;
#define serverHostPort	servPorts->se_serverHostPort
#define serverHostPortV	servPorts->se_serverHostPortV
#define serverHost1	servPorts->se_serverHost1
/**/
#define serverPort1	servPorts->se_serverPort1
#define serverPort1Fix	servPorts->se_serverPort1Fix
#define SVPorts		servPorts->se_SVPorts
#define SVPortN		servPorts->se_SVPortN
#define portsV		servPorts->se_portsV
#define portsX		servPorts->se_portsX
#define Tio		servPorts->se_Tio
#define cot		servPorts->se_cot
void minit_ports()
{
	if( servPorts == 0 ){
		servPorts = NewStruct(ServPorts);
		SVPorts[0].sv_sock = -1;
	}
}

#define SvSock(n)	SVPorts[n].sv_sock
#define SvPort(n)	SVPorts[n].sv_port
#define SvUDP(n)	SVPorts[n].sv_udp
#define SvTCP(n)	SVPorts[n].sv_tcp
#define SvHost(n)	SVPorts[n].sv_host
#define SvHostStr(n)	((SvHost(n) && SvHost(n)[0]) ? SvHost(n) : "")
#define SvKeep(n)	SVPorts[n].sv_keep
#define SvRoute(n)	SVPorts[n].sv_vsap
#define SvRouteStr(n)	(SvRoute(n) == 0 ? "" : SvRoute(n))

void sethostnameIF(PCStr(host));
static int scanServPort0(PCStr(host),int port,int udp,int sock,PCStr(route))
{	int sx;
	int keep;
	int wasactive;
	int fix; 
	int tcp;

	if( udp == 2 ){
		udp = 0;
		tcp = 1;
	}else	tcp = 0;

	if( fix = host[0] == '-' ){
		/* -P-host:port ... use the port as is for ${PORT} */
		host = host + 1;
	}

	if( port < 0 ){
		port = -port;
		keep = 1;
	}else	keep = 0;

	for( sx = 0; sx < SVPortN; sx++ )
	{
		if( strcmp(SvHostStr(sx),host) == 0 )
		if( SvPort(sx) == port )
		if( SvUDP(sx) == udp )
		if( SvTCP(sx) == tcp )
			break;
	}
	if( sx == SVPortN ){
		if( elnumof(SVPorts) <= SVPortN ){
			return -1;
		}
		SVPortN++;
	}

	/* private-MASTER, exec on SIGHUP, from inetd */
	if( 0 <= sock )
		port = sockPort(sock);

	if( sx == 0 ){
		if( host[0] != 0 )
			sethostnameIF(host);
		if( serverPort1Fix == 0 ){
		if( 0 <= port )
			serverPort1 = port;
		}
		if( fix )
			serverPort1Fix = 1;
	}

	if( SvHost(sx) )
	{
		free((char*)SvHost(sx));
		wasactive = 1;
	}else	wasactive = 0;

	SvHost(sx) = stralloc(host);
	SvPort(sx) = port;
	SvUDP(sx) = udp;
	SvTCP(sx) = tcp;
	SvKeep(sx) = keep;
	SvRoute(sx) = stralloc(route);

	if( wasactive )
	if( 0 <= SvSock(sx) )
		close(SvSock(sx));
	SvSock(sx) = sock;
	return 0;
}

static scanListFunc scanhostport(PCStr(ports),PCStr(host),int udp,int sock,PCStr(route))
{	int port,port1,port2;

	port1 = port2 = 0;
	if( sscanf(ports,"%d-%d",&port1,&port2) == 1 )
		port2 = port1;
	for( port = port1; port <= port2; port++ )
		scanServPort0(host,port,udp,sock,route);
	return 0;
}
scanListFunc scanServPort1(PCStr(portspec))
{	int sx;
	CStr(host,128);
	CStr(portname,128);
	CStr(ports,128);
	CStr(mod,128);
	int udp;
	int sock;
	CStr(route,128);

	if( streq(portspec,"-") ){
		serverPort1 = 0;
		return 0;
	}

	portname[0] = 0;
	route[0] = 0;
	host[0] = 0;
	mod[0] = 0;
	ports[0] = 0;
	udp = 0;
	sock = -1;

	if( portspec[0] == ':' )
		portspec++;

	Xsscanf(portspec,"%[^@]@%s",AVStr(portname),AVStr(route));
	if( strchr(portname,':') )
		Xsscanf(portname,"%[^:]:%[^/]/%s",AVStr(host),AVStr(ports),AVStr(mod));
	else	Xsscanf(portname,"%[^/]/%s",AVStr(ports),AVStr(mod));

	if( mod[0] ){
		if( strcmp(mod,"udp") == 0 )
			udp = 1;
		else
		if( strcmp(mod,"tcp") == 0 )
			udp = 2;
		else	sock = atoi(mod);
	}

	if( route[0] ){
		CStr(vsap,256);
		sprintf(vsap,"%s/ACCEPT",route);
		scan_VSAP(NULL,vsap);
	}

	scan_commaListL(ports,0,scanListCall scanhostport,host,udp,sock,route);
	return 0;
}

void scanServPort(PCStr(portspecs))
{
	SVPortN = 0;
	scan_commaList(portspecs,0,scanListCall scanServPort1);
}

int printServPort(PVStr(port),PCStr(prefix),int whole)
{	int sx;
	refQStr(pp,port); /**/

	setVStrEnd(port,0);

	cpyQStr(pp,port);
	if( prefix ){
		strcpy(pp,prefix);
		pp += strlen(pp);
	}

	for( sx = 0; sx < SVPortN; sx++ ){
		if( 0 < sx ){
			setVStrPtrInc(pp,',');
			setVStrEnd(pp,0);
		}

		if( SvHostStr(sx)[0] ){
			sprintf(pp,"%s:",SvHost(sx));
			pp += strlen(pp);
		}

		if( SvKeep(sx) )
			sprintf(pp,"%d",-SvPort(sx));
		else	sprintf(pp,"%d",SvPort(sx));
		pp += strlen(pp);

		if( SvRouteStr(sx)[0] ){
			sprintf(pp,"@%s",SvRoute(sx));
			pp += strlen(pp);
		}

		if( !whole )
			break;

		if( 0 < whole )
		if( 0 <= SvSock(sx) ){
			sprintf(pp,"/%d",SvSock(sx));
			pp += strlen(pp);
		}
	}

	return SVPortN;
}

void setServUDP()
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ )
		SvUDP(sx) = 1;
}

void openServPorts()
{	int sx;
	CStr(msg,1024);
	int listen;

	for( sx = 0; sx < SVPortN; sx++ ){
		if( 0 <= SvSock(sx) )
			continue;

		if( SvHostStr(sx)[0] ){
			int fd;
			fd = nextFD();
			IsResolvable(SvHost(sx)); /* enter it to the cache */
			usedFD(fd);
		}

/* check ACTDIR/delegate/pid/PORT and kill if it exist ...
 * by trying fopen "r+" and lock exclusive
 */

		if( SvUDP(sx) )
			listen = -1;
		else
		if( SvTCP(sx) )
			listen = 5; 
		else	listen = DELEGATE_LISTEN;

		SvSock(sx) = findopen_port("delegate",
			ZVStr((char*)SvHostStr(sx),strlen(SvHostStr(sx))+1),
				SvPort(sx),listen);

		if( SvSock(sx) < 0 ){
			sprintf(msg,"cannot open server port %s:%d",
				SvHostStr(sx),SvPort(sx));
			ERRMSG("DeleGate: %s\n",msg);
			Exit(-1,"DeleGate: %s\n",msg);
		}
	}
}

void closeServPorts()
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ ){
		close(SvSock(sx));
		SvSock(sx) = -1;
		SvPort(sx) = 0;
		if( SvHost(sx) ){
			((char*)SvHost(sx))[0] = 0;
		}
	}
	SVPortN = 0;
}

void makeEntrance(){
	/*
	if( serverPort1 ){
	*/
	if( 0 < SVPortN ){
		openServPorts();
	}else{
		Socketpair(Tio); /* dummy */
		SvSock(0) = Tio[0];
		SVPortN = 1;
		sv1log("TeleportTunnel[%d]\n",SvSock(0));
	}
}

int getServPorts(int sc,int sv[])
{	int sx,sn;

	sn = 0;
	for( sx = 0; sx < sc && sx < SVPortN; sx++ ){
		sv[sn] = SvSock(sx);
		sn++;
	}
	return sn;
}
int pollServPort(int timeout,int *rsockv,int *udpv,int *optv)
{	int sx,sxa,rsx;
	int ssockv[FD_SETSIZE],readyv[FD_SETSIZE],nready;
	int sock;

	sxa = 0;
	for( sx = 0; sx < SVPortN; sx++ ){
		if( !SvKeep(sx) ){
			ssockv[sxa] = SvSock(sx);
			readyv[sxa] = 0;
			sxa++;
		}
	}
	if( optv ){
		for( sx = 0; 0 <= optv[sx]; sx++ ){
			ssockv[sxa] = optv[sx];
			readyv[sxa] = 0;
			sxa++;
		}
	}

	nready = PollIns(timeout,sxa,ssockv,readyv);
	if( nready <= 0 )
		return nready;

	rsx = 0;
	for( sx = 0; sx < sxa; sx++ ){
		if( 0 < readyv[sx] ){
			rsockv[rsx] = ssockv[sx];
			udpv[rsx] = SvUDP(sx);
			rsx++;
		}
	}
	return nready;
}

void inetdServPort()
{	int sock,port,osock,oport;

	sock = dup(0);
	setsockREUSE(sock,1);
	port = sockPort(sock);
	oport = SvPort(0);
	osock = SvSock(0);
	svlog("fromInetd/SVsock: %d/%d <= %d/%d\n",port,sock,oport,osock);
	setsid();

	if( oport != port || osock < 0 ){
		LOG_deletePortFile();
		LOG_closeall();
		closeServPorts();
		scanServPort0("",port,isUDPsock(sock),sock,"");
	}
	else	close(sock);
}

static int isNotServPort(PCStr(host),int port)
{	int sx;

	if( SVPortN == 0 ){
		/* can be cleared by with -x or in OnetimeServer or ...
		 * thus cannot determine by -PportList
		 */
		return 0;
	}
	for( sx = 0; sx < SVPortN; sx++ )
	{
		if( SvPort(sx) == port ){
			/* wildcard as 0.0.0.0 or :: must be ignored */
			if( *SvHostStr(sx) ){
				if( hostcmp_incache(SvHost(sx),host) != 0 ){
					continue;
				}
			}
			if( SvKeep(sx) )
				return 1;
			else	return 0;
		}
	}

	return 1;
}

int ServSockOf(PCStr(host),int port)
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ )
		if( SvPort(sx) == port )
			return SvSock(sx);
	return -1;
}

int activeServPort()
{	int nactive,sx;

	nactive = 0;
	for( sx = 0; sx < SVPortN; sx++ )
		if( 0 <= SvSock(sx) )
			if( !SvKeep(sx) )
				nactive++;
	return nactive;
}

int ServSock()
{
	return SvSock(0);
}

int isServSock(int sock)
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ ){
		if( SvSock(sx) == sock )
			return 1;
	}
	return 0;
}

/*
 *	close a file descriptor (parallel server's socket for accept)
 *	(1) on specified timeout
 *	(2) after fork
 *	(3) after the death of the parent
 */
void setCloseOnTimeout(int timeout)
{
	cot.time = time(0) + timeout;
	cot.ppid = getppid();
	cot.pid = getpid();
}
static int _checkCloseOnTimeout(int checktime)
{
	if( cot.time == 0 )
		return 1;

	if( getpid() == cot.pid )
	if( getppid() == cot.ppid )
	if( checktime && time(0) < cot.time )
		return 0;

	closeServPorts();
	sv1log("ClosedOnTimeout(%d): time=%d/%d ppid=%d/%d pid=%d/%d\n",
		checktime,
		time(0),cot.time,
		getppid(),cot.ppid,
		getpid(),cot.pid);

	bzero(&cot,sizeof(cot));
	return 1;
}
int (*CheckClosed)(int) = _checkCloseOnTimeout;


/*
 *
 */
int addrIsWildcard(PCStr(host));
void sethostnameIF(PCStr(host))
{
	if( addrIsWildcard(host) ){
		syslog_ERROR("[%s] is not set as interface addr.\n",host);
		return;
	}
	strcpy(serverHost1,host);

	if( serverHostPort != NULL )
if( serverHostPort != serverHostPortV )
		free((char*)serverHostPort);
	serverHostPort = stralloc(host);
}
int gethostnameIFIF(PVStr(host),int size)
{
	if( serverHost1[0] ){
		strncpy(host,serverHost1,size);
		return 0;
	}
	setVStrEnd(host,0);
	return -1;
}
void gethostnameIF(PVStr(host),int size)
{
	if( gethostnameIFIF(AVStr(host),size) == 0 )
		return;
	GetHostname(AVStr(host),size);
}
void Myhostport(PVStr(myhp),int size)
{
	gethostnameIF(AVStr(myhp),size);
	Xsprintf(TVStr(myhp),":%d",serverPort1);
}

int use_numaddress(Connection *Conn);
int CTX_myhostport(Connection *Conn,PVStr(myhost),int size)
{	const char *delegate;
	int myport;
	const char *addr;

	myport = serverPort1;
	if( delegate = serverHostPort )
		Xsscanf(delegate,"%[^:]:%d",AVStr(myhost),&myport);
	else	gethostnameIF(AVStr(myhost),size);

	if( delegate == 0 || use_numaddress(Conn) ){
		if( addr = gethostaddr(myhost) )
			strcpy(myhost,addr);
	}
	return myport;
}

int forcedIF_HX(Connection *Conn,PCStr(vhostport),PVStr(host))
{	int port;

	if( vhostport && Conn->my_vbase.u_pri == 0 ){
		port = scan_hostport(CLNT_PROTO,vhostport,AVStr(host));
		return port;
	}

	if( Conn->my_vbase.u_host ){
		strcpy(host,Conn->my_vbase.u_host);
		return Conn->my_vbase.u_port;
	}
	if( serverHostPort == serverHostPortV ){
		port = serverPort1;
		Xsscanf(serverHostPort,"%[^:]:%d",AVStr(host),&port);
		return port;
	}
	return 0;
}
int forcedIF_HPX(Connection *Conn,PCStr(vhostport),PVStr(hostport))
{
	if( vhostport && Conn->my_vbase.u_pri == 0 ){
		strcpy(hostport,vhostport);
		return 1;
	}

	if( Conn->my_vbase.u_host ){
		/*
		sprintf(hostport,"%s:%d",
			Conn->my_vbase.u_host,Conn->my_vbase.u_port);
		*/
		strcpy(hostport,Conn->my_vbase.u_hostport);
		return 1;
	}
	if( serverHostPort == serverHostPortV ){
		strcpy(hostport,serverHostPort);
		return 1;
	}
	return 0;
}

int VA_HostPortIFclnt(Connection *Conn,int clsock,PVStr(name),PVStr(addr),VAddr *Vaddr)
/*
{	CStr(addrb,32);
*/
{	CStr(addrb,64);

	if( !AddrEQ(Conn->cl_sockHOST,AddrZero) )
		goto EXIT;

	VA_gethostNAME(clsock,&Conn->cl_sockHOST);
	VA_inetNtoah(&Conn->cl_sockHOST,AVStr(addrb));

	Verbose("-- SockHost: [%s] %s:%d\n",
		addrb, Conn->cl_sockHOST.a_name,
		Conn->cl_sockHOST.a_port);

EXIT:
	if( name ) strcpy(name,Conn->cl_sockHOST.a_name);
	if( addr ) VA_inetNtoah(&Conn->cl_sockHOST,AVStr(addr));
	if( Vaddr ) *Vaddr = Conn->cl_sockHOST;
	return Conn->cl_sockHOST.a_port;
}

static int _clientIF(Connection *Conn,PVStr(hostport),xPVStr(host),int clsock,int byaddr)
{	CStr(hostb,256);
	CStr(addr,256);
	int port;

	if( host == NULL )
		setPStr(host,hostb,sizeof(hostb));

	if( serverHostPort )
	{
		port = CTX_myhostport(Conn,AVStr(host),sizeof(hostb));
	}
	else{
		port = VA_HostPortIFclnt(Conn,clsock,AVStr(host),AVStr(addr),NULL);
		if( byaddr && addr[0] != 0 )
			Xstrcpy(SVStr(host,hostb) host,addr);
	}
{
	const char *hp;
	if( hp = strchr(host,'%') ){
		/* it is unnecssary to be shown to peer (client), but
		 * it might be necessary in some case.
		 */
		syslog_ERROR("[%s] scope-id ignored\n",host);
		truncVStr(hp);
	}
}
	if( hostport != NULL )
		sprintf(hostport,"%s:%d",host,port);

	return port;
}
int ClientIF_addr(Connection *Conn,int clsock,PVStr(addr))
{
	return _clientIF(Conn,VStrNULL,AVStr(addr),clsock,1);
}
int ClientIF_name(Connection *Conn,int clsock,PVStr(name))
{
	return _clientIF(Conn,VStrNULL,AVStr(name),clsock,0);
}
int ClientIF_HPname(Connection *Conn,PVStr(hostport))
{
	return _clientIF(Conn,AVStr(hostport),VStrNULL,ClientSock,0);
}
int ClientIF_HP(Connection *Conn,PVStr(hostport))
{
	return _clientIF(Conn,AVStr(hostport),VStrNULL,ClientSock,1);
}
int ClientIF_H(Connection *Conn,PVStr(host))
{
	return _clientIF(Conn,VStrNULL,AVStr(host),ClientSock,1);
}
int ClientIF_Hname(Connection *Conn,PVStr(host))
{
	return _clientIF(Conn,VStrNULL,AVStr(host),ClientSock,0);
}

void ServerIF_name(Connection *Conn,PVStr(host))
{
	if( 0 < ToS )
		gethostNAME(ToS,AVStr(host));
	else	gethostname((char*)host,256);
}

static int isme(PCStr(myhost),int myport,PCStr(rhost),int rport)
{	int myhosti,rhosti;

	if( rport != myport )
		return 0;

	if( strcasecmp(myhost,rhost) == 0 )
		return 1;

	myhosti = gethostintMin(myhost);
	rhosti = gethostintMin(rhost);

	if( myhosti == -1 || rhosti == -1 )
		return 0; /* maybe safer (resolver seems wrong) */

	if( myhosti == rhosti )
		return 1;

	if( serverHost1[0] != 0 ) /* if interface host is limited */
		return 0;
		/* multiple entrance ports should be cared ... */

	return IsMyself(rhost);
}

int IsmyselfX(Connection *Conn,PCStr(rproto),PCStr(rhost),int rport);
static struct {
	MStr(c_proto,32);
	MStr(c_name,128);
	int c_port;
	int c_isme;
} IsmeCache;
int Ismyself(Connection *Conn,PCStr(rproto),PCStr(rhost),int rport)
{	int yes;

	if( IsmeCache.c_port == rport
	 && strcaseeq(IsmeCache.c_proto,rproto)
	 && strcaseeq(IsmeCache.c_name,rhost) ){
		goto EXIT;
	}
	yes = IsmyselfX(Conn,rproto,rhost,rport);
	strcpy(IsmeCache.c_proto,rproto);
	strcpy(IsmeCache.c_name,rhost);
	IsmeCache.c_port = rport;
	IsmeCache.c_isme = yes;
EXIT:
	return IsmeCache.c_isme;
}
int IsmyselfX(Connection *Conn,PCStr(rproto),PCStr(rhost),int rport)
{	CStr(myhost,256);
	int myport;

	/* Local path cannot be the procol between client / DeleGate ...
	 * (this was temporary patch to avoid being treated as a internal
	 *  URL at httpd.c:HttpToMyself() ...
	 */
	if( localPathProto(rproto) )
		return 0;

	if( isMYSELF(rhost) )
		return 1;

	/* 9.0.0
	 * the interface at which current connection is accepted is me.
	 * this is very likely to be true when acting as an origin server.
	 */
	if( CLIF_PORT == rport && hostcmp(CLIF_HOST,rhost) == 0 ){
		return 1;
	}

	/*
	 * "sock.dir.af-local" for AF_UNIX "/dir/sock" with port number 0xFFFF
	 *  means that port number must not be cared
	 */
	if( strtailstr(rhost,VSA_hostlocal()) ){
		myport = VA_HostPortIFclnt(Conn,ClientSock,AVStr(myhost),VStrNULL,NULL);
		if( myport == 0xFFFF ){
			return isme(myhost,0,rhost,0);
		}
	}

	/*
	 * A virtual address can be given by DELEGATE parameter and is set
	 * to serverHostPort.  The address can be one of followings:
	 *   1. (one of) physical address of myself
	 *   2. (one of) physical address of another server's host:port
	 *   3. pseudo address bound to myself
	 */
	if( serverHostPort != NULL ){
		myport = CTX_myhostport(Conn,AVStr(myhost),sizeof(myhost));
		if( isme(myhost,myport,rhost,rport) )
			return 1;
	}

	/*
	 * In physicall address matching, the server port of the
	 * delegated is one of real ports specified in -Pp1,p2,...
	 */
	if( isNotServPort(rhost,rport) )
		return 0;
	myport = VA_HostPortIFclnt(Conn,ClientSock,AVStr(myhost),VStrNULL,NULL);
	return isme(myhost,myport,rhost,rport);
}

void scan_CALLBACK(PCStr(protolist));
void scan_DELEGATE(Connection *Conn,PCStr(dhps))
{	CStr(hostport,1024);
	CStr(host,1024);
	int port;
	CStr(proto,1024);
	CStr(dst,1024);
	CStr(src,1024);
	int ni;

	if( dhps == NULL )
		return;

	host[0] = 0;
	port = 0;
	proto[0] = dst[0] = src[0] = 0;
	ni = Xsscanf(dhps,"%[^:]:%d:%[^:]:%[^:]:%s",AVStr(host),&port,AVStr(proto),AVStr(dst),AVStr(src));

	if( isMYSELF(host) && Conn != NULL )
		gethostAddr(ClientSock,AVStr(host));
	if( port == 0 )
		port = serverPort1;
	if( proto[0] )
		scan_CALLBACK(proto);

	sprintf(hostport,"%s:%d",host,port);
	/*
	dhps = stralloc(hostport);
	*/
	wordscanX(hostport,AVStr(serverHostPortV),sizeof(serverHostPortV));
	dhps = serverHostPortV;
	xmem_push((void*)&serverHostPort,sizeof(serverHostPort),"DELEGATE",NULL);
	serverHostPort = dhps;
}

void printPrimaryPort(PVStr(port))
{
	if( serverHost1[0] )
		sprintf(port,"%s:%d",serverHost1,serverPort1);
	else	sprintf(port,"%d",serverPort1);
}

int connectToMyself(PCStr(what))
{	int sock;

	if( serverHost1[0] )
		sock = client_open(what,"delegate",serverHost1,serverPort1);
	else	sock = client_open(what,"delegate","localhost",serverPort1);
	return sock;
}

int SERVER_PORT()
{
	return serverPort1;
}
void setSERVER_PORT(PCStr(host),int port,int sock)
{
	if( 0 <= sock )
		scanServPort0(host,port,isUDPsock(sock),sock,"");
	else	scanServPort0(host,port,0,-1,"");
}



static scanListFunc scanports(PCStr(hostport))
{	CStr(host,256);
	int port1,port2,port;
	int sock;
	int pi;
	const char *dp;
	CStr(mod,32);
	int nlisten;

	host[0] = 0;
	port1 = 0;
	port2 = 0;

	mod[0] = 0;
	if( dp = strchr(hostport,'/') )
		wordScan(dp+1,mod);
	if( dp = strchr(hostport,':') )
		dp = strchr(dp,'.');
	else	dp = strchr(hostport,'.');
	if( dp != NULL )
		wordScan(dp+1,mod);
	nlisten = DELEGATE_LISTEN;
	if( streq(mod,"udp") )
		nlisten = -1;

	if( strchr(hostport,':') )
		Xsscanf(hostport,"%[^:]:%d-%d",AVStr(host),&port1,&port2);
	else	sscanf(hostport,"%d-%d",&port1,&port2);
	if( port2 == 0 )
		port2 = port1;

	for( port = port1; port <= port2; port++ ){
		sock = findopen_port("reservePORT",AVStr(host),port,nlisten);
		if( sock < 0 ){
			fprintf(stderr,"CANNOT BIND PORT %d\r\n",port);
			exit(1);
		}
		if( elnumof(portsV) <= portsX ){
			return -1;
		}
		portsV[portsX].port = port;
		portsV[portsX].sock = sock;
		portsX++;
	}
	return 0;
}
void scan_PORT(Connection *Conn,PCStr(ports))
{
	scan_commaList(ports,0,scanListCall scanports);
}
int getReservedPorts(int pv[],int sv[])
{	int sx;

	for( sx = 0; sx < portsX; sx++ ){
		pv[sx] = portsV[sx].port;
		sv[sx] = portsV[sx].sock;
	}
	return sx;
}
void sendReservedPorts()
{	int sx,si;

	si = 0;
	for( sx = 0; sx < portsX; sx++ ){
		if( portsV[sx].port ){
			setrsvdsock(si++,portsV[sx].sock);
		}
	}
}
int ReservedPortSock(PCStr(host),int port)
{	int sx;

	for( sx = 0; sx < portsX; sx++ )
		if( portsV[sx].port == port )
			return portsV[sx].sock;
	return -1;
}
int closeNonReservedPortSock(int sock)
{	int sx;

	for( sx = 0; sx < portsX; sx++ )
		if( portsV[sx].sock == sock )
			return 0;
	close(sock);
	return 0;
}
void closeReservedPorts()
{	int sx;

	for( sx = 0; sx < portsX; sx++ ){
		if( portsV[sx].port ){
			close(portsV[sx].sock);
			portsV[sx].port = 0;
			portsV[sx].sock = 0;
		}
	}
	portsX = 0;
}
