/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	setutimes.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970724	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "vsocket.h" /* <sys/time.h> for timeval of utimes() */

int set_utimes(PCStr(path),int atime,int mtime)
{	struct stat st;
	struct timeval tv[2]; /**/

	if( stat(path,&st) != 0 )
		return -1;

	if( atime != 0 && atime != -1 )
		tv[0].tv_sec = atime;
	else	tv[0].tv_sec = st.st_atime;
	tv[0].tv_usec = 0;

	if( mtime != 0 && mtime != -1 )
		tv[1].tv_sec = mtime;
	else	tv[1].tv_sec = st.st_mtime;
	tv[1].tv_usec = 0;

	return utimes(path,tv);
}

