/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	commands.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	981120	extracted from delegated.c (5.7.6)
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>

/* for P_LOGFILE */
#include <stdlib.h>
#include "ystring.h"
#include "param.h"
#include "proc.h"
#include "file.h"
#include "log.h"
#include "dglib.h"

void setIsFunc(DGC*Conn,int fc);
int DELEGATE_scan_args(int ac,const char *av[]);
void DELEGATE_config(DGC*Conn,int csock);
void DELEGATE_ScanGlobal(DGC*Conn,PCStr(proto));
FILE *openLogFile(int now);
int ServSock();

typedef int mainFunc(int ac,const char *av[]);
typedef int mainFunc2(int ac,const char *av[],DGC*Conn);
typedef int mainFunc3(int ac,const char *av[],DGC*Conn,int sock,int port);

mainFunc help_main;
mainFunc dump_main;
mainFunc ccx_main;
mainFunc sched_main;
mainFunc resolvy_main;
mainFunc2 dget_main;
mainFunc urlfind_main;
mainFunc thruwayd_main;
mainFunc system_main;
mainFunc htget_main;
mainFunc2 connect_main;
mainFunc icp_client;
mainFunc lpr_main;
mainFunc lpq_main;
mainFunc ls_main;
int md5_main(int,char*[]);
mainFunc ENMIME_main;
mainFunc DEMIME_main;
mainFunc2 sendmail_main;
mainFunc alias_main;
mainFunc cafe_main;
mainFunc shio_main;
mainFunc tar_main;
mainFunc sed_main;
mainFunc uudec_main;
mainFunc dping_main;
mainFunc2 authedit_main;
mainFunc sleep_main;
mainFunc3 sox_main;
mainFunc crc_main;
mainFunc crc8_main;
mainFunc credhy_main;
mainFunc pubkey_main;
mainFunc verify_main;
mainFunc any2fdif_main;
mainFunc2 cgi_delegate;
mainFunc2 poprelay_main;
mainFunc service_cuseeme;
mainFunc service_icp;
mainFunc service_dns;
mainFunc sslway_main;
mainFunc tsp_main;

typedef struct {
	int	 f_type;
	int	 f_withAdmin;
	int	 f_withLog;
  const	char	*f_proto;
  const	char	*f_name;
       mainFunc *f_func;
  const	char	*f_desc;
} SubFunc;

#define MS	0	/* standalone function */
#define MN	1	/* function which uses network */
#define MV	2	/* server */

static SubFunc subfuncs[] = {
{MS,0,0,"",	"help",	   help_main,	"show the list of functions"},
{MV,0,0,"",	"cgi", (mainFunc*)cgi_delegate,"DeleGate as a cgi program"},
{MS,0,0,"",	"ccx",	   ccx_main,	"character code converter"},
{MS,0,0,"",	"dump",	   dump_main,	"dump configuration"},
{MS,0,0,"",	"sched",   sched_main,	"scheduler compatible with `crond'"},
{MS,0,0,"",	"star",    tar_main,	"simple tar"},
{MS,0,0,"",	"ssed",    sed_main,	"simple sed"},
{MS,0,0,"",	"deuu",    uudec_main,	"simple uudecode"},
{MS,0,0,"",	"dping",   dping_main,  "application level ping"},
{MN,0,0,"",	"dget",	   (mainFunc*)dget_main,	"download by URL"},
{MN,0,0,"",	"poprelay",(mainFunc*)poprelay_main,"load from POP and relay to"},
{MS,0,0,"",	"urlfind", urlfind_main,"network wide find"},
{MS,0,0,"",	"thruwayd",thruwayd_main,"a circuit level proxy"},
{MN,0,0,"tcprelay","connect",(mainFunc*)connect_main,"connect to remote port"},
{MN,0,0,"",	"resolvy", resolvy_main,"host name resolver"},
{MN,0,0,"icp",	"icp",	   icp_client,	"ICP client"},
{MN,0,0,"http",	"htget",   htget_main,	"get by URL into HTML/HTTP format."},
{MS,0,0,"",	"system",  system_main,	"system commands"},
{MS,0,1,"",	"findu",   cafe_main,	"find + du"},
{MS,0,1,"",	"expire",  cafe_main,	"expire (alias of -Ffindu)"},
{MS,0,0,"",	"shio",    shio_main,	"shell I/O"},
{MS,0,0,"",	"lpr",	   lpr_main,	"send to LPR"},
{MS,0,0,"",	"lpq",	   lpq_main,	"show status of LPR"},
{MS,0,0,"",	"ls",	   ls_main,	"unix like ls"},
{MS,0,0,"",	"md5",     (mainFunc*)md5_main,	"MD5 digest generator"},
{MS,0,0,"",	"enMime",  ENMIME_main,	"mime encoder"},
{MS,0,0,"",	"deMime",  DEMIME_main,	"mime decoder"},
{MN,0,0,"",	"sendmail",(mainFunc*)sendmail_main,"SMTP poster"},
{MS,0,0,"",	"alias",   alias_main,	"expand aliases of mail address"},
{MS,0,0,"",	"auth",    (mainFunc*)authedit_main,"edit auth. for AUTHORIZER"},
{MS,0,0,"",	"sleep",   sleep_main,  "sleep"},
{MV,0,0,"",	"sockmux", (mainFunc*)sox_main,	"Socket Multiplexer"},
{MS,0,0,"",	"crc",     crc_main,	"CRC32 (32bits Cyclic Redundancy Code)"},
{MS,0,0,"",	"crc8",    crc8_main,   "CRC8 for debugging"},
{MS,0,0,"",	"credhy",  credhy_main,	"Credhy encryption/decription"},
{MS,0,0,"",	"pubkey",  pubkey_main,	"RSA Public Key of the Author"},
{MS,0,0,"",	"verify",  verify_main,	"Verify with the Key of the Author"},
{MS,0,0,"",	"any2fdif",any2fdif_main,"FDIF generator"},
{MS,0,0,"",	"sslway",  sslway_main, "SSLway"},
{MS,0,0,"",	"tsp",     tsp_main,	"TIme Stamp Protocol Client"},
0
};
extern const char *DELEGATE_pubkey;
int pubkey_main(int ac,const char *av[])
{
	fprintf(stdout,"%s",DELEGATE_pubkey);
	return 0;
}
int verify_main(int ac,const char *av[])
{	CStr(command,1024);
	CStr(s64,1024);
	CStr(kfile,1024);
	CStr(buf,1024);
	int len;
	FILE *in,*fp,*pp;

	in = 0;
	if( 2 <= ac ){
		in = fopen(av[1],"r");
		if( in == NULL ){
			fprintf(stderr,"Cannot open: %s\n",av[1]);
			return -1;
		}
	}
	if( in == NULL )
		in = stdin;

	sprintf(kfile,"${ACTDIR}/pubkey.pem");
	DELEGATE_substfile(AVStr(kfile),"",VStrNULL,VStrNULL,VStrNULL);
	if( fp = fopen(kfile,"w") ){
		fputs(DELEGATE_pubkey,fp);
		fclose(fp);
	}
	fread(s64,1,sizeof(s64),in);
	len = str_from64(s64,strlen(s64),AVStr(buf),sizeof(buf));
	sprintf(command,"openssl rsautl -verify -pubin -inkey %s",kfile);
	if( pp = popen(command,"w") ){
		fwrite(buf,1,len,pp);
		pclose(pp);
	}
	return 0;
}
int help_main(int ac,const char *av[])
{	int fi;
	const char *fname;

	printf("FUNCTIONS:\r\n");
	for( fi = 0; fname = subfuncs[fi].f_name; fi++ )
		printf("-F%-10s %s\r\n",fname,subfuncs[fi].f_desc);
	return 0;
}
static int replace_log(int ac,const char **avp[],int mac,const char *nav[],PVStr(nab))
{	FILE *lfp;
	int ai,nac;
	const char **av;

	if( DELEGATE_getEnv(P_LOGFILE) == 0 )
		return ac;

	if( (lfp = openLogFile(time(NULL))) == NULL )
		return ac;

	av = *avp;
	nac = 0;
	for( ai = 0; ai < ac; ai++ ){
		if( mac-3 <= nac ){
			break;
		}
		nav[nac++] = av[ai];
	}
	/* LOGFILE parameter from CRON-expire will be ignored with
	 * prefix "-ign" like -ign LOGFILE=path.
	 */

	nav[nac++] = "-log";
	sprintf(nab,"-%d",fileno(lfp));
	nav[nac++] = nab;
	nav[nac] = NULL;
	*avp = nav;
	return nac;
}
typedef int (*mainFUNCP)(int ac,const char *av[],...);
int DELEGATE_subfunc(DGC*Conn,int ac,const char *av[],PCStr(func),int Fopt,int type)
{	int fi;
	const char *fname;
	const char *sp;
	mainFUNCP ifunc;
	int ctype;
	const char *nav[64]; /**/
	CStr(nab,1024);
	const char **avx;
	int acx;

	for( fi = 0; fname = subfuncs[fi].f_name; fi++ ){
		if( !strcaseeq(func,fname) )
			continue;

		ctype = subfuncs[fi].f_type;
		if( ctype == MS ){
			setIsFunc(Conn,1);
			LOG_type |= L_ISFUNC;
		}

		if( ctype == MV ){
			if( type != MV )
				return 1;
		}else
		if( ctype == MN ){
			if( type != MN )
				return 1;
			if( subfuncs[fi].f_proto[0] )
			DELEGATE_ScanGlobal(Conn,subfuncs[fi].f_proto);
		}

		ifunc = (mainFUNCP)subfuncs[fi].f_func;

		if( subfuncs[fi].f_withLog ){
			/* special case of "expire" */
			ac = replace_log(ac,&av,64,nav,AVStr(nab));
		}else
		if( ctype == MV ){
			/* already did arg_scan() */
			/* don't need config for any client */
		}else{
			ac = DELEGATE_scan_args(ac,av);
			DELEGATE_config(Conn,-1);
		}

		if( subfuncs[fi].f_withAdmin )
		if( subfuncs[fi].f_proto[0] )
			checkADMIN(Conn,subfuncs[fi].f_proto);

		if( Fopt ){
			int ai;

			acx = ac - Fopt;
			avx = &av[Fopt];
			for( ai = 0; ai < acx; ai++ ){
				if( strcmp(avx[ai],"--") == 0 ){
					acx = ai;
					break;
				}
			}
		}else{
			acx = ac;
			avx = av;
		}

		if( getenv("DELEGATE_DEBUG") ){
			int ai;
			for(ai=0;ai<acx;ai++)
				fprintf(stderr,"##[%d] %s\n",ai,avx[ai]);
		}

		(*ifunc)(acx,avx,Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( Fopt ){
		printf("DeleGate: unknown function -F\"%s\"\r\n",func);
		help_main(ac,av);
		Finish(-1);
	}
	return 0;
}
int htget_main(int ac,const char *av[])
{
	if( ac < 2 ){
		fprintf(stderr,"Usage: %s URL\r\n",av[0]);
		return -1;
	}
	URLget(av[1],1,stdout);
	return 0;
}
int system_main(int ac,const char *av[])
{	const char *nav[256]; /**/
	CStr(nab,0x10000);
	int nac,ai;

	if( File_is(av[1]) /* should search in PATH ... */ ){
		Execvp("system",av[1],&av[1]);
	}else{
		nac = decomp_args(nav,256,av[1],AVStr(nab));
		for( ai = 2; ai < ac; ai++ ){
			if( elnumof(nav)-1 <= nac)
				break;
			nav[nac++] = av[ai];
		}
		nav[nac] = 0;
		Execvp("system",nav[0],nav);
	}
	return 0;
}
int sleep_main(int ac,const char *av[])
{
	if( 1 < ac ){
		sleep(atoi(av[1]));
	}
	return 0;
}
