/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	conf.c (configuration variables)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	created
//////////////////////////////////////////////////////////////////////#*/

#include "delegate.h"
#include "param.h"
#include "file.h"

const char *MYSELF                 = "-.-";
const char *DELEGATE_CONFIG        = "delegated.cf:/usr/etc/delegated.cf";
const char *DELEGATE_ADMIN_DFLT    = ADMIN;
const char *DELEGATE_ADMIN         = "";
const char *DELEGATE_ADMINPASS     = ADMINPASS;
const char *DELEGATE_OWNER         = "nobody";
const char *DELEGATE_G_PERMIT      = "*";
const char *DELEGATE_S_PERMIT      = "!*,.";
const char *DELEGATE_TELNET_PERMIT = "!*,telnet/{23,992}";
const char *DELEGATE_SOCKS_PERMIT  = "!*,socks,tcprelay";
const char *DELEGATE_HTTP_PERMIT   = "!*,http,https/{80,443},gopher,ftp,wais";
/* V8.0.0 limited default RELIABLE(.localnet) */
const char *DELEGATE_LOCALNET      = "localhost,./.,-/.,.o/."; /* .localnet */
const char *DELEGATE_RELAY         = "delegate,vhost,nojava:*:*:.localnet;proxy";
const char *DELEGATE_RELIABLE      = ".localnet";

char	 SERV_HTTP[]         = "-.-";

const char *NOTIFY_PLATFORM        = "*.delegate.org";
const char *DELEGATE_LOGCENTER     = "www.delegate.org:8000";
const char *DELEGATE_DGPATH        = "+:.:${HOME}/delegate:${EXECDIR}:${ETCDIR}";

const char *DELEGATE_DGROOT        = "";
const char *DELEGATE_CONF          = "${EXECDIR}/${EXECNAME}.conf";
const char *DELEGATE_VARDIR        = "${DGROOT?&:/var/spool/delegate}";
const char *DELEGATE_LIBDIR        = "${VARDIR}/lib";
const char *DELEGATE_LIBPATH       = ".;${STARTDIR};${LIBDIR};${EXECDIR};${ETCDIR}";
const char *DELEGATE_DATAPATH      = ".;${DGROOT};${STARTDIR};${EXECDIR}";
const char *DELEGATE_SUBINPATH     = ".;${DGROOT}/subin;${STARTDIR};${EXECDIR}";
const char *DELEGATE_WORKDIR       = "${VARDIR}/work/${PORT}";
const char *DELEGATE_LOGDIR        = "${VARDIR}/log";
const char *DELEGATE_ETCDIR        = "${VARDIR}/etc";
const char *DELEGATE_ADMDIR        = "${VARDIR}/adm";
const char *DELEGATE_HOSTID        = "${ETCDIR}/hosts/serno";
const char *DELEGATE_SMTPGATE      = "${ETCDIR}/smtpgate";
const char *DELEGATE_MTAB          = "${ETCDIR}/conf/${PORT}/mtab";
const char *DELEGATE_NEWSLIB       = "${ETCDIR}/news";
const char *DELEGATE_DBFILE        = "";
const char *DELEGATE_UASFILE       = "${LOGDIR}/uas/${UA}";
const char *DELEGATE_LOGFILE       = "${LOGDIR}/${PORT}";
const char *DELEGATE_ERRORLOG      = "${LOGDIR}/errors.log";
const char *DELEGATE_TRACELOG      = "${LOGDIR}/ptrace.log";
const char *DELEGATE_EXPIRELOG     = "${LOGDIR}/expire.log";
const char *DELEGATE_ABORTLOG      = "${LOGDIR}/abort/${PORT}";
const char *DELEGATE_ACTDIR        = "${DGROOT?&/act:/tmp/delegate}";
const char *DELEGATE_TMPDIR        = "${DGROOT?&/tmp:/tmp/delegate}";
const char *DELEGATE_PIDFILE       = "${ACTDIR}/pid/${PORT}";
const char *DELEGATE_SOCKETS       = "${ACTDIR}/sockets";
const char *DELEGATE_STATFILE      = "";
const char *DELEGATE_PARAMFILE     = "${ETCDIR}/params/${PORT}";
const char *DELEGATE_PROTOLOG      = "${LOGDIR}/${PORT}.${PROTO}";
const char *DELEGATE_CACHEDIR      = "${VARDIR}/cache";
const char *DELEGATE_CACHEFILE     = "$[server:%P/%L/%p]";
int   DELEGATE_CACHE_CONTROL = 0;
const char *GOPHER_CACHE_ITEM      = "04569gI";
int   GOPHER_EXPIRE          = 60*60;	/* 1 hour */
int   HTTP_EXPIRE            = 60*60;	/* 1 hour */
int   FTP_EXPIRE             = 1*24*60*60;	/* 1 day */
int   FTP_ACCEPT_TIMEOUT     = 30; /* data connection timeout: 1 minute */
int   DELEGATE_syncro        = 0; /* syncronous mode (only one client
                                          at a time, for debug) */
const char *DELEGATE_IMAGEDIR      = 0;

int   DELEGATE_LISTEN        = 20;
int   MAX_DELEGATE           = 64;
int   BREAK_STICKY           = 0;

int   STANDBY_MAX            = 16;
int   STANDBY_TIMEOUT        = 30;
int   FDSET_MAX              = 64;

int   HELLO_TIMEOUT          = 30; /* HELLO negotiation with the MASTER */
int   LOGIN_TIMEOUT          = 60; /* Proxy telnet/ftp */
int   SERVER_TIMEOUT         = 0;
int   SERVER_RESTART         = 0;
int   VSAP_TIMEOUT           = 0;

int   BORN_SPECIALIST;

int   MASTER_ROUND_ROBIN     = 0;
double IDENT_TIMEOUT         = 1;
const char *HTTP_AUTHBASE          = "/delegate-auth";

/*
 *	CACHE FILE CONTROLE
 */
int CACHE_RDRETRY_INTERVAL = 10; /* in seconds */
int CACHE_WRRETRY_INTERVAL = 10; /* in seconds */

void disable_cache()
{
	DELEGATE_CACHE_CONTROL = -1;
}
void enable_cache()
{
	DELEGATE_CACHE_CONTROL = 0;
}
int without_cache(){
	return DELEGATE_CACHE_CONTROL < 0;
}

extern int CACHE_READONLY;
void scan_CACHE(Connection *Conn,PCStr(spec))
{
	if( streq(spec,"do") )
		enable_cache();
	else
	if( streq(spec,"no") )
		disable_cache();
	else
	if( streq(spec,"ro") )
		CACHE_READONLY = 1;
}

void scan_CACHEDIR(PCStr(dirs))
{
	if( dirs )
		DELEGATE_CACHEDIR = (char*)dirs;
}
void scan_CACHEFILE(PCStr(file))
{
	DELEGATE_CACHEFILE = (char*)file;
}

void strsubstDirEnv(PVStr(dir),PCStr(dgroot),PCStr(vardir))
{	const char *pp;
	const char *dp;
	const char *subst;
	const char *var;
	CStr(pat,1024);
	CStr(word1,1024);
	CStr(word2,1024);

	strsubst(AVStr(dir),"${VARDIR}",vardir);
	strsubst(AVStr(dir),"${DGROOT}",dgroot);

	subst = "${DGROOT?";
	if( pp = strstr(dir,subst) ){
		var = dgroot;
		word1[0] = word2[0] = 0;
		Xsscanf(pp+strlen(subst),"%[^:]:%[^}]",AVStr(word1),AVStr(word2));
		strcpy(pat,pp);
		if( dp = strchr(pat,'}') )
			((char*)dp)[1] = 0;
		if( var && *var )
			strsubst(AVStr(dir),pat,word1);
		else	strsubst(AVStr(dir),pat,word2);
		strsubst(AVStr(dir),"&",var);
	}
}

const char *cachefmt()
{
	static struct { defQStr(fmt); } fmt;
	if( fmt.fmt==NULL ) setQStr(fmt.fmt,(char*)StructAlloc(1024),1024);
	sprintf(fmt.fmt,"%s/%s",cachedir(),DELEGATE_CACHEFILE);
	return fmt.fmt;
}
void set_DG_EXPIRE(Connection *Conn,int expi)
{
	add_DGheader(Conn,D_EXPIRE,"%ds",expi);
}
void scan_EXPIRE(Connection *Conn,PCStr(expire))
{	CStr(period,256);
	CStr(triple,1024);
	CStr(cmap,1024);

	if( strchr(expire,':') ){
		period[0] = triple[0] = 0 ;
		Xsscanf(expire,"%[^:]:%s",AVStr(period),AVStr(triple));
		sprintf(cmap,"%s:expire:%s",period,triple);
	}else	sprintf(cmap,"%s:expire:*:*:*",expire);
	scan_CMAP(Conn,cmap);
}
int find_EXPIRE(Connection *Conn,int dflt_ev)
{	CStr(expire,256);
	int ev;

	if( D_EXPIRE[0] )
		ev = cache_expire(D_EXPIRE,dflt_ev);
	else
	if( 0 <= find_CMAP(Conn,"expire",AVStr(expire)) )
		ev = cache_expire(expire,dflt_ev);
	else	ev = dflt_ev;
	return ev;
}
int http_EXPIRE(Connection *Conn,PCStr(url))
{
	return find_EXPIRE(Conn,HTTP_EXPIRE);
}
int gopher_EXPIRE(Connection *Conn,PCStr(url))
{ 
	return find_EXPIRE(Conn,GOPHER_EXPIRE);
}
int ftp_EXPIRE(Connection *Conn)
{
	return find_EXPIRE(Conn,FTP_EXPIRE);
}

const char *isSetProxyOfClient(Connection *Conn,PVStr(cl_proto));
const char *baseURL(Connection *Conn)
{	const char *cl_proxy;
	CStr(mhp,256);
	CStr(cl_proto,64);
	MrefQStr(self,Conn->dg_iconbase); /**/

	if( Conn->cl_baseurl[0] )
		return Conn->cl_baseurl;

	if( self[0] == 0 ){
		if( cl_proxy = isSetProxyOfClient(Conn,AVStr(cl_proto)) ){
			if( cl_proto[0] )
				sprintf(self,"%s://%s",cl_proto,cl_proxy);
			else	sprintf(self,"//%s",cl_proxy);
		}else{
			HTTP_ClientIF_HP(Conn,AVStr(mhp));
			sprintf(self,"%s://%s",CLNT_PROTO,mhp);
		}
	}
	return self;
}

const char *MY_HOSTPORT()
{
	return MYSELF;
}
int isMYSELF(PCStr(host))
{
	if( streq(host,MYSELF) )
		return 1;
	if( streq(host,"-") )
		return 1;
	return 0;
}

int never_cache(Connection *Conn)
{
	return strchr(DELEGATE_FLAGS,'C') != 0;
}
int remote_access(Connection *Conn)
{
	return strchr(DELEGATE_FLAGS,'R') != 0;
}
int use_numaddress(Connection *Conn)
{
	return strchr(DELEGATE_FLAGS,'N') != 0;
}
int reserve_url(Connection *Conn)
{
	if( strchr(DELEGATE_FLAGS,'=') || strchr(DELEGATE_FLAGS,'T') )
		return 1;
	else	return 0;
}

/*
 *	BUILT-IN FILES
 */
const char *getIcon(PCStr(name),int *size)
{	int date;

	return get_builtin_data(name,size,&date);
}

const char *getMssg(PCStr(name),int *size)
{
	return getIcon(name,size);
}
void scan_builtin_data(PCStr(name),int (*func)(const void*,...),PCStr(arg1),PCStr(arg2));
void scanIcons(PCStr(name),int (*func)(const void*,...),PCStr(arg1),PCStr(arg2))
{
	scan_builtin_data(name,func,arg1,arg2);
}

void fcloseLinger(FILE *fp)
{
	fflush(fp);
	set_linger(fileno(fp),DELEGATE_LINGER);
	fcloseTIMEOUT(fp);
	set_linger(fileno(fp),0);
}

int	 IamPrivateMASTER       = 0;
int	 MASTERisPrivate        = 0 ;
int	 myPrivateMASTER        = 0 ;


#define WIN_PGROOT	"/Program Files"
#define WIN_DGROOT	"/Program Files/DeleGate"

#define DFLT_OWNER	"nobody"
#define DGROOT_GLOB	"/var/spool"
#define DGROOT_DFLT	"/tmp"
#define DGROOT_NAME	"delegate"

int tryDGROOT(int *created,int uid,int gid,PCStr(updir),PCStr(fmt),PCStr(a),PCStr(b))
{	CStr(dir,1024);
	const char *env;
	int isdir,rwx;

	*created = 0;
	strcpy(dir,updir);
	if( *dir != 0 && strtailchr(dir) != '/' )
		strcat(dir,"/");
	Xsprintf(TVStr(dir),fmt,a,b);
	setOWNER(dir,uid,gid); /* this must be done beofre mkdirRX() */

	substEXECDIR(dir,AVStr(dir),sizeof(dir));

	if( isdir = fileIsdir(dir) ){
		rwx = access_RWX(dir);
		if( rwx != 0 && getuid() == 0 && uid != 0 ){
			seteuid(uid);
			rwx = access_RWX(dir);
			seteuid(0);
		}
		if( rwx != 0 ){
fprintf(stderr,"-delegate[%d]- insufficient access right: DGROOT=%s\n",
getpid(),dir);
			isdir = 0;
		}
	}else
	if( File_is(dir) ){
		isdir = 0;
	}else
	if( isdir = (mkdirRX(dir) == 0) ){
		*created = 1;
	}
	if( isdir ){
		CStr(cwd,1024);

		if( DELEGATE_DGROOT == 0 || strcmp(DELEGATE_DGROOT,dir) != 0 )
			DELEGATE_DGROOT = StrAlloc(dir);

		if( DELEGATE_DGROOT[0] == '/'
		 && getcwd(cwd,sizeof(cwd)) != NULL
		 && cwd[1] == ':' && cwd[2] == '\\' ){
			Xstrcpy(DVStr(cwd,2),DELEGATE_DGROOT);
			DELEGATE_DGROOT = StrAlloc(cwd);
		}

		if( env = DELEGATE_getEnv(P_DGROOT) )
		if( strcmp(env,dir) != 0 )
			DELEGATE_pushEnv(P_DGROOT,dir);
		if( File_uid(dir) != uid )
			setOWNER("",-1,-1);
		return 1;
	}
	return 0;
}

#include <sys/types.h>
#include <sys/stat.h>
static int DGROOT_done;
int setDGROOT(){
	const char *umasks;
	const char *dgroot;
	const char *owner;
	const char *env;
	int umaski;
	CStr(user,256);
	CStr(home,1024);
	CStr(shell,1024);
	int issu,withshell,uid,gid;
	int pid;
	int created = 0;

	pid = getpid();
	if( DGROOT_done == pid )
	if( *DELEGATE_DGROOT != 0 )
		return 0;
	DGROOT_done = pid;

	if( umasks = DELEGATE_getEnv(P_UMASK) ){
		umaski = -1;
		sscanf(umasks,"%o",&umaski);
		if( umaski != -1 ){
			umask(umaski);
		}
		/* can be umasks for directory, file, ... respectively */
	}

	if( dgroot = DELEGATE_getEnv(P_DGROOT)  ){
		DELEGATE_DGROOT = StrAlloc(dgroot);
		if( *DELEGATE_DGROOT == 0 ){
			/* compatible with DeleGate/5.X and former */
			return 0;
		}
	}

	if( getuid() == 0 ){
		if( (owner = DELEGATE_getEnv(P_OWNER)) == 0 )
			owner = DFLT_OWNER;
		if( scan_guid(owner,&uid,&gid) == 0 ){
			getUsername(uid,AVStr(user));
		}else{
			strcpy(user,DFLT_OWNER);
			uid = -1;
			gid = -1;
		}
	}else{
		uid = getuid();
		gid = getgid();
		getUsername(uid,AVStr(user));
	}

	/*
	 * if DGROOT is defined explicitly, use it.
	 */
	dgroot = DELEGATE_DGROOT;
	if( dgroot != NULL && *dgroot != 0 ){
		if( tryDGROOT(&created,uid,gid,"","%s",dgroot,NULL) )
			return created;
fprintf(stderr,"-delegate[%d]- bad DGROOT=%s\n",getpid(),dgroot);
	}

	/*
	 * on Windows: X:\Program Files\DeleGate
	 */
	if( fileIsdir(WIN_PGROOT) ){
		CStr(cwd,1024);

		if( WIN_DGROOT[0] == '/'
		&& getcwd(cwd,sizeof(cwd)) != NULL
		&& cwd[1] == ':' && cwd[2] == '\\' ){
			Xstrcpy(DVStr(cwd,2),WIN_DGROOT);
			DELEGATE_DGROOT = StrAlloc(cwd);
		}else
		DELEGATE_DGROOT = StrAlloc(WIN_DGROOT);
		return created;
	}

	/*
	 * on Unix: $HOME/delegate
	 *          /var/spool/delegate/$OWNER
	 *          /tmp/delegate/$OWNER
	 */
	issu = (uid == 0 || gid == 0);
	withshell = getSHELL(uid,AVStr(shell)) && *shell != 0 && fileIsflat(shell);
	if( !issu && withshell ){
		if( uid == getuid() && (env = DELEGATE_getEnv("HOME")) )
			strcpy(home,env);
		else	getHOME(uid,AVStr(home));
		if( strcmp(home,"/") != 0 && fileIsdir(home) )
		if( tryDGROOT(&created,uid,gid,home,"%s",DGROOT_NAME,NULL) )
			return created;
	}

	if( tryDGROOT(&created,uid,gid,DGROOT_GLOB,"%s-%s",DGROOT_NAME,user) )
		return created;

	if( tryDGROOT(&created,uid,gid,DGROOT_DFLT,"%s-%s",DGROOT_NAME,user) )
		return created;

	return 0;
}


static const char **PATHv[4]; /**/
#define X_LIB	0
#define X_DATA	1
#define X_COM	2
#define X_SUCOM	3

static char *getenvPATH(PVStr(path),int psiz)
{	const char *env;

	setVStrEnd(path,0);
	if( env = getenv("PATH") ){
		linescanX(env,AVStr(path),psiz);
	}
	return (char*)path;
}

static void initPATH(int li){
	const char *paths;
	CStr(path,2048);

	if( PATHv[li] == 0 ){
		switch( li ){
		case X_LIB:  paths = DELEGATE_LIBPATH; break;
		case X_DATA: paths = DELEGATE_DATAPATH; break;
		case X_COM:  paths = getenvPATH(AVStr(path),sizeof(path)); break;
		case X_SUCOM: paths = DELEGATE_SUBINPATH; break;
		}
		if( paths != path )
			strcpy(path,paths);
		DELEGATE_substfile(AVStr(path),"",VStrNULL,VStrNULL,VStrNULL);
		PATHv[li] = vect_PATH(path);
	}
}

static FILE* fopenLIBDATA(int li,PCStr(file),PCStr(mode),PVStr(xpath))
{
	initPATH(li);
	return fopen_PATH(PATHv[li],file,mode,AVStr(xpath));
}
FILE* fopenLIB(PCStr(file),PCStr(mode),PVStr(xpath))
{
	return fopenLIBDATA(X_LIB,file,mode,AVStr(xpath));
}
FILE* fopenDATA(PCStr(file),PCStr(mode),PVStr(xpath))
{
	return fopenLIBDATA(X_DATA,file,mode,AVStr(xpath));
}

static int fullpathLIBDATA(int li,PCStr(path),PCStr(mode),PVStr(xpath))
{	FILE *fp;

	initPATH(li);
	if( fp = fopen_PATH(PATHv[li],path,mode,AVStr(xpath)) ){
		fclose(fp);
		return 1;
	}
	return 0;
}
int fullpathLIB(PCStr(path),PCStr(mode),PVStr(xpath))
{
	return fullpathLIBDATA(X_LIB,path,mode,AVStr(xpath));
}
int fullpathDATA(PCStr(path),PCStr(mode),PVStr(xpath))
{
	return fullpathLIBDATA(X_DATA,path,mode,AVStr(xpath));
}
int fullpathCOM(PCStr(path),PCStr(mode),PVStr(xpath))
{
	return fullpathLIBDATA(X_COM,path,mode,AVStr(xpath));
}
int fullpathSUCOM(PCStr(path),PCStr(mode),PVStr(xpath))
{
	return fullpathLIBDATA(X_SUCOM,path,mode,AVStr(xpath));
}

int CACHE_TAKEOVER = 5;
int ERROR_RESTART;
