/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	domain.c (DNS server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960528	created
//////////////////////////////////////////////////////////////////////#*/
#include "vsocket.h"
#include "delegate.h"
#include "proc.h"
#include <errno.h>

extern int CHILD_SERNO_MULTI;
extern int CHILD_SERNO;
static int PARASERV = 2;

extern int (*RES_DNSSERVER)(int,int);
extern int (*RES_DNSSEARCH)(PVStr(r),const char*,int,const char*,int);

extern int DELEGATE_LastModified;
extern int errorECONNRESET;
#ifndef ECONNRESET
#define ECONNRESET -1
#endif

void udp_relay(Connection *Conn,int clsock);
void RES_nsloopcheck(int mysock);
int service_domain1(Connection *Conn,int sock);
void dns_init();

static void dom1(Connection *Conn,int clsock,int svsock,int ac,char *av[],PCStr(arg))
{
	DELEGATE_LastModified = atoi(arg);
	RES_nsloopcheck(svsock);
	dns_init();
	service_domain1(Conn,svsock);
}
int service_domain(Connection *Conn,int sock,int port)
{
	if( isMYSELF(DST_HOST) && RES_DNSSEARCH ){
		int si;

		RES_nsloopcheck(sock);
		dns_init();

		if( INHERENT_fork() ){
			for( si = 1; si < PARASERV; si++ ){
				if( Fork("DNS") == 0 )
					break;
				CHILD_SERNO++;
			}
		}else{
			CStr(arg,32);
			sprintf(arg,"%d",DELEGATE_LastModified);
			for( si = 1; si < PARASERV; si++ ){
				execFunc(Conn,-1,sock,(iFUNCP)dom1,arg);
			}
		}
		service_domain1(Conn,sock);
	}else{
		scan_PERMIT(Conn,"udprelay");
		udp_relay(Conn,sock);
	}
	return 0;
}
int service_domain1(Connection *Conn,int sock)
{	CStr(ib,2048);
	CStr(ob,2048);
	int icc,occ;
	CStr(froma,128);
	int fromp;
	double Start,Time();
	CStr(msg,128);
	CStr(prevq,2048);
	int prevqlen;
	int prevrlen;
	int repeated;
	double prevTime;

	prevqlen = 0;
	for(;;){
		CHILD_SERNO_MULTI++;
		errno = 0;
		errorECONNRESET = 0;
		icc = RecvFrom(sock,ib,sizeof(ib),AVStr(froma),&fromp);
		if( icc <= 0 || strcmp(froma,"0.0.0.0") == 0 ){
			if( errorECONNRESET || errno == ECONNRESET ){
			sv1log("## RecvFrom(%d) = %d, ECONNRESET\n",
				sock,icc);
				/* previous resp. is discarded(Win32) */
				continue;
			}
			sv1log("FATAL RecvFrom(%d) = %d, errno=%d\n",
				sock,icc,errno);
			sleep(10);
			continue;
		}

		if( !service_permitted0(froma,fromp,"dns","-",0) )
			continue;

		Start = Time();
		if( icc == prevqlen
		 && bcmp(prevq,ib,icc) == 0
		 && Start-prevTime < 10.0 /* cache expiration time */
		){
			occ = prevrlen;
			sv1log("## QUERY repeated * %d\n",++repeated);
		}else{
		occ = (*RES_DNSSEARCH)(AVStr(ob),ib,icc,froma,fromp);
			if( 0 < occ ){
				prevTime = Time();
				bcopy(ib,prevq,icc);
				prevqlen = icc;
				prevrlen = occ;
				repeated = 0;
			}
		}
		if( 0 < occ )
			SendTo(sock,ob,occ,froma,fromp);
		sprintf(msg,"[%5.3fs] %s:%d ID=%d",Time()-Start,
			froma,fromp,(0xFF&ib[0])<<8|(0xFF&ib[1]));
		sv1log("%s\n",msg);
	}
	return 0;
}

extern const char *DNS_DOMAIN;
extern const char *DNS_ORIGIN;
extern const char *DNS_ADMIN;
extern const char *DNS_MX;
extern int   DNS_SERIAL;
extern int   DNS_REFRESH;
extern int   DNS_RETRY;
extern int   DNS_EXPIRE;
extern int   DNS_MINTTL;

void dns_init(){
	CStr(buf,128);
	const char *dp;
	int init;

	if( !streq(iSERVER_PROTO,"dns") )
		return;

	init = 0;
	if( DNS_ORIGIN == NULL ){
		init++;
		GetHostname(AVStr(buf),sizeof(buf));
		getFQDN(buf,AVStr(buf));
		DNS_ORIGIN = StrAlloc(buf);
	}
	if( DNS_DOMAIN == NULL ){
		init++;
		if( dp = strchr(DNS_ORIGIN,'.') )
			DNS_DOMAIN = StrAlloc(dp+1);
		else	DNS_DOMAIN = StrAlloc(DNS_ORIGIN);
	}
	if( DNS_ADMIN == NULL ){
		init++;
		DNS_ADMIN = getADMIN1();
	}
	if( DNS_ADMIN && strchr(DNS_ADMIN,'@') ){
		init++;
		strcpy(buf,DNS_ADMIN);
		for( dp = buf; *dp; dp++ )
			if( *dp == '@' )
				*(char*)dp = '.';
		DNS_ADMIN = StrAlloc(buf);
	}

	if( DNS_SERIAL == 0 ){
		init++;
		StrftimeGMT(AVStr(buf),sizeof(buf),"%Y%m%d%H",DELEGATE_LastModified,0);
		DNS_SERIAL = atoi(buf);
	}
	if( DNS_REFRESH == 0 ){ init++; DNS_REFRESH = 3600 * 6; }
	if( DNS_RETRY   == 0 ){ init++; DNS_RETRY   =  600; }
	if( DNS_EXPIRE  == 0 ){ init++; DNS_EXPIRE  = 3600 * 24 * 14; }
	if( DNS_MINTTL  == 0 ){ init++; DNS_MINTTL  = 3600 * 6; }

	if( init ){
		sv1log("DNS_DOMAIN=%s\n", DNS_DOMAIN);
		sv1log("DNS_ORIGIN=%s\n", DNS_ORIGIN);
		sv1log("DNS_ADMIN=%s\n",  DNS_ADMIN);
		sv1log("DNS_SERIAL=%d\n", DNS_SERIAL);
		sv1log("DNS_REFRESH=%d\n",DNS_REFRESH);
		sv1log("DNS_RETRY=%d\n",  DNS_RETRY);
		sv1log("DNS_EXPIRE=%d\n", DNS_EXPIRE);
		sv1log("DNS_MINTTL=%d\n", DNS_MINTTL);
	}
}

static scanListFunc scanconf1(PCStr(conf))
{	CStr(name,128);
	CStr(value,128);
	int ival;

	name[0] = value[0] = 0;
	Xsscanf(conf,"%[^:]:%s",AVStr(name),AVStr(value));
	sv1log("DNSCONF = %s : %s\n",name,value);
	ival = atoi(value);
	ival = (int)Scan_period(value,'s',(double)atoi(value));

	if( strcaseeq(name,"para") ){
		PARASERV = ival;
	}else
	if( strcaseeq(name,"domain") ){
		DNS_DOMAIN = StrAlloc(value);
	}else
	if( strcaseeq(name,"origin") ){
		DNS_ORIGIN = StrAlloc(value);
	}else
	if( strcaseeq(name,"admin") ){
		DNS_ADMIN = StrAlloc(value);
	}else
	if( strcaseeq(name,"serial") ){
		DNS_SERIAL = ival;
	}else
	if( strcaseeq(name,"refresh") ){
		DNS_REFRESH = ival;
	}else
	if( strcaseeq(name,"retry") ){
		DNS_RETRY = ival;
	}else
	if( strcaseeq(name,"expire") ){
		DNS_EXPIRE = ival;
	}else
	if( strcaseeq(name,"minttl") ){
		DNS_MINTTL = ival;
	}else
	if( strcaseeq(name,"mx") ){
		DNS_MX = StrAlloc(value);
	}else{
		sv1log("#### unknown [%s]\n",name);
	}
	return 0;
}

void scan_DNSCONF(Connection *Conn,PCStr(conf))
{
	scan_commaList(conf,0,scanListCall scanconf1);
}
