/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	http.h
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970708	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/

#include "url.h"

#define OBUFSIZE	URLSZ
#define IBUFSIZE	URLSZ
#define SOCKBUFSIZE	URLSZ
#define RESP_LINEBUFSZ	(URLSZ*4)

#define MY_HTTPVER	"1.1"
#define MY_MIMEVER	"1.0"

#define ME_7bit		((char*)0)
#define ME_binary	"binary"

#define R_EMPTY_RESPONSE	-10001
#define R_UNSATISFIED		-10002
#define R_UNSATISFIED_TEXT	-10003
#define R_NONTEXT_INTEXT	-10004
#define R_GENERATED		-10005
#define R_MOVED_LOOP		-10006
#define R_BROKEN_RESPONSE	-10007
#define R_PRIVATE		-10008

#define EMPTYBODY_SIZE		-2

/*
 * result status in the logfile
 */
#define CS_AUTHERR	'A'
#define CS_CONNERR	'C'
#define CS_ERROR	'E'
#define CS_HITCACHE	'H'
#define CS_INTERNAL	'I'
#define CS_LOCAL	'L'	/* local file (or CGI,SSI) */
#define CS_KILLED	'K'
#define CS_MAKESHIFT	'M'	/* connection failed and make shift */
#define CS_EOF		'P'
#define CS_NEW		'N'	/* got first (not found) */
#define CS_OBSOLETE	'O'	/* obsolete (modified) */
#define CS_RELOAD	'R'	/* reload (Pragma: no-cache) */
#define CS_STABLE	'S'	/* stable (not modified) */
#define CS_WITHOUTC	'W'	/* without cache */
#define CS_BADREQUEST	'B'	/* illegal request */
#define CS_TIMEOUT	'T'	/* timeout while waiting response */

typedef struct _HttpRequest {
	MStr(	hq_method,32);
	MStr(	hq_url,URLSZ);
	MStr(	hq_ver,32);
	int	hq_vno;
	int	hq_flags;
} HttpRequest;
#define HQF_ISPROXY	1

typedef struct {
	MStr(	hr_ver,256);		/* HTTP version */
	int	hr_rcode;		/* status code */
	MStr(	hr_reason,256);		/* reason */
	char	hr_isHTTP09;		/* before HTTP/1.0 */
} HttpResponse;

typedef struct {
	int	r_code;
	int	r_sav; /* if true, save the response message into r_msg[] */
	UTag	r_msg;
	int	r_len;
	FILE   *r_msgfp; /* if the response message is larger than r_msg */
} HtResp;

typedef struct {
	MStr(	r_oreqmsg,0x8000); /* original request message */
	int	r_oreqlen;

	MStr(	r_oreq,URLSZ);	/* original request line */
	UTag	r_ohost;	/* original server host */
	int	r_oport;	/* original server port */
	MStr(	r_vhost,256);	/* original Host: field */
	MStr(	r_UserAgent,256);
       AuthInfo r_reqAuth;
	MStr(	r_svReqAtyp,16);

	int	r_badRequest;
	int	r_normalized;
	int	r_checkServ;
	int	r_waitServ;
	int	r_badServ;
	MStr(	r_badServResponse,128);
	MStr(	r_badServDetected,32);
	MStr(	r_req,URLSZ);	/* HTTP request possibly rewritten */
 HttpRequest	r_reqx;		/* decomposed r_req */

	MStr(	r_fields,0x8000);
  const	char   *r_lastFname;	/* cache for getRequestField */
  const	char   *r_lastFbody;	/* (pointers into f_fields) */

	UTag	r_acclangs;	/* merged list of Accept-Language for log */

	MStr(	r_clntIfmod,256); /* If-Mod-Since from the  client */
	int	r_clntIfmodClock; /* its value in int */

	int	r_flushhead;
	int	r_flushsmall;

	int	r_withCookie;
	MStr(	r_dgCookie,256); /* Proxy-Cookie */
	int	r_appletFilter;

	int	r_clntAccChunk;
	MStr(	r_httpConn,128);
	int	r_get_cache;
	MStr(	r_iconBase,256);	
	HtResp	r_resp;
	MStr(	r_resp_add,256);
	int	r_reqAsis;
	int	r_doUnzip;
	int	r_doZip;

	int	r_NOJAVA;

  const char   *r_FTOCL; /* saved uncoditional FTOCL */
	UTag	r_o_buff; /* for stdio */
	UTag	r_i_buff;
	UTag	r_savConn;
} HTTP_env;

#define CurEnv		((HTTP_env*)Conn->cl_reqbuf)

#define OREQ_MSG	CurEnv->r_oreqmsg
/**/
#define OREQ_LEN	CurEnv->r_oreqlen

#define OREQ		CurEnv->r_oreq
/**/
#define OREQ_HOST	CurEnv->r_ohost.ut_addr
/**/
#define OREQ_HOST_SIZ	CurEnv->r_ohost.ut_size
#define OREQ_PORT	CurEnv->r_oport
#define OREQ_VHOST	CurEnv->r_vhost
/**/
#define REQ_UA		CurEnv->r_UserAgent
#define REQ_AUTH	CurEnv->r_reqAuth
#define SVREQ_ATYP	CurEnv->r_svReqAtyp
/**/

#define REQ		CurEnv->r_req
/**/
#define REQ_FIELDS	CurEnv->r_fields
/**/
#define REQX		CurEnv->r_reqx
#define REQ_METHOD	CurEnv->r_reqx.hq_method
/**/
#define REQ_URL		CurEnv->r_reqx.hq_url
#define REQ_VER		CurEnv->r_reqx.hq_ver
#define REQ_VNO		CurEnv->r_reqx.hq_vno
#define REQ_FLAGS	CurEnv->r_reqx.hq_flags

#define BadRequest	CurEnv->r_badRequest
#define Normalized	CurEnv->r_normalized
#define CheckServ	CurEnv->r_checkServ
#define WaitServ	CurEnv->r_waitServ
#define BadServ		CurEnv->r_badServ
#define BadServResponse	CurEnv->r_badServResponse
#define BadServDetected	CurEnv->r_badServDetected

#define AcceptLanguages	CurEnv->r_acclangs.ut_addr
/**/

#define FlushHead	CurEnv->r_flushhead
#define FlushIfSmall	CurEnv->r_flushsmall

#define ClntIfMod	CurEnv->r_clntIfmod
/**/
#define ClntIfModClock	CurEnv->r_clntIfmodClock

#define withCookie	CurEnv->r_withCookie
#define appletFilter	CurEnv->r_appletFilter
#define proxyCookie	CurEnv->r_dgCookie

#define iconBase	CurEnv->r_iconBase
#define GET_CACHE	CurEnv->r_get_cache
#define ClntAccChunk	CurEnv->r_clntAccChunk
#define httpConn	CurEnv->r_httpConn
/**/

#define RespCode	CurEnv->r_resp.r_code
#define RESP_SAV	CurEnv->r_resp.r_sav
#define RESP_MSG	CurEnv->r_resp.r_msg.ut_addr
/**/
#define RESP_SIZ	CurEnv->r_resp.r_msg.ut_size
#define RESP_LEN	CurEnv->r_resp.r_len
#define RESP_MSGFP	CurEnv->r_resp.r_msgfp
#define RESP_ADD	CurEnv->r_resp_add
/**/
#define RESP_DoUNZIP	CurEnv->r_doUnzip
#define RESP_DoZIP	CurEnv->r_doZip
#define REQ_ASIS	CurEnv->r_reqAsis

#define NOJAVA		CurEnv->r_NOJAVA
#define sav_FTOCL	CurEnv->r_FTOCL

#define F_HTTPVER	"HTTP/"
#define F_HTTPVERLEN	sizeof(F_HTTPVER)-1
#define F_DGVer		"DeleGate-Ver:"
#define F_ContType	"Content-Type:"
#define F_CtypeText	"Content-Type: text"
#define F_CtypePlain	"Content-Type: text/plain"
#define F_CtypeHTML	"Content-Type: text/html"
#define F_ContEncode	"Content-Encoding:"
#define F_TransEncode	"Transfer-Encoding:"
#define F_ContLeng	"Content-Length:"
#define F_ContRange	"Content-Range:"
#define F_Range		"Range:"
#define F_Location	"Location:"
#define F_ContLocation	"Content-Location:"
#define F_SetProxy	"Set-Proxy:"
#define F_LastMod	"Last-Modified:"
#define F_Etag		"Etag:"
#define F_Server	"Server:"
#define F_Cookie	"Cookie:"
#define F_SetCookie	"Set-Cookie:"
#define F_Connection	"Connection:"
#define F_PConnection	"Proxy-Connection:"
#define F_Upgrade	"Upgrade:"
#define F_CacheControl	"Cache-Control:"
#define F_Pragma	"Pragma:"
#define F_KeepAlive	"Keep-Alive:"
#define F_Via		"Via:"
#define F_Vary		"Vary:"
#define F_AccEncode	"Accept-Encoding:"

#define STRH(field,fname) \
	(strncasecmp(field,fname,sizeof(fname)-1)==0?sizeof(fname)-1:0)

#define STRH_Connection(field) ( \
	  STRH(field,F_Connection) ? STRH(field,F_Connection) \
	: STRH(field,F_PConnection) )

extern int HTTP11_toserver;
extern int HTTP11_toclient;
extern int HTTP09_reject;
extern int HTTP_ignoreIf;
extern int HTTP_warnApplet;
extern int HTTP_rejectBadHeader;
extern int HTTP_CKA_MAXREQ;
extern int HTTP_CKA_PERCLIENT;
extern int HTTP_MAXHOPS;
extern int HTTP_MAX_REQLINE;
extern int HTTP_MAX_REQHEAD;
extern int HTTP_GW_MAX_REQLINE;
extern const char *HTTP_MAX_REQLINE_sym;
extern const char *HTTP_MAX_REQHEAD_sym;
extern const char *HTTP_GW_MAX_REQLINE_sym;
extern const char *HTTP_urlesc;

extern double HTTP_TOUT_QBODY;
extern double HTTP_WAIT_REQBODY;
extern double HTTP_TOUT_IN_REQBODY;
extern double HTTP_TOUT_BUFF_REQBODY;
extern double HTTP_TOUT_CKA;
extern double HTTP_TOUT_CKA_MARGIN;
extern double HTTP_TOUT_RESPLINE;
extern double HTTP_WAIT_BADSERV;

#define CMAP_APPROVER "Approver"
extern int modwatch_enable;
extern const char *modwatch_notify;
extern int modwatch_approver;

#define KH_REQ	1
#define KH_RES	2
#define KH_BOTH	3
#define KH_IN	0x10
#define KH_OUT	0x20

extern int HTTP_cacheopt;
#define CACHE_NOLASTMOD	0x0001
#define CACHE_NOCACHE	0x0002
#define CACHE_302	0x0004
#define CACHE_COOKIE	0x0008
#define CACHE_404	0x0010 /* unknown */

extern int HTTP_opts;
#define HTTP_DELWRONGCONTLENG	1
#define HTTP_NOCHUNKED		2
#define HTTP_SUPPCHUNKED	4
#define HTTP_FLUSHCHUNK		8
#define HTTP_NOKEEPALIVE	0x10
#define HTTP_NOMETHODCHECK	0x20
#define HTTP_NOGZIP		0x40
#define HTTP_LINEBYLINE		0x80
#define HTTP_NOKEEPALIVEPROXY	0x100
#define HTTP_DOAUTHCONV		0x1000
#define HTTP_AUTHBASIC_NEVER_SV	0x2000
#define HTTP_AUTHBASIC_DELAY_SV	0x4000
#define HTTP_FORCEBASIC_CL	0x8000
#define HTTP_THRUDIGEST_CL	0x10000
#define HTTP_SESSION		0x20000
#define HTTP_NOPIPELINE		0x40000
#define HTTP_NODELAY		0x80000
#define HTTP_NOFLUSHCHUNK	0x100000
#define HTTP_TOUTPACKINTVL	0x200000
#define HTTP_NOKEEPALIVE_STLS	0x400000
#define HTTP_DUMPSTAT		0x80000000

#define doKeepAliveWithSTLS(Conn) \
	( Conn->xf_filters == XF_FCL \
	&& (ClientFlags & (PF_STLS_ON|PF_SSL_ON)) \
	&& (HTTP_opts & HTTP_NOKEEPALIVE_STLS) == 0 )

typedef struct {
	int	p_Isin;	/* isin xxx.html?part */
	MStr(	p_Type,32);
	int	p_Asis;
	int	p_Indexing;
	int	p_BaseSet;
	MStr(	p_Base,256);
	MStr(	p_Title,256);
} Partf;


void  setHTTPenv(Connection *Conn,HTTP_env *he);
void  resetHTTPenv(Connection *Conn,HTTP_env *he);

/*-- REQUEST */
int   HTTP_reqIsHTTP(Connection *Conn,PCStr(req));
int   HTTP_methodWithBody(PCStr(method));
int   HTTP_reqWithHeader(Connection *Conn,PCStr(req));
int   decomp_http_request(PCStr(req),HttpRequest *reqx);
int   HTTP_decompRequest(Connection *Conn);
int   HTTP_allowMethod1(Connection *Conn,PCStr(req));
int   HTTP_allowMethods(Connection *Conn,PVStr(methods));
void  HTTP_setMethods(PCStr(methods));
int   HTTP_originalURLx(Connection *Conn,PVStr(url),int siz);
char *HTTP_originalRequest(Connection *Conn,PVStr(req));
const char *HTTP_outCharset(Connection *Conn);
void  HTTP_scanAcceptCharcode(Connection *Conn,PVStr(field));
void  HTTP_getHost(Connection *Conn,PCStr(request),PCStr(fields));
void  HTTP_setHost(Connection *Conn,PVStr(fields));
int   decomp_http_status(PCStr(stat),HttpResponse *resx);

int   fromProxyClient(PCStr(url));
int   NotREACHABLE(Connection *Conn,PCStr(proto),PCStr(host),int port);
void  HTTP_delayReject(Connection *Conn,PCStr(req),PCStr(stat),int self);
void  HTTP_delayCantConn(Connection *Conn,PCStr(req),PCStr(stat),int self);

/*-- GENERATE RESPONSE */
int   HTML_put1s(FILE *fp,PCStr(fmt),PCStr(val));
int   putHEAD(Connection *Conn,FILE *tc,int code,PCStr(reason),PCStr(server),PCStr(ctype),PCStr(ccode),int csize,int mtime,int expire);
int   HTTP_putHeader(Connection *Conn,FILE *tc,int vno,PCStr(type),int size,int mtime);
int   HTTP_putData(Connection *Conn,FILE *tc,int vno,PCStr(dataspec));
int   HTTP_putDeleGateHeader(Connection *Conn,FILE *tc,int iscache);
int   putMovedTo(Connection *Conn,FILE *tc,PCStr(url));
int   putMovedToX(Connection *Conn,FILE *tc,int code,PCStr(url));
int   putUnknownMsg(Connection *Conn,FILE *tc,PCStr(req));
int   putHttpRejectmsg(Connection *Conn,FILE *tc,PCStr(proto),PCStr(server),int iport,PVStr(req));
int   putHttpNotModified(Connection *Conn,FILE *tc);
int   putChangeProxy(Connection *Conn,FILE *tc,PCStr(url),PCStr(proxy));
int   putNotAuthorized(Connection *Conn,FILE *tc,PCStr(req),int proxy,PCStr(realm),PCStr(mssg));
int   putFrogVer(Connection *Conn,FILE *tc);
int   putHttpNotModified(Connection *Conn,FILE *tc);
int   putHttpNotFound(Connection *Conn,FILE *tc,PCStr(mssg));
int   putHttpNotAvailable(Connection *Conn,FILE *tc,PCStr(mssg));
int   putConfigError(Connection *Conn,FILE *tc,PCStr(mssg));
int   putHttpCantConnmsg(Connection *Conn,FILE *tc,PCStr(proto),PCStr(server),int iport,PCStr(req));

/*-- KEEP ALIVE */
int   putServ(Connection *Conn,int tsfd,int fsfd);
int   getServ(Connection *Conn);
void  delServ(Connection *Conn,int tsfd,int fsfd);
int   putKeepAlive(Connection *Conn,FILE *tc);
void  setKeepAlive(Connection *Conn,int timeout);
void  HTTP_clntClose(Connection *Conn,PCStr(fmt),...);
void  HTTP_modifyConnection(Connection *Conn,int rlength);

/*-- MOUNT */
int   MountMoved(Connection *Conn,FILE *tc);
void  MountReferer(Connection *Conn,PVStr(fields));
int   MountSpecialResponse(Connection *Conn,FILE *tc);
int   isMovedToAnotherServer(Connection *Conn,PCStr(line));
int   isMovedToSelf(Connection *Conn,PCStr(line));
void  url_absoluteS(Referer *referer,PCStr(line),PVStr(xline),PVStr(rem));
int   url_partializeS(Referer *referer,PCStr(line),PVStr(xline));
void  HTTP_baseURLrelative(Connection *Conn,PCStr(path),PVStr(url));
int   MountRequestURL(Connection *Conn,PVStr(ourl));
int   HTTP_setRetry(Connection *Conn,PCStr(req),int rcode);

/*-- AUTH */
int   auth_proxy_auth();
int   auth_origin_auth();
int   auth_proxy_pauth();
int   HTTP_authuserpass(Connection *Conn,PVStr(auth),int size);
int   HTTP_getAuthorization(Connection *Conn,int proxy,AuthInfo *ident,int decomp);
int   HTTP_getAuthorization2(Connection *Conn,AuthInfo *ident,int decomp);
int   HTTP_forgedAuthorization(Connection *Conn,PCStr(fields));
int   HTTP_proxyAuthorized(Connection *Conn,PCStr(req),PCStr(fields),int pauth,FILE *tc);
int   HTTP_decompAuth(PCStr(auth),PVStr(atype),int atsiz,PVStr(aval),int avsiz);
int   HTTP_decompAuthX(PCStr(auth),PVStr(atype),int atsiz,PVStr(aval),int avsiz,AuthInfo *ident);
int   askDigestAuth(Connection *Conn,int forced_realm,PCStr(realm),PVStr(digest));
void  refreshDigestNonce(Connection *Conn,FILE *tc);
void  resetDigestInCookie(Connection *Conn,PVStr(field));
void  rewriteReqBasicToDigest(Connection *Conn,PVStr(fields));
void  scanDigestParams(PCStr(cp),AuthInfo *ident,PVStr(aval),int avsiz);
void  setDigestInCookie(Connection *Conn,AuthInfo *seed,PVStr(field));
void  genAuthDigest(Connection *Conn,PCStr(fname),PVStr(reqauth),int rsize,AuthInfo *seed,PCStr(user),PCStr(pass));

/*-- CACHE */
int   HTTP_ContLengOk(FILE *cachefp);
int   HTTP_selfExpired(FILE *cachefp);
int   makeDistribution(Connection *Conn,FILE *cachefp,PCStr(cpath));
FILE *recvDistribution(Connection *Conn,PCStr(cpath),int *updated);
int   sendDistribution(Connection *Conn,FILE *cachefp,FILE *fs,FILE *tc,PCStr(buff),int leng);
void  stopDistribution(Connection *Conn,FILE *cachefp,PCStr(cpath));
void  detachFile(FILE *fp);
int   HTTP_genLastMod(PVStr(scdate),int size,FILE *cachefp,PCStr(cpath));
int   HTTP_getLastMod(PVStr(scdate),int size,FILE *cachefp,PCStr(cpath));

/*-- COOKIE */
int   genSessionCookie(Connection *Conn,PVStr(field));
int   getDigestInCookie(PVStr(fields),AuthInfo *seed);
void  MountCookieRequest(Connection *Conn,PCStr(request),PVStr(value));
void  MountCookieResponse(Connection *Conn,PCStr(request),PVStr(value));

/*-- HEADER FIELD EDITING */
int   makeForwarded(Connection *Conn,PVStr(forwarded));
int   makeFrom(Connection *Conn,PVStr(genfrom));
int   HTTP_genVia(Connection *Conn,int isreq,PVStr(via));
int   HTTP_genhead(Connection *Conn,PVStr(head),int what);
int   HTTP_head2kill(PCStr(head),int what);
int   HTTP_killhead(PVStr(head),int what);
void  HTTP_delRequestField(Connection *Conn,PCStr(fname));
void  HTTP_editResponseHeader(Connection *Conn,FILE *tc);

/*-- ROBOTS */
int   reqRobotsTxt(Connection *Conn);
int   putRobotsTxt(Connection *Conn,FILE *tc,FILE *afp,int ismsg);

/*-- LOGGING */
void  http_logplus(Connection *Conn,char type);
void  http_Log(Connection *Conn,int rcode,int rstat,PCStr(req),int size);

/*-- GATEWAY */
void  connected_to_proxy(Connection *Conn,PCStr(req),int clsock);
void  add_localheader(Connection *Conn,int proxy);
void  clearPartfilter(Partf *Pf);
int   Partfilter(Connection *Conn,Partf *Pf,PVStr(line),int size);
void  getProxyControlPart(Connection *Conn,PVStr(url));
void  makeProxyRequest(Connection *Conn);
int   httpfinger(Connection *Conn,int sv,PCStr(server),int iport,PCStr(path),int vno);
void  FTPHTTP_genPass(PVStr(pass));
int   HTTP_ACCEPT(Connection *Conn,PCStr(req),PCStr(head),FILE *fc,FILE *tc);
int   java_conv(PCStr(line),PVStr(xline),int uconvs);
void  doXECHO(FILE *tc,PCStr(msg));


/*-- CGI */
const char *URL_toMyself(Connection *Conn,PCStr(url));
int   HttpToMyself(Connection *Conn,PVStr(req),PCStr(head),FILE *fc,FILE *tc,int *stcodep);
int   form2v(PVStr(form),int maxargc,const char *argv[]);
int   HTTP_form2v(Connection *Conn,FILE *fc,int maxargc,const char *argv[]);

