/*
 *  The following code is extracted from $ONEW/sys/sys.h which was
 *  made by members of <onew@etl.go.jp> <ftp://etlport.etl.go.jp/pub/onew>
 */
/*
 *  Get the count of bufferd characters.
 */
#ifdef __linux__
#if defined(_LIBIO_H) || defined(_IO_STDIO_H)
#define READYCC(fp)     (fp->_IO_read_end - fp->_IO_read_ptr)
#else
#define READYCC(fp)     (fp->_egptr - fp->_gptr)
#endif
#else
#if defined(__bsdi__) \
 || defined(__FreeBSD__) \
 || defined(__NetBSD__) \
 || defined(__OpenBSD__) \
 || defined(__MACHTEN__) \
 || defined(__CYGWIN__) || defined(__MINGW32__) \
 || defined(__APPLE__)
#define READYCC(fp)     (fp->_r)
#else
#ifdef __GNU_LIBRARY__
#define READYCC(fp)     (fp->__get_limit - fp->__bufp)
#else
#ifdef __EMX__
#define READYCC(fp)	(fp->_rcount)
#else
#define READYCC(fp)     (fp->_cnt)
#endif
#endif
#endif
#endif


#if defined(HCASE)
#ifdef READYCC
#undef READYCC
#endif

#if HCASE == 1
#define READYCC(fp)     (fp->_IO_read_end - fp->_IO_read_ptr)
#endif

#if HCASE == 2
#define READYCC(fp)     (fp->_egptr - fp->_gptr)
#endif

#if HCASE == 3
#define READYCC(fp)     (fp->_r)
#endif

#if HCASE == 4
#define READYCC(fp)     (fp->__get_limit - fp->__bufp)
#endif

#if HCASE == 5
#define READYCC(fp)	(fp->_rcount)
#endif

#if HCASE == 6
#define READYCC(fp)     (fp->_cnt)
#endif

#if HCASE == 7
#define READYCC(fp)	READYCC_UNSUPPORTED()
#endif

#endif

typedef struct {
	int	rc_ctrl;
	int	rc_stat;
	int	rc_max_turns;
	int	rc_num_turns;
	double	rc_max_packintvl;
	double	rc_packintvl;
} RelayCtrl;
#define RELAY_HALFDUP		1
#define RELAY_NOTHALFDUP	1
extern RelayCtrl relayCtrl;

#define	RELAY_ctrl	relayCtrl.rc_ctrl
#define	RELAY_stat	relayCtrl.rc_stat
#define RELAY_max_turns	relayCtrl.rc_max_turns
#define RELAY_num_turns	relayCtrl.rc_num_turns
#define	RELAY_max_packintvl	relayCtrl.rc_max_packintvl
#define	RELAY_packintvl	relayCtrl.rc_packintvl
#define	RELAY_half_dup	(relayCtrl.rc_ctrl & RELAY_HALFDUP)

#ifndef _MSC_VER
#include <unistd.h>
#endif

int top_fd(int fd,int rw);
int file_issock(int fd);
int file_isreg(int fd);
int file_isselectable(int fd);
int isUDPsock(int sock);

int ready_cc(FILE *fp);
int fPollIn(FILE *fp,int msec);
int PollIn1(int fd,int msec);
int PollIn(int fd,int msec);
int PollIn_HUP(int on);
int _PollIn(int fd,int msec);
int poll_error(int fd);
int pollPipe(int pfd,int slpmsec);
int PollIns(int timeout,int size,int *mask,int *rmask);
int fPollIns(int timeout,int fpc,FILE *fps[],int rdv[]);
int PollOut(int fd,int timeout);

int connHUP();
int connRESETbypeer();
int readyAlways(int fd);
int PollInsOuts(int timeout,int nfds,int fdv[],int ev[],int rev[]);

int copyfile1(FILE *sfp,FILE *dfp);
int simple_relayf(FILE *src,FILE *dst);
int simple_relay(int src,int dst);
void frelay(int timeout,int s1,int d1,int s2,int d2,int (*relayfunc)(FILE*,FILE*));
void usleep_bypoll(int usec);
void relay2_cntl(int timeout,int s1,int d1,int s2,int d2,int s3,int d3,int (*cntlfunc)(void*,...),void *arg);
