/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	embed.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941001	created
	970104	self wild-card extension
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include "ystring.h"
#include "file.h"

int fileN;
int textR;

int file1(PCStr(path))
{	FILE *fp;
	int nc,col,ch;
	int cr,lf;
	int bin;
	struct stat st;
	int textseg;

	stat(path,&st);
	fp = fopen(path,"r");
	if( fp == NULL ){
		fprintf(stderr,"cannot open: %s\n",path);
		return 0;
	}

	textseg = textR < fileN;
	if( textseg )
		printf("#define FILE_%03d \"",fileN++);
	else	printf("static char FILE_%03d[] = \"",fileN++);

	printf("%-8x",(int)st.st_size);
	printf("%-8x",st.st_mtime);
	printf("\\\n%s\\000\\\n",path);

	nc = 0;
	col = 0;
	cr = 0;
	lf = 0;
	bin = 0;
	while( (ch = getc(fp)) != EOF ){
		nc++;
		if( 70 <= col ){
			printf("\\\n");
			col = 0;
		}
		if( ch == '\n' && !bin ){ printf("\\n\\\n"); col = 0; lf++;}else
		if( ch == '\r' && !bin ){ printf("\\r");    col += 2; cr++;}else
		if( ch == '\t' && !bin ){ printf("\\t");    col += 2; }else
		if( ch == '"'  && !bin ){ printf("\\\"");   col += 2; }else
		if( ch == '\\' && !bin ){ printf("\\\\");   col += 2; }else
		if( bin || ch<0x20 || 0x7F<=ch || ch=='"' || ch=='\\' ){
			if( 0x80 <= ch )
				bin = 1;
			printf("\\%03o",ch);
			col += 4;
		}else{
			printf("%c",ch);
			col += 1;
		}
	}
	if( cr == 0 && 2048 < nc + lf ){
	fprintf(stderr,"#### WARNING: \"%s\"\n",path);
	fprintf(stderr,"#### This string value will over flow (%d+%d)\n",
		nc,lf);
	fprintf(stderr,"#### on the system where line ends with CR LF\n");
	}
	if( textseg )
		printf("\"\n\n",nc,st.st_mtime);
	else	printf("\";\n\n",nc,st.st_mtime);
	fclose(fp);
	return 0;
}

scanDirFunc dir1(PCStr(file),PCStr(filter),PCStr(curdir),PCStr(recursive))
{	CStr(ncurdir,1024);
	const char *pp;
	CStr(path,1024);
	int plen;

	if( recursive && file[0] != '.' ){
		sprintf(ncurdir,"%s/%s",curdir,file);
		Scandir(ncurdir,scanDirCall dir1,filter,ncurdir,recursive);
	}

	if( filter[0] == '*' ){
		if( (pp = strstr(file,filter+1)) == NULL )
			return 0;
		if( pp[strlen(filter+1)] != 0 )
			return 0;
	}else{
		if( strcmp(file,filter) != 0 )
			return 0;
	}
	sprintf(path,"%s/%s",curdir,file);
	file1(path);
	return 0;
}

int main(int ac,char *av[])
{	int ai;
	CStr(dirfile,1024);
	const char *filter;
	const char *recursive;
	char randi;

	setBinaryIO();

	if( ac < 2 ){
		fprintf(stderr,"Usage: %s file-names\n",av[0]);
		exit(1);
	}

	textR = (time(0)+getpid()) % 64;

	for( ai = 1; ai < ac; ai++ ){
		strcpy(dirfile,av[ai]);
		if( filter = (char*)strrchr(dirfile,'/') ){
			truncVStr(filter); filter++;
			if( recursive = strstr(dirfile,"**") ){
				truncVStr(recursive);
				if( dirfile<recursive && recursive[-1]=='/' )
					((char*)recursive)[-1] = 0;
			}
		}else	filter = "";
		Scandir(dirfile,scanDirCall dir1,filter,dirfile,recursive);
	}

	randi = (time(0)+getpid()) % fileN;
	printf("static char *datavec[] = {\n");
	for( ai = fileN-1; randi < ai; ai-- )
	printf(" FILE_%03d,\n",ai);
	printf(" 0,\n");
	printf("};\n");

	printf("const char *get_builtin_file(int i){\n");
	printf(" if( %d <= i && i <= %d )\n",randi+1,fileN-1);
	printf("  return datavec[%d-i];\n",fileN-1);
	printf(" switch( i ){\n");
	for( ai = randi; 0 <= ai; ai-- )
	printf("  case %3d: return FILE_%03d;\n",ai,ai);
	printf(" }\n");
	printf(" return 0;\n");
	printf("}\n");

	if( ADMINPASS[0] != 0 ){
		CStr(src,256);
		const char *psp;
		const char *np;
		CStr(md5list,1024);
		refQStr(mdp,md5list); /**/
		int pi;

		psp = ADMINPASS;
		for( pi = 0; pi < 8; pi++ ){
			if( pi != 0 )
				setVStrPtrInc(mdp,':');
			if( *psp ){
				if( Xsscanf(psp,"%[^:]",AVStr(src)) ){
					if( *src != 0 )
						toMD5(src,(char*)mdp);
					mdp += strlen(mdp);
				}
				if( *psp == ':' )
					psp++;
				else
				if( np = strchr(psp,':') )
					psp = np + 1;
				else	psp = "";
			}
		}
		setVStrEnd(mdp,0);
		printf("#define ADMINPASS \"%s\"\n",md5list);
	}
	printf("#define MADE_TIME %d\n",time(0));
	exit(0);
	return 0;
}

int (*DELEGATE_MAIN)(int ac,const char *av[]);
void (*DELEGATE_TERMINATE)();
