/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	mime.c (MIME header encoder/decoder)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941008	extracted from nntp.c
	950312	encode/decode parts in a multipart message
//////////////////////////////////////////////////////////////////////#*/

extern const char *MimeKit_Version;

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "ystring.h"
#include "file.h"

#ifndef strdup
#define strdup(str)	strcpy( malloc(strlen(str)+1), str )
#endif
#define substr(s1,s2)	(strncasecmp(s1,s2,strlen(s2)) == 0)

#define LINESIZE	1024

#define isEOH(line)	(line[0]=='\r' || line[0]=='\n')
#define isEOR(line)	(line[0]=='.' && (line[1]=='\r'||line[1]=='\n'))

extern int MIME_CONV;

void  scan_MIMECONV(PCStr(conv));
int   scan_HTMLCONV(void*,PCStr(conv));

void  MIME_to64(FILE*, FILE*);
void  MIME_to64X(FILE*, FILE*, int);
void  MIME_toQP(FILE*, FILE*);
void  MIME_from64(FILE*, FILE*);
void  MIME_fromQP(FILE*, FILE*);
void  MIME_headerDecode(FILE*, FILE*, int);
void  MIME_headerEncode(FILE*, FILE*);
FILE* MIME_tmpHeaderEncode(FILE*);

void  encodeMIME(FILE *fc, FILE *ts);
void  decodeMIME(FILE*fs,FILE*tc,FILE*cache,int filter,int codeconv,int enHTML);

void  PGPencodeMIME(FILE*, FILE*);
void  PGPdecodeMIME(FILE*, FILE*, FILE*, int,int,int);
int   PGP_DECR();
int   PGP_VRFY();

void  copyLEOLINE(FILE *src,FILE *dst);
void  fputsCRLF(PCStr(str),FILE *out);

int   str_isStr(FILE*);
int   str_fflush(FILE*);
int   str_fclose(FILE*);
int   str_ftell(FILE*);
int   str_fseek(FILE*,int off,int where);
int   str_fprintf(FILE*,PCStr(fmt),...);
int   str_fgetc(FILE*);
int   str_fputs(PCStr(str),FILE*);
int   str_fputc(int ch,FILE*);
int   str_fungetc(int ch,FILE*);

#include <time.h>
/*
time_t time(time_t*);
*/
