/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2003-2004 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for noncommercial and/or evaluation
purpose, copy this material for your own use, and distribute the copies
via publicly accessible on-line media, without fee, is hereby granted
provided that the above copyright notice and this permission notice
appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:   program/C; charset=US-ASCII
Program:        dgauth.c
Author:         Yutaka Sato <ysato@delegate.org>
Description:
History:
        031115	extracted from delegated.c, access.c, ...
//////////////////////////////////////////////////////////////////////#*/
#include <sys/types.h>
#include <sys/stat.h>
#include "delegate.h"
#include "param.h"
#include "file.h"
#include "credhy.h"
#include "auth.h"
int serverPid();

extern const char *MAP_AUTHSERV;
char DGAUTHpro[] = "dgauth";
char DGAUTHdom[] = "-dgauth";
const char *DGAuthDFLT_realm = "-";
int NONCE_TIMEOUT = 60;

static const char *DGAuthHost;
static int DGAuthPort;
static struct { MStr(e_nonceKey,64); } nonceKey;
#define nonceKey nonceKey.e_nonceKey
static int xgetpass(PCStr(passspec),PVStr(pass))
{	CStr(what,32);
	CStr(data,64);
	FILE *kfp;

	scan_field1(passspec,AVStr(what),sizeof(what),AVStr(data),sizeof(data));
	if( streq(what,"pass") ){
		strcpy(pass,data);
	}else
	if( streq(what,"file") ){
		if( kfp = fopen(data,"r") ){
			fgets(data,sizeof(data),kfp);
			fclose(kfp);
			linescanX(data,AVStr(pass),64);
		}else{
		}
	}else
	if( streq(what,"serv") ){
		DGAuthHost = "127.0.0.1";
		DGAuthPort = atoi(data);
	}else{
		return -1;
	}
	return 0;
}

/*
 * make the key reloadable on restart (by reboot, in an hour)
 * ignore it if something modified (DeleGate binary, the file, or the directory)
 */
static void dumpCKeyKey(PCStr(path),PVStr(skey),int prev)
{	CStr(dir,1024);
	const char *dp;
	CStr(date,64);
	int now;

	lineScan(path,dir);
	if( (dp = strrchr(dir,'/')) && dp != dir )
		truncVStr(dp);
	now = time(0) - prev*60*60;
	StrftimeLocal(AVStr(date),sizeof(date),"%y%m%d%H",now,0);
	/*
	sprintf(skey,"%s.%x.%x",date,File_ctime(dir),(int)dumpCKeyKey);
	*/
	sprintf(skey,"%s.%x.%lx",date,0,dumpCKeyKey);
}
void dumpCKeyPath(PVStr(path));
void dumpCKey(int force)
{	CStr(path,256);
	CStr(ekey,256);
	CStr(cc,64);
	CStr(md5,64);
	CStr(skey,64);
	CStr(xpass,256);
	int elen,xlen;
	FILE *fp;

	if( force || getpid() == serverPid() )
	if( 0 < (elen = getCKey(AVStr(ekey),sizeof(ekey))) )
	{
		dumpCKeyPath(AVStr(path));
		if( fp = dirfopen("CKey",AVStr(path),"w") ){
			chmod(path,0600);
			dumpCKeyKey(path,AVStr(skey),0);
			sprintf(cc,"%s.%s",skey,ekey);
			toMD5(cc,md5);
			xlen = aencrypty(skey,strlen(skey),ekey,elen,xpass);
			fprintf(fp,"%s %s\n",md5,xpass);
/*
fprintf(stderr,"#### DUMPED %s %d[%s %s] to %s\n",skey,elen,md5,xpass,path);
*/
			fclose(fp);
			set_utimes(path,-1,1);
		}
		bzero(ekey,sizeof(ekey));
	}
}
static int restoreCKey(PVStr(ekey),int esiz)
{	CStr(path,256);
	CStr(key,256);
	CStr(cc,64);
	CStr(md5,64);
	CStr(epass,256);
	CStr(xmd5,64);
	ACStr(skeys,2,64);
	int si,elen;
	FILE *fp;

	dumpCKeyPath(AVStr(path));
	if( fp = fopen(path,"r") ){
		for( si = 0; si < 2; si++ )
			dumpCKeyKey(path,EVStr(skeys[si]),si);
		key[0] = 0;
		fgets(key,sizeof(key),fp);
		fclose(fp);
		unlink(path);

		md5[0] = epass[0] = 0;
		Xsscanf(key,"%s %s",AVStr(md5),AVStr(epass));

		for( si = 0; si < 2; si++ ){
			const char *skey; /**/
			skey = skeys[si];
			elen = adecrypty(skey,strlen(skey),epass,strlen(epass),
				(char*)ekey);
			sprintf(cc,"%s.%s",skey,ekey);
			toMD5(cc,xmd5);

fprintf(stderr,"#### RESTORED %s %d[%s %s]\n",skey,elen,md5,epass);

			sv1log("#### KEY RESTORED FROM %s\n",path);
			if( streq(md5,xmd5) ){
				return elen;
			}
		}
	}
	return 0;
}

/*
 * should be CRYPT=pass:word[:realm] ...
 */
void setCKey(PCStr(ekey),int elen);

void scan_CRYPT(Connection *Conn,int clnt)
{	const char *cryptspec;
	CStr(ekey,128);
	const char *dp;
	int elen,reset;
	FILE *keyin;

	reset = 0;
	if( cryptspec = DELEGATE_getEnv(P_CRYPT) ){
		if( cryptspec[0] == 0 ){
			/* maybe after "erestart" */
		}else
		if( strcmp(cryptspec,"pass:") == 0 ){
			reset = 1;
		}else{
			if( xgetpass(cryptspec,AVStr(ekey)) != 0 )
				return;
			if( *ekey == 0 )
				return;
			for( dp = cryptspec; *dp; dp++ )
				truncVStr(dp); /* hide commandline arg. */
			goto GOT;
		}
	}

	elen = restoreCKey(AVStr(ekey),sizeof(ekey));
	if( 0 < elen && !reset )
		goto GOT;

	if( clnt ){
		int sock,port;
		CStr(host,256);
		sock = DGAuth_port(0,AVStr(host),&port);
		if( 0 <= sock ){
			close(sock);
			return;
		}
	}
	if( isatty(fileno(stdin)) ){
		keyin = fdopen(fileno(stdin),"r");
		setbuf(keyin,NULL);

		fprintf(stderr,
		"**** Specify the key of encryption for '%s'\r\n",DGAUTHpro);
		fprintf(stderr,"**** CRYPT=pass:");
		fflush(stderr);
		fgets(ekey,sizeof(ekey),keyin);

		if( dp = strpbrk(ekey,"\r\n") )
			truncVStr(dp);
		fprintf(stderr,"\r\n");
	}else{
		sv1log("ERROR: cannot get CRYPT value\n");
		return;
	}
GOT:
	setCKey(ekey,strlen(ekey));
	for( dp = ekey; *dp; dp++ )
		truncVStr(dp);
}

#define EMSG(msg) { \
	daemonlog("F","!!!! FATAL: %s\n",msg); \
	fprintf(stderr,"!!!! FATAL: %s\n",msg); \
}

int scanAuthServPort(PCStr(domain),PVStr(serv));
int checkEkey(int store,PCStr(proto),PCStr(host),int port,PCStr(ekey));

int checkDGAuthConfig()
{	int mx;
	const char *authservp;
	CStr(domain,256);
	CStr(msg,512);
	const char *dp;
	CStr(serv,64);
	CStr(ekey,64);
	int port,elen,rcode,ecode;

	rcode = 0;
	for( mx = 0; ; mx++ ){
		mx = scan_CMAPi(MAP_AUTHSERV,mx,&authservp);
		if( mx < 0 )
			break;
		if( strstr(authservp,DGAUTHdom) != authservp )
			continue;
		lineScan(authservp,domain);
		if( dp = strchr(domain,',') )
			truncVStr(dp);
		if( dp = strchr(domain,'@') )
			truncVStr(dp);

		port = scanAuthServPort(domain,AVStr(serv));
		if( serv[0] ){
			/* check connectivity */
			continue;
		}
		elen = getCKey(AVStr(ekey),sizeof(ekey));
		if( elen <= 0 ){
			sprintf(msg,"CRYPT=pass:... is not specified.");
			EMSG(msg);
			rcode = -1;
			continue;
		}
		ecode = checkEkey(0,DGAUTHpro,domain,0,ekey);
		bzero(ekey,sizeof(ekey));
		if( ecode != 0 ){
			if( ecode == -AUTH_EBADDOMAIN )
				sprintf(msg,"bad domain AUTHORIZER=%s",domain);
			else	sprintf(msg,"CRYPT=pass:... is wrong.");
			setCKey("",0);
			EMSG(msg);
			rcode = -1;
		}
	}
	return rcode;
}
int withAuthDigest(Connection *Conn,PVStr(authserv))
{
	if( 0 <= find_CMAP(Conn,MAP_AUTHSERV,AVStr(authserv)) ){
		if( strncmp(authserv,DGAUTHdom,7) == 0 )
			return 1;
	}
	return 0;
}

static int found;
int static isDGAdom(Connection *Conn,PCStr(dom))
{
	if( strstr(dom,DGAUTHdom) == dom )
		found = 1;
	return 0;
}
int withDGAuth(Connection *Conn)
{
	found = 0;
	DELEGATE_scanEnv(Conn,P_AUTHORIZER,(scanPFUNCP)isDGAdom);
	return found;
}

FILE *fopen_DGAuth()
{	int sock;

	if( DGAuthPort == 0 )
		return NULL;
	sock = client_open(DGAUTHpro,DGAUTHpro,DGAuthHost,DGAuthPort);
	if( 0 <= sock )
		return fdopen(sock,"r+");
	else	return NULL;
}
int DGAuth_port(int create,PVStr(host),int *portp)
{	CStr(path,1024);
	CStr(lpath,1024);
	const char *dp;
	FILE *fp,*lfp;
	int sock,port;

	sprintf(path,"${ADMDIR}/authorizer/%s/port",DGAUTHdom);
	DELEGATE_substfile(AVStr(path),"",VStrNULL,VStrNULL,VStrNULL);
	sprintf(lpath,"%s.lock",path);

	if( create ){
		lfp = fopen(lpath,"w+");
		if( lfp == NULL || lock_exclusiveTO(fileno(lfp),1,NULL) != 0 ){
			if( lfp ) fclose(lfp);
			return -1;
		}
		fp = fopen(path,"w+");
		if( fp == NULL ){
			fp = dirfopen("DGAuth_port",AVStr(path),"w");
			if( fp == NULL ){
				fclose(lfp);
				return -1;
			}
		}
		sock = server_open(DGAUTHpro,CVStr("127.0.0.1"),0,10);
		if( sock < 0 ){
			fclose(lfp);
			fclose(fp);
			return -1;
		}
		strcpy(host,"127.0.0.1");
		*portp = port = sockPort(sock);
		fseek(fp,0,0);
		fprintf(fp,"%s:%d\n","127.0.0.1",port);
		fclose(fp);
		chmod(path,0600);
		fcloseFILE(lfp);
	}else{
		if( !File_is(lpath) ){
			/* no server */
			return -1;
		}
		lfp = fopen(lpath,"r");
		if( lfp == NULL || lock_sharedTO(fileno(lfp),1,NULL)==0 ){
			/* no active server locking it. */
			if( lfp ) fclose(lfp);
			return -1;
		}
		fclose(lfp);

		fp = fopen(path,"r");
		if( fp == NULL )
			return -1;

		setVStrEnd(host,0);
		fgets(host,256,fp);
		port = 0;
		if( dp = strchr(host,':') ){
			truncVStr(dp); dp++;
			port = atoi(dp);
		}
		sock = client_open(DGAUTHpro,DGAUTHpro,host,port);
		*portp = port;
		DGAuthHost = stralloc(host);
		DGAuthPort = port;
		fclose(fp);
	}
	return sock;
}
int connectDGAuth(PCStr(domain),FILE *sv[2])
{	int sock,port;
	CStr(dom,256);
	CStr(host,256);

	lineScan(domain,dom);
	if( port = scanAuthServPort(dom,AVStr(host)) )
		sock = client_open(DGAUTHpro,DGAUTHpro,host,port);
	else	sock = DGAuth_port(0,AVStr(host),&port);

	if( 0 <= sock ){
		sv[0] = fdopen(sock,"r");
		sv[1] = fdopen(sock,"w");
		return 0;
	}
	return -1;
}
int remoteEditDGAuthUser(int com,PCStr(domain),PCStr(user),PCStr(pass))
{	int sock;
	CStr(epass,64);
	CStr(resp,256);
	CStr(req,256);
	CStr(ereq,256);
	FILE *sv[2],*tc,*fc;
	Credhy K[1]; /**/
	int qlen;

	if( connectDGAuth(domain,sv) == 0 ){
		if( CredhyClientStart("CREDHY",K,sv[1],sv[0],200) < 0 ){
			fclose(sv[1]);
			fclose(sv[0]);
			return -AUTH_ENOSERV;
		}
		tc = sv[1];
		fc = sv[0];
		if( com == 'a' )
			sprintf(req,"ADD %s %s",user,pass);
		else	sprintf(req,"DEL %s %s",user,pass);

		CredhyAencrypt(K,req,AVStr(ereq),sizeof(ereq));
		fprintf(tc,"%s\r\n",ereq);
		fflush(tc);
		*resp = 0;
		fgets(resp,sizeof(resp),fc);
		fclose(fc);
		fclose(tc);

		fprintf(stderr,"%s\n",resp);
		if( strncmp(resp,"+OK ",4) == 0 )
			return 0;
		if( atoi(resp) == 200 )
			return 0;
		else	return -AUTH_ENOUSER;
	}
	return -AUTH_ENOSERV;
}
int remoteGetDigestPass(PCStr(host),PCStr(user),PVStr(spass))
{	FILE *sv[2],*ts,*fs;
	CStr(req,256);
	CStr(ereq,256);
	CStr(resp,512);
	CStr(code,32);
	CStr(epass,512);
	int qlen,plen,len;
	Credhy K[1]; /**/

	plen = -1;
	if( connectDGAuth(host,sv) == 0 ){
		fs = sv[0];
		ts = sv[1];
		CredhyClientStart("CREDHY",K,sv[1],sv[0],200);
		sprintf(req,"GETPASS %s",user);
		CredhyAencrypt(K,req,AVStr(ereq),sizeof(ereq));

		fprintf(ts,"%s\r\n",ereq);
		fflush(ts);
		if( fgets(resp,sizeof(resp),fs) != NULL ){
			lineScan(wordScan(resp,code),epass);
			if( atoi(code) == 200 ){
			plen = CredhyAdecrypt(K,epass,AVStr(spass),sizeof(epass));
			}
		}
		fclose(ts);
		fclose(fs);
	}
	return plen;
}

/*
 * for -Fauth ... -dgauth
 */
int getCRYPTkey(Connection *Conn,int clnt,PVStr(ckey),int ksiz)
{ 
	scan_CRYPT(Conn,clnt);
	return getCKey(AVStr(ckey),ksiz);
}
int getEKey(Connection *ctx,FILE *tc,int com,PCStr(proto),PCStr(host),PCStr(port),PCStr(user),PCStr(pass),PVStr(ekey))
{	int elen;

	if( remoteEditDGAuthUser(com,host,user,pass) != -AUTH_ENOSERV )
		return 0;
	elen = getCRYPTkey(ctx,1,AVStr(ekey),128); /*ERR_sizeof(ekey));*/
	if( elen == 0 ){
		fprintf(tc,"-ERROR No Encryption Key\n");
		return 0;
	}
	if( checkEkey(1,proto,host,atoi(port),ekey) != 0 ){
		fprintf(tc,"-ERROR Bad Encryption Key\n");
		return 0;
	}
	return elen;
}

static int clockencdec(int enc,int clock)
{	int crc,xclock;

	return clock;
/*
	crc = NonceKeyCRC32();
	if( enc )
		xclock = (clock + crc) ^ crc;
	else	xclock = (clock ^ crc) - crc;
	if( crc & 1 )
		xclock = ~xclock;
	return xclock;
*/
}

void NonceKey(PVStr(key));
void genNonce(Connection *Conn,PCStr(uri),PVStr(nonce),int clock)
{	CStr(key,64);
	CStr(eclocks,64);
	CStr(nonce1,64);
	CStr(nonce2,64);
	CStr(nonce3,64);
	const char *dp;
	int eclock,crc;

	NonceKey(AVStr(key));
	sprintf(nonce1,"%x:%s",clock,key);
	toMD5(nonce1,nonce2);
	eclock = clockencdec(1,clock);
	sprintf(eclocks,"%x",eclock);
	crc = strCRC8(0,eclocks,strlen(eclocks));
	strreverse(eclocks);
	sprintf(nonce3,"%x.%s.%s",crc,eclocks,nonce2);
	str_to64(nonce3,strlen(nonce3),AVStr(nonce),64,1);
	if( dp = strpbrk(nonce,"\r\n") )
		truncVStr(dp);
}
static int scanNonceDate(PCStr(qnonce))
{	int nlen,xcrc,crc,xclock;
	CStr(dqnonce,64);
	CStr(eclocks,64);

	nlen = str_from64(qnonce,strlen(qnonce),AVStr(dqnonce),sizeof(dqnonce));
	if( nlen < 32 ){
		sv1log("## DGAuth: Invalid Nonce Format: %s [%s]\n",
			qnonce,dqnonce);
		return -1;
	}
	xcrc = -1;
	eclocks[0] = 0;
	Xsscanf(dqnonce,"%x.%[^.]",&xcrc,AVStr(eclocks));
	strreverse(eclocks);
	crc = strCRC8(0,eclocks,strlen(eclocks));
	if( xcrc != crc ){
		sv1log("## DGAuth: Invalid Nonce Clock: %X %X %s %s\n",
			crc,xcrc,eclocks,qnonce);
		return -1;
	}
	xclock = 0;
	sscanf(eclocks,"%x",&xclock);
	return xclock;
}

int genDigestNonce(Connection *Conn,AuthInfo *ident,PCStr(uri),PVStr(nonce))
{
	genNonce(Conn,uri,AVStr(nonce),time(0));
	return 1;
}
int genDigestResp(Connection *Conn,AuthInfo *ident,PVStr(xrealm),PCStr(uri),PVStr(nonce))
{	CStr(authserv,128);
	const char *dp;

	if( getMountAuthorizer(Conn,AVStr(authserv),sizeof(authserv)) ){
	}else
	if( find_CMAP(Conn,MAP_AUTHSERV,AVStr(authserv)) < 0 )
		return 0;
	if( !strneq(authserv,DGAUTHdom,7) )
		return 0;

	setVStrEnd(xrealm,0);
	if( dp = strchr(authserv,'@') ){
		linescanX(dp+1,AVStr(ident->i_realm),sizeof(ident->i_realm));
		strcpy(xrealm,ident->i_realm);
	}

	if( dp = strchr(authserv,',') )
		truncVStr(dp);

	if( dp = strstr(authserv,"//") )
		truncVStr(dp);

	if( xrealm[0] == 0 )
	if( authserv[7] == '.' )
		strcpy(xrealm,authserv+8);
	else	strcpy(xrealm,DGAuthDFLT_realm);

	genDigestNonce(Conn,ident,uri,AVStr(nonce));
	return 1;
}

void genDigestReq(AuthInfo *ident,PCStr(Method),PCStr(uri),PCStr(user),PCStr(pass),PCStr(realm),PCStr(nonce),PVStr(digest))
{	CStr(HA1,64);
	CStr(HA2,64);
	CStr(digestr,64);
	MD5 *md5;

	md5 = newMD5();
	addMD5(md5,user,strlen(user));
	addMD5(md5,":",1);
	addMD5(md5,realm,strlen(realm));
	addMD5(md5,":",1);
	addMD5(md5,pass,strlen(pass));
	endMD5(md5,digestr);
	MD5toa(digestr,HA1);

	md5 = newMD5();
	addMD5(md5,Method,strlen(Method));
	addMD5(md5,":",1);
	addMD5(md5,uri,strlen(uri));
	endMD5(md5,digestr);
	MD5toa(digestr,HA2);

	md5 = newMD5();
	addMD5(md5,HA1,strlen(HA1));
	addMD5(md5,":",1);

	addMD5(md5,nonce,strlen(nonce));
	if( ident && streq(ident->i_qop,"auth") ){
	addMD5(md5,":",1);
	addMD5(md5,ident->i_nc,strlen(ident->i_nc));
	addMD5(md5,":",1);
	addMD5(md5,ident->i_cnonce,strlen(ident->i_cnonce));
	addMD5(md5,":",1);
	addMD5(md5,ident->i_qop,strlen(ident->i_qop));
	}
	addMD5(md5,":",1);
	addMD5(md5,HA2,strlen(HA2));
	endMD5(md5,digestr);
	MD5toa(digestr,(char*)digest);
}

int localGetDigestPass(PCStr(host),PCStr(user),PVStr(spass));
int remoteHTTPreqDigest(FILE *afp,PCStr(user),PCStr(method),PCStr(uri),PCStr(realm),PCStr(nonce),PVStr(digest),AuthInfo *au);

int HTTP_authorize_Digest(Connection *Conn,AuthInfo *ident,PCStr(dom),PCStr(user),PCStr(dpass),PVStr(serv),int port)
{	int sock,xclock,clock,now,age,plen,rcode;
	FILE *tsfs;
	CStr(spass,128);
	CStr(nonce,64);
	CStr(digest,64);
	const char *uri = ident->i_path;
	const char *realm = ident->i_realm;
	const char *Method = ident->i_meth;
	const char *qnonce = ident->i_nonce;
	const char *xrealm;
	const char *vrealm;

	if( vrealm = strchr(dom,'@') ){ /* -dgauth[.realm]@vrealm */
		truncVStr(vrealm);
		vrealm++;
		xrealm = vrealm;
	}else
	if( xrealm = strchr(dom,'.') )
		xrealm++;
	else	xrealm = DGAuthDFLT_realm;
	if( strcmp(xrealm,realm) != 0 ){
		sv1log("## DGAuth: Invalid Realm: %s / %s\n",realm,xrealm);
		return -1;
	}

	xclock = scanNonceDate(qnonce);
	if( xclock == -1 )
		return -1;

	clock = clockencdec(0,xclock);
	now = time(0);
	age = now - clock;

	genNonce(Conn,uri,AVStr(nonce),clock);
	if( strcmp(qnonce,nonce) != 0 ){
		sv1log("## DGAuth: Invalid Nonce: Q=%s G=%s\n",qnonce,nonce);
		return -1;
	}

	if( serv[0] != 0 && port != 0 )
	/* explicit remote server */
	{
		sock = client_open(DGAUTHpro,DGAUTHpro,serv,port);
		if( sock < 0 ){
			sv1log("## DGAuth: Cannot Connext %s server [%s:%d]\n",
				DGAUTHpro,serv,port);
			ident->i_error |= AUTH_ENOSERV;
			return -1;
		}
		tsfs = fdopen(sock,"r+");
		goto REMOTE;
	}

	plen = localGetDigestPass(dom,user,AVStr(spass));
	if( 0 < plen )
	/* self */
	{
		genDigestReq(ident,Method,uri,user,spass,realm,nonce,AVStr(digest));
		bzero(spass,sizeof(spass));
		goto VALIDATE;
	}

	/* find implicit local sever */
	if( plen <= 0 )
	{
		tsfs = fopen_DGAuth();
		if( tsfs == NULL ){
			sock = DGAuth_port(0,AVStr(serv),&port);
			if( 0 <= sock ){
				tsfs = fdopen(sock,"r+");
			}
		}
		if( tsfs != NULL )
			goto REMOTE;

		if( plen == -AUTH_ENOUSER )
			ident->i_error |= AUTH_ENOUSER;
		else{
			ident->i_error |= AUTH_ENOSERV;
			sv1log("## DGAuth: No server\n");
		}
		return -1;
	}

REMOTE:
	rcode = remoteHTTPreqDigest(tsfs,user,Method,uri,realm,nonce,AVStr(digest),ident);
	fclose(tsfs);
	if( rcode != 0 ){
		sv1log("## DGAuth: Error from Server\n");
		return -1;
	}

VALIDATE:
/*
 fprintf(stderr,"#Q nonce=%s age=%d realm=[%s][%s]\n",nonce,age,realm,xrealm);
*/
	if( strcmp(digest,dpass) != 0 ){
		sv1log("## DGAuth: Invalid Nonce (%s)\n",dom);
		if( strcmp(dom,"-dgauth.-crypt") == 0 ){
			ident->i_stat |= AUTH_GEN;
		}
		return -1;
	}
	if( age < 0 ){
		sv1log("## DGAuth: Valid bad Future Nonce: age=%d %s\n",
			age,nonce);
		return -1;
	}
	if( NONCE_TIMEOUT < age ){
		sv1log("## DGAuth: Valid bad Stale Nonce: age=%d %s\n",
			age,nonce);
		ident->i_error |= AUTH_ESTALE;
		return -1;
	}

	sv1log("## DGAuth: Valid Digest, age=%d %s\n",age,nonce);
	return 0;
}
int authAPOP(Connection *Conn,PCStr(domain),PCStr(user),PCStr(seed),PVStr(mpass))
{	CStr(digest,64);
	CStr(pass,256);
	const char *pp;
	int plen;
	MD5 *md5;

	plen = getDigestPass(domain,user,AVStr(pass));
	sv1log("authAPOP(%s,%s) len=%d\n",user,seed,plen);
	if( plen < 0 ){
		sv1log("cannot get password for %s\n",user);
		return -1;
	}

	md5 = newMD5();
	addMD5(md5,seed,strlen(seed));
	addMD5(md5,pass,strlen(pass));
	endMD5(md5,digest);
	MD5toa(digest,(char*)mpass);

	for( pp = pass; *pp; pp++ )
		*(char*)pp = 0;
	return 0;
}

/*
 * check the correctness of encryption key
 * store the encryption key at the first store
 */
int authEdit(int detail,FILE *tc,int com,PCStr(proto),PCStr(host),int port,PCStr(user),PCStr(pass),PCStr(ekey),int expire);
void DGAuth_file(PVStr(path),PVStr(uh),PCStr(proto),PCStr(user),PCStr(host),int port);

int checkEkey(int store,PCStr(proto),PCStr(host),int port,PCStr(ekey))
{	CStr(path,1024);
	CStr(uh,1024);
	CStr(pw_md5,256);
	CStr(md5,64);
	CStr(amd5,64);
	FILE *fp;

	DGAuth_file(AVStr(path),AVStr(uh),proto,"-ADMIN-",host,port);
	if( fp = fopen(path,"r") ){
		*pw_md5 = 0;
		fgets(pw_md5,sizeof(pw_md5),fp);
		fclose(fp);
		wordScan(pw_md5,md5);
		toMD5(ekey,amd5);
		if( streq(md5,amd5) )
			return 0;
		else	return -AUTH_EBADCRYPT;
	}
	if( !store ){
		return -AUTH_EBADDOMAIN;
	}
	authEdit(1,stderr,'a',proto,host,port,"-ADMIN-",ekey,"",0);
	return 0;
}
int putDigestPass(FILE *fp,PCStr(fmt),PCStr(host),PCStr(user))
{	CStr(pass,64);

	if( getDigestPass(host,user,AVStr(pass)) < 0 )
		return -1;
	fprintf(fp,fmt,pass);
	bzero(pass,sizeof(pass));
	return 0;
}
int getDigestPass(PCStr(host),PCStr(user),PVStr(spass))
{	int plen;

	if( plen = remoteGetDigestPass(host,user,AVStr(spass)) )
		return plen;
	else	return localGetDigestPass(host,user,AVStr(spass));
}
static int getCKeyX(PCStr(host),PVStr(ekey),int size)
{	int elen;

	elen = getCKey(AVStr(ekey),size);
	if( elen <= 0 ){
		sv1log("## DGAuth: Decryption key is not available.\n");
		return -AUTH_ENOSERV;
	}
	if( checkEkey(0,DGAUTHpro,host,0,ekey) != 0 ){
		sv1log("## DGAuth: Decryption key is not correct.\n");
		sv1log("## DGAuth: disable the Decryption key.\n");
		setCKey("",0);
		return -AUTH_ENOSERV;
	}
	return elen;
}

/* the pass is encrypted string of user */
int genPass(PCStr(host),PCStr(user),PVStr(pass))
{	int elen,plen;
	CStr(ekey,64);

	elen = getCKeyX(host,AVStr(ekey),sizeof(ekey));
	if( elen < 0 ){
		sv1log("### genPass: CANT GET CKey\n");
		setVStrEnd(pass,0);
		return elen;
	}
	plen = aencrypty(ekey,elen,user,strlen(user),(char*)pass);
	setVStrEnd(pass,4);
	bzero(ekey,sizeof(ekey));
	return plen;
}
int localGetDigestPass(PCStr(host),PCStr(user),PVStr(spass))
{	CStr(uh,256);
	CStr(epath,1024);
	const char *dp;
	CStr(dpass,64);
	CStr(epass,128);
	CStr(xpass,256);
	CStr(pass_md5,64);
	CStr(ekey,128);
	FILE *afp;
	int elen,plen,ki;

	setVStrEnd(spass,0);
	if( host == 0 || *host == 0 )
		host = DGAUTHdom;

	if( strncmp(host,"-dgauth.-crypt",14) == 0 ){
		plen = genPass(host,user,AVStr(spass));
		sv1log("#### -dgauth.-crypt: user=%s pass=%s\n",user,spass);
		return plen;
	}

	DGAuth_file(AVStr(epath),AVStr(uh),DGAUTHpro,user,host,0);

	afp = fopen(epath,"r");
	if( afp == NULL ){
		sv1log("## DGAuth: No such user [%s] in %s auth.\n",user,host);
		return -AUTH_ENOUSER;
	}
	fgets(xpass,sizeof(xpass),afp);
	fclose(afp);
	dp = wordScan(xpass,dpass);
	dp = wordScan(dp,epass);

	/*
	elen = getCKey(AVStr(ekey),sizeof(ekey));
	if( elen <= 0 ){
		sv1log("## DGAuth: Decryption key is not available.\n");
		return -AUTH_ENOSERV;
	}
	if( checkEkey(0,DGAUTHpro,host,0,ekey) != 0 ){
		sv1log("## DGAuth: Decryption key is not correct.\n");
		sv1log("## DGAuth: disable the Decryption key.\n");
		setCKey("",0);
		return -AUTH_ENOSERV;
	}
	*/
	elen = getCKeyX(host,AVStr(ekey),sizeof(ekey));
	if( elen < 0 )
		return elen;

	plen = adecrypty(ekey,elen,epass,strlen(epass),(char*)spass);
	for( ki = 0; ki < elen; ki++ )
		ekey[ki] = 0;
	toMD5(spass,pass_md5);
	if( strcmp(dpass,pass_md5) != 0 ){
		sv1log("## DGAuth: Decryption key is wrong.\n");
		return -AUTH_ENOSERV;
	}
	return plen;
}

/*
 * HTTP user method uri realm nonce
 */
int remoteHTTPreqDigest(FILE *afp,PCStr(user),PCStr(method),PCStr(uri),PCStr(realm),PCStr(nonce),PVStr(digest),AuthInfo *au)
{	CStr(resp,256);
	CStr(code,32);
	const char *dp;
	const char *proto;
	CStr(erealm,256);

	if( streq(au->i_qop,"auth") )
		proto = "HTTPX";
	else	proto = "HTTP";

	url_escapeX(realm,AVStr(erealm),sizeof(erealm)," \t\r\n","");
	sv1log("DGAuth-CL: %s %s %s %s %s [%s %s %s] %s\r\n",
		proto,user,nonce,erealm,method,
		au->i_qop,au->i_cnonce,au->i_nc,uri);
	fprintf(afp,"%s %s %s %s %s ",proto,user,nonce,erealm,method);
	if( streq(au->i_qop,"auth") ){
		fprintf(afp,"%s %s %s ",au->i_qop,au->i_cnonce,au->i_nc);
	}
	fprintf(afp,"%s\r\n",uri);
	fflush(afp);
	if( fgets(resp,sizeof(resp),afp) != NULL ){
		dp = wordScan(resp,code);
		if( atoi(code) == 200 ){
			wordscanX(dp,AVStr(digest),64);
			return 0;
		}
	}
	return -1;
}
static int servHTTPreqDigest(FILE *tc,PCStr(com),PCStr(arg),PVStr(digest))
{	const char *av[16]; /**/
	const char *user;
	const char *method;
	const char *uri;
	const char *realm;
	const char *nonce;
	CStr(spass,128);
	int nac,ac,ai,plen;
	AuthInfo au;

	sv1log("DGAuth-SV: HTTP %s\r\n",arg);
	if( streq(com,"HTTPX") )
		nac = 8;
	else	nac = 5;
	ac = list2vect(arg,' ',nac,av);

	if( ac != nac ){
		fprintf(tc,"501 BAD arg. count(%d/%d)\r\n",ac,nac);
		return -1;
	}
	ai = 0;
	user = av[ai++];
	nonce = av[ai++];
	realm = av[ai++];
	method = av[ai++];

	bzero(&au,sizeof(AuthInfo));
	if( 5 < ac ){
		wordScan(av[ai++],au.i_qop);
		wordScan(av[ai++],au.i_cnonce);
		wordScan(av[ai++],au.i_nc);
	}

	uri = av[ai++];

	plen = localGetDigestPass("",user,AVStr(spass));
	if( plen <= 0 ){
		fprintf(tc,"502 BAD user\r\n");
		return -1;
	}
	genDigestReq(&au,method,uri,user,spass,realm,nonce,AVStr(digest));
	bzero(spass,sizeof(spass));
	return 0;
}

int service_DGAuth(Connection *Conn)
{	int elen,olen;
	CStr(req,1024);
	CStr(com,64);
	CStr(arg,1024);
	CStr(ekey,64);
	CStr(md5,64);
	const char *dp;
	CStr(out,256);
	FILE *fc,*tc;
	const char *av[8]; /**/
	int ac;
	CStr(digest,128);
	int rcode;
	Credhy K[1]; /**/
	int xskey;

	if( !source_permitted(Conn) ){
		CStr(shost,256);
		getClientHostPort(Conn,AVStr(shost));
		daemonlog("F","E-P: No permission: \"%s\" is not allowed (%s)\n",
			shost,Conn->reject_reason);
		return -1;
	}

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");
	elen = getCKey(AVStr(ekey),sizeof(ekey));
	if( elen == 1 && *ekey == '\n' ){
		*ekey = 0;
		elen = 0;
	}

	xskey = 0;
	for(;;){
		fflush(tc);
		if( fgets(req,sizeof(req),fc) == NULL ){
			break;
		}
		if( dp = strpbrk(req,"\r\n") )
			truncVStr(dp);
		if( xskey ){
			olen = CredhyAdecrypt(K,req,AVStr(req),sizeof(req));
			if( olen < 0 ){
				continue;
			}
		}
		dp = wordScan(req,com);
		dp = lineScan(dp,arg);
		sv1log("[%s] elen=%d\n",com,elen);

		if( strcaseeq(com,"CREDHY") ){
			CredhyServerStart(com,K,tc,fc,arg,200,500);
			xskey = 1;
			continue;
		}
		if( strcaseeq(com,"END") ){
			fprintf(tc,"200 bye.\r\n");
			break;
		}

		if( elen == 0 ){
			fprintf(tc,"500 encryption key is not set\n");
			continue;
		}
		if( strcaseeq(com,"HTTP") || strcaseeq(com,"HTTPX") ){
			rcode = servHTTPreqDigest(tc,com,arg,AVStr(digest));
			if( rcode == 0 )
				fprintf(tc,"200 %s\r\n",digest);
			continue;
		}
		if( strcaseeq(com,"APOP") ){
			/* APOP user seed */
			const char *user;
			const char *seed;
			ac = list2vect(arg,' ',2,av);
			if( ac != 2 ){
				fprintf(tc,"501 BAD arg. count(%d)\r\n",ac);
				continue;
			}
			user = av[0];
			seed = av[1];
			rcode = authAPOP(NULL,"",user,seed,AVStr(digest));
			if( rcode == 0 )
				fprintf(tc,"200 %s\r\n",digest);
			else	fprintf(tc,"500 internal error.\r\n");
			continue;
		}


		if( xskey == 0 ){
			fprintf(tc,"500 communication is not encrypted.\r\n");
			continue;
		}
		if( strcaseeq(com,"CLR") ){
			if( streq(arg,ekey) ){
				*ekey = 0;
				elen = 0;
				fprintf(tc,"200 OK, reset.\r\n");
			}else{
				fprintf(tc,"500 BAD, unmatch.\r\n");
			}
		}
		else
		if( strcaseeq(com,"KEY") ){
			if( elen != 0 ){
				fprintf(tc,"400 set already.\r\n");
				continue;
			}
			toMD5(arg,md5);
			/*
			if( !streq(md5,) ){
				fprintf(tc,"400\r\n");
				continue;
			}
			*/
			setCKey(arg,strlen(arg));
			elen = getCKey(AVStr(ekey),sizeof(ekey));
			fprintf(tc,"200 OK, set(%d).\r\n",elen);
		}
		else
		if( strcaseeq(com,"DEL") ){
			const char *user;
			const char *pass;
			ac = list2vect(arg,' ',2,av);
			if( ac != 2 ){
				fprintf(tc,"501 BAD arg. count(%d)\r\n",ac);
				continue;
			}
			user = av[0];
			pass = av[1];
			authEdit(0,tc,'d',DGAUTHpro,DGAUTHdom,0,user,pass,ekey,0);
			fprintf(tc,"200 removed\r\n");
		}
		else
		if( strcaseeq(com,"ADD") ){
			/* ADD user pass [dom] */
			const char *user;
			const char *pass;
			const char *realm;
			ac = list2vect(arg,' ',3,av);
			if( ac < 2 ){
				fprintf(tc,"501 BAD arg. count(%d)\r\n",ac);
				continue;
			}
			user = av[0];
			pass = av[1];
			if( 2 < ac )
				realm = av[2];
			else	realm = DGAUTHdom;
			sv1log("## DGAuth: %s %s *** %s\n",com,user,realm);

			rcode =
			authEdit(0,tc,'a',DGAUTHpro,realm,0,user,pass,ekey,0);
			if( rcode == 0 )
				fprintf(tc,"200 added\r\n");
			else	fprintf(tc,"500 error\r\n");
		}
		else
		if( strcaseeq(com,"AUTH") ){
			/* AUTH dom user pass */
		}
		else
		if( strcaseeq(com,"GETPASS") ){
			/* GETPASS user [dom] */
			const char *user;
			const char *dom;
			CStr(spass,256);

			ac = list2vect(arg,' ',2,av);
			if( ac == 0 ){
				fprintf(tc,"500 GETPASS user [domain]\r\n");
				continue;
			}
			user = av[0];
			if( 1 < ac )
				dom = av[1];
			else	dom = "";
			olen = localGetDigestPass(dom,arg,AVStr(spass));
			CredhyAencrypt(K,spass,AVStr(arg),sizeof(arg));
			bzero(spass,sizeof(spass));
			fprintf(tc,"200 %s\r\n",arg);
			sv1log("## 200 %s\n",arg);
		}
		else
		if( strcaseeq(com,"ENC") ){
			olen = aencrypty(ekey,elen,arg,strlen(arg),out);
			fprintf(tc,"200 %d %s\r\n",olen,out);
		}
		else
		if( strcaseeq(com,"DEC") ){
			if( 0 ){
				olen = adecrypty(ekey,elen,arg,strlen(arg),out);
				fprintf(tc,"200 %d %s\r\n",olen,out);
			}else{
				fprintf(tc,"403 Forbidden\r\n");
			}
		}
		else
		{
			break;
		}
	}
	fclose(tc);
	fclose(fc);
	return 0;
}

/*
 *
 */
typedef struct {
 unsigned int	o_start;
 unsigned int	o_count;
 unsigned short	o_pid;
 unsigned short	o_serno;
} Opaque;
#define OPQSIZE	(sizeof(Opaque)+2)
#define o_serno_multi(Op)	((char*)(&Op[1]))[0]
#define o_reqserno(Op)		((char*)(&Op[1]))[1]

void printOpaque(PVStr(opqs),Opaque *Op)
{	CStr(st,64);
	CStr(ser,32);

	StrftimeLocal(AVStr(st),sizeof(st),"%y%m%d-%H%M%S",Op->o_start,0);
	sprintf(ser,"%d+%d",Op->o_serno,o_serno_multi(Op));
	if( o_reqserno(Op) )
		Xsprintf(TVStr(ser),"+%d",o_reqserno(Op));
	sprintf(opqs,"%s.%d.%s.%d",st,Op->o_pid,ser,Op->o_count);
}
extern int CHILD_SERNO;
extern int CHILD_SERNO_MULTI;
void genSessionID(Connection *Conn,PVStr(opaque),int inc)
{	CStr(opq,128);
	CStr(opqs,128);
	CStr(key,64);
	const char *op;
	int olen,startu;
	Opaque Ops[2],*Op = &Ops[0];

	NonceKey(AVStr(key));
	bzero(Op,OPQSIZE);
	if( opaque[0] ){
		olen = adecrypty(key,strlen(key),opaque,strlen(opaque),opq);
		if( olen == OPQSIZE ){
			bcopy(opq,Op,OPQSIZE);
		}
		if( Op->o_pid != 0 && Op->o_start != 0 ){
/*
			printOpaque(AVStr(opqs),Op);
fprintf(stderr,"#### GET OPAQ %s %s\n",opqs,opaque);
*/
		}
	}
	if( Op->o_pid == 0 || Op->o_start == 0 ){
		Op->o_pid = serverPid();
		Op->o_start = time(0);
		Op->o_serno = CHILD_SERNO;
		o_serno_multi(Op) = CHILD_SERNO_MULTI;
		o_reqserno(Op) = RequestSerno;
	}
	Op->o_count += inc;

	olen = aencrypty(key,strlen(key),(char*)Op,OPQSIZE,(char*)opaque);
	printOpaque(AVStr(opqs),Op);
	if( Op->o_count == 0 ){
		daemonlog("F","NewSession %s\n",opqs);
	}
/*
fprintf(stderr,"#### NEW OPAQ %s %s\n",opqs,opaque);
*/
}
int decrypt_opaque(PCStr(opaque),PVStr(opqs))
{	CStr(opq,128);
	CStr(key,64);
	int olen;
	Opaque Ops[2],*Op = &Ops[0];

	NonceKey(AVStr(key));
	olen = adecrypty(key,strlen(key),opaque,strlen(opaque),opq);
	if( olen == OPQSIZE ){
		bcopy(opq,Op,OPQSIZE);
		printOpaque(AVStr(opqs),Op);
		return olen;
	}else{
		setVStrEnd(opqs,0);
		return 0;
	}
}


/*
 * a key to encrypt opaque or session-Id
 */
void NonceKey(PVStr(key))
{	CStr(dir,1024);
	CStr(path,1024);
	CStr(skey,256);
	FILE *fp;

	if( nonceKey[0] ){
		strcpy(key,nonceKey);
		return;
	}

	strcpy(dir,"${ADMDIR}/secret");
	DELEGATE_substfile(AVStr(dir),"",VStrNULL,VStrNULL,VStrNULL);
	sprintf(path,"%s/%s",dir,"noncekey");

	if( !File_is(path) ){
		if( fp = dirfopen("NonceKey",AVStr(path),"w") ){
			sv1log("#### NonceKey created: %s\n",path);
			fprintf(fp,"%d%d",getpid(),time(0));
			fclose(fp);	
			chmod(dir,0700);
			chmod(path,0400);
		}
	}
	skey[0] = 0;
	if( fp = fopen(path,"r") ){
		sprintf(skey,"%d.%d.",File_ctime(dir),File_mtime(path));
		Xfgets(TVStr(skey),sizeof(skey)-strlen(skey),fp);
		fclose(fp);
	}
	toMD5(skey,(char*)key);
	strcpy(nonceKey,key);
}
int NonceKeyCRC32()
{	CStr(key,64);
	int crc;

	NonceKey(AVStr(key));
	crc = strCRC32(key,strlen(key));
	return crc;
}
int NonceKeyCRC8()
{	CStr(key,64);
	int crc;

	NonceKey(AVStr(key));
	crc = strCRC8(0,key,strlen(key));
	return crc;
}
