/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2003 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for evaluation, copy this material for
your own use, and distribute the copies via publically accessible on-line
media, without fee, is hereby granted provided that the above copyright
notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	dgchroot.c
Author:		Yutaka Sato <ysato@delegate.org>
Description:

History:
	030125	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <errno.h>
#include "dgxauth.c"

int main(int ac,char *av[])
{	int rcode;
	const char *root;
	const char *path;
	int ai;
	CStr(cwd,1024);
	CStr(env,1024+8);

	dgxauth(ac,av);
	if( ac < 4 ){
		fprintf(stderr,"Usage: %s root path arg-list\n",av[0]);
		exit(-1);
	}
	root = av[1];
	path = av[2];

	chdir(root);
	if( chroot(root) != 0 ){
		fprintf(stderr,"ERROR: could not do chroot(%s), errno=%d\n",
			root,errno);
		exit(-1);
	}
	seteuid(getuid());
	chdir("/");

sleep(1); /* to avoid accidental tight loop ... */
fprintf(stderr,"#### execv(%s)...\n",path);

	/* THE path MUST be renamed at relative one from new-root */
	execv(path,&av[3]);

	perror("chroot");
	fprintf(stderr,"ERROR: could not exec(%s) at %s, errno=%d\n",
		path,cwd,errno);
	for( ai = 3 ; ai < ac; ai++ )
		fprintf(stderr,"[%d] %s\n",ai-3,av[ai]);
	return -1;
}
