#if defined(__cplusplus)
	// and if -lpthread is not confirmed to be available
	// then this module should not be included
#else
#include <pthread.h>
#endif

#include <stdlib.h>
#include "ystring.h"
#define STKSIZE 0x10000

static void *thread1(char *av[])
{	vFUNCP func;

	func = (vFUNCP)av[0];
	(*func)(av[1],av[2],av[3],av[4],av[5],av[6],av[7]);
	free(av);
	pthread_exit(0);
	porting_dbg("#### pthread_exit() failed.");
	exit(-1);
}

static pthread_t thread_fork(int ssize,IFUNCP func,...)
{	pthread_t thread;
	pthread_attr_t attr;
	void *arg;
	char **av;
	int err;
	int ai;
	VARGS(7,func);

	av = (char **)malloc(sizeof(void*)*8);
	av[0] = (char*)func;
	for( ai = 0; ai < 7; ai++ )
		av[1+ai] = va[ai];
	arg = (void*)av;

	if( ssize == 0 )
		ssize = STKSIZE;
	pthread_attr_init(&attr);
	pthread_attr_setstacksize(&attr,ssize);
	err = pthread_create(&thread,&attr,(void*(*)(void*))thread1,arg);
	if( err )
		porting_dbg("#### pthread_create() failed: %d",err);
	return thread;
}
static int thread_yield()
{
	return 0;
}

const char *WithThread = "pthread_create";
pthread_t (*ThreadFork)(int,IFUNCP,...) = thread_fork;
int (*ThreadYield)() = thread_yield;
